/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.configuration.internal;

import java.io.File;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.apache.felix.dm.Component;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationEvent;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.ObjectReader;
import org.opendaylight.controller.sal.utils.ObjectWriter;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerConfigurationService
implements IConfigurationContainerService,
IConfigurationAware,
ICacheUpdateAware<ConfigurationEvent, String> {
    public static final String CONTAINER_SAVE_EVENT_CACHE = "config.container.event.save";
    private static final Logger logger = LoggerFactory.getLogger(ContainerConfigurationService.class);
    private IClusterContainerServices clusterServices;
    private ConcurrentMap<ConfigurationEvent, String> containerConfigEvent;
    private Set<IConfigurationContainerAware> configurationAwareList = Collections.synchronizedSet(new HashSet());
    private String root;
    private ObjectReader objReader;
    private ObjectWriter objWriter;

    public void addConfigurationContainerAware(IConfigurationContainerAware configurationAware) {
        if (!this.configurationAwareList.contains(configurationAware)) {
            this.configurationAwareList.add(configurationAware);
        }
    }

    public int getConfigurationAwareListSize() {
        return this.configurationAwareList.size();
    }

    public void removeConfigurationContainerAware(IConfigurationContainerAware configurationAware) {
        this.configurationAwareList.remove(configurationAware);
    }

    public void setClusterServices(IClusterContainerServices i) {
        this.clusterServices = i;
        logger.debug("IClusterServices set");
    }

    public void unsetClusterServices(IClusterContainerServices i) {
        if (this.clusterServices == i) {
            this.clusterServices = null;
            logger.debug("IClusterServices Unset");
        }
    }

    void init(Component c) {
        boolean created;
        Dictionary props = c.getServiceProperties();
        String containerName = props != null ? (String)props.get("containerName") : GlobalConstants.DEFAULT.toString();
        this.root = String.format("%s%s/", GlobalConstants.STARTUPHOME.toString(), containerName);
        if (!new File(this.root).exists() && !(created = new File(this.root).mkdir())) {
            logger.error("Failed to create startup config directory for container {}", (Object)containerName);
        }
    }

    public void start() {
        this.allocateCache();
        this.retrieveCache();
        this.objReader = new ObjectReader();
        this.objWriter = new ObjectWriter();
    }

    public void destroy() {
        this.configurationAwareList.clear();
    }

    public void containerStop() {
        File[] files;
        for (File file : files = new File(this.root).listFiles()) {
            file.delete();
        }
        new File(this.root).delete();
    }

    public Status saveConfiguration() {
        boolean success = true;
        for (IConfigurationContainerAware configurationAware : this.configurationAwareList) {
            logger.trace("Save Config triggered for {}", (Object)configurationAware.getClass().getSimpleName());
            Status status = configurationAware.saveConfiguration();
            if (status.isSuccess()) continue;
            success = false;
            logger.warn("Failed to save config for {}", (Object)configurationAware.getClass().getSimpleName());
        }
        if (success) {
            return new Status(StatusCode.SUCCESS);
        }
        return new Status(StatusCode.INTERNALERROR, "Failed to Save All Configurations");
    }

    public Status saveConfigurations() {
        this.containerConfigEvent.put(ConfigurationEvent.SAVE, "");
        return this.saveConfiguration();
    }

    public void entryCreated(ConfigurationEvent key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
    }

    public void entryUpdated(ConfigurationEvent key, String new_value, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        logger.debug("Processing {} event", (Object)key);
        if (key == ConfigurationEvent.SAVE) {
            this.saveConfiguration();
        }
    }

    public void entryDeleted(ConfigurationEvent key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
    }

    private void allocateCache() {
        if (this.clusterServices == null) {
            logger.error("uninitialized clusterServices, can't create cache");
            return;
        }
        try {
            this.clusterServices.createCache(CONTAINER_SAVE_EVENT_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.debug("Error creating ContainerConfigurationService cache ", (Throwable)cce);
        }
        catch (CacheExistException cce) {
            logger.debug("ConfigurationService Cache already exists, destroy and recreate ", (Throwable)cce);
        }
    }

    private void retrieveCache() {
        if (this.clusterServices == null) {
            logger.error("uninitialized clusterServices, can't retrieve cache");
            return;
        }
        this.containerConfigEvent = this.clusterServices.getCache(CONTAINER_SAVE_EVENT_CACHE);
        if (this.containerConfigEvent == null) {
            logger.error("Failed to retrieve configuration Cache");
        }
    }

    public Status persistConfiguration(List<ConfigurationObject> config, String fileName) {
        String destination = String.format("%s%s", this.root, fileName);
        return this.objWriter.write(config, destination);
    }

    public List<ConfigurationObject> retrieveConfiguration(IObjectReader reader, String fileName) {
        if (!this.clusterServices.amICoordinator()) {
            return Collections.emptyList();
        }
        String source = String.format("%s%s", this.root, fileName);
        Object obj = this.objReader.read(reader, source);
        return obj == null || !(obj instanceof List) ? Collections.emptyList() : (List)obj;
    }
}

