/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.configuration.internal;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationEvent;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.ObjectReader;
import org.opendaylight.controller.sal.utils.ObjectWriter;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationService
implements IConfigurationService,
ICacheUpdateAware<ConfigurationEvent, String> {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationService.class);
    public static final String SAVE_EVENT_CACHE = "config.event.save";
    private static final Object ROOT = GlobalConstants.STARTUPHOME.toString();
    private IClusterGlobalServices clusterServices;
    private ConcurrentMap<ConfigurationEvent, String> configEvent;
    private Set<IConfigurationAware> configurationAwareList = Collections.synchronizedSet(new HashSet());
    private ObjectReader objReader;
    private ObjectWriter objWriter;

    public int getConfigurationAwareListSize() {
        return this.configurationAwareList.size();
    }

    public void addConfigurationAware(IConfigurationAware configurationAware) {
        if (!this.configurationAwareList.contains(configurationAware)) {
            this.configurationAwareList.add(configurationAware);
        }
    }

    public void removeConfigurationAware(IConfigurationAware configurationAware) {
        this.configurationAwareList.remove(configurationAware);
    }

    public void setClusterServices(IClusterGlobalServices i) {
        this.clusterServices = i;
        logger.debug("IClusterServices set");
    }

    public void unsetClusterServices(IClusterGlobalServices i) {
        if (this.clusterServices == i) {
            this.clusterServices = null;
            logger.debug("IClusterServices Unset");
        }
    }

    public void init() {
        logger.info("ConfigurationService Manager init");
    }

    public void start() {
        this.allocateCache();
        this.retrieveCache();
        this.objReader = new ObjectReader();
        this.objWriter = new ObjectWriter();
    }

    public void destroy() {
        this.configurationAwareList.clear();
    }

    public Status saveConfigurations() {
        if (this.configEvent != null) {
            this.configEvent.put(ConfigurationEvent.SAVE, "");
        }
        return this.saveConfigurationsInternal();
    }

    private Status saveConfigurationsInternal() {
        boolean success = true;
        for (IConfigurationAware configurationAware : this.configurationAwareList) {
            Status status = configurationAware.saveConfiguration();
            if (status.isSuccess()) continue;
            success = false;
            logger.warn("Failed to save config for {}", (Object)configurationAware.getClass().getName());
        }
        if (success) {
            return new Status(StatusCode.SUCCESS);
        }
        return new Status(StatusCode.INTERNALERROR, "Failed to Save All Configurations");
    }

    public void entryCreated(ConfigurationEvent key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
    }

    public void entryUpdated(ConfigurationEvent key, String new_value, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
        if (key == ConfigurationEvent.SAVE) {
            this.saveConfigurationsInternal();
        }
    }

    public void entryDeleted(ConfigurationEvent key, String cacheName, boolean originLocal) {
        if (originLocal) {
            return;
        }
    }

    private void allocateCache() {
        if (this.clusterServices == null) {
            logger.error("uninitialized clusterServices, can't create cache");
            return;
        }
        try {
            this.clusterServices.createCache(SAVE_EVENT_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
        }
        catch (CacheConfigException cce) {
            logger.debug("Error creating ConfigurationService cache ", (Throwable)cce);
        }
        catch (CacheExistException cce) {
            logger.debug("ConfigurationService Cache already exists, destroy and recreate ", (Throwable)cce);
        }
    }

    private void retrieveCache() {
        if (this.clusterServices == null) {
            logger.error("uninitialized clusterServices, can't retrieve cache");
            return;
        }
        this.configEvent = this.clusterServices.getCache(SAVE_EVENT_CACHE);
        if (this.configEvent == null) {
            logger.error("Failed to retrieve configuration Cache");
        }
    }

    public Status persistConfiguration(List<ConfigurationObject> config, String fileName) {
        String destination = String.format("%s%s", ROOT, fileName);
        return this.objWriter.write(config, destination);
    }

    public List<ConfigurationObject> retrieveConfiguration(IObjectReader reader, String fileName) {
        if (!this.clusterServices.amICoordinator()) {
            return Collections.emptyList();
        }
        String source = String.format("%s%s", ROOT, fileName);
        Object obj = this.objReader.read(reader, source);
        return obj == null || !(obj instanceof List) ? Collections.emptyList() : (List)obj;
    }
}

