/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.configuration.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.configuration.IConfigurationAware;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.configuration.internal.ConfigurationService;
import org.opendaylight.controller.configuration.internal.ContainerConfigurationService;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{ContainerConfigurationService.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(ContainerConfigurationService.class)) {
            Hashtable props = new Hashtable();
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("config.container.event.save");
            ((Dictionary)props).put("cachenames", propSet);
            c.setInterface(new String[]{IConfigurationContainerService.class.getName(), IConfigurationAware.class.getName(), ICacheUpdateAware.class.getName()}, props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IConfigurationContainerAware.class).setCallbacks("addConfigurationContainerAware", "removeConfigurationContainerAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterServices", "unsetClusterServices").setRequired(true));
        }
    }

    protected Object[] getGlobalImplementations() {
        Object[] res = new Object[]{ConfigurationService.class};
        return res;
    }

    protected void configureGlobalInstance(Component c, Object imp) {
        if (imp.equals(ConfigurationService.class)) {
            Hashtable props = new Hashtable();
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("config.event.save");
            ((Dictionary)props).put("cachenames", propSet);
            c.setInterface(new String[]{IConfigurationService.class.getName(), ICacheUpdateAware.class.getName()}, props);
            c.add((Dependency)this.createServiceDependency().setService(IClusterGlobalServices.class).setCallbacks("setClusterServices", "unsetClusterServices").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IConfigurationAware.class).setCallbacks("addConfigurationAware", "removeConfigurationAware").setRequired(false));
        }
    }
}

