/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker;

import java.io.Serializable;
import java.net.InetAddress;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.sal.packet.address.DataLinkAddress;

public class IPMacHostId
implements IHostId,
Serializable {
    private static final long serialVersionUID = 1L;
    private InetAddress ipAddress;
    private DataLinkAddress macAddr;

    public IPMacHostId(InetAddress ipAddress, DataLinkAddress macAddr) {
        this.ipAddress = ipAddress;
        this.macAddr = macAddr;
    }

    public InetAddress getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(InetAddress ipAddress) {
        this.ipAddress = ipAddress;
    }

    public DataLinkAddress getMacAddr() {
        return this.macAddr;
    }

    public void setMacAddr(DataLinkAddress macAddr) {
        this.macAddr = macAddr;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipAddress == null ? 0 : this.ipAddress.hashCode());
        result = 31 * result + (this.macAddr == null ? 0 : this.macAddr.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPMacHostId other = (IPMacHostId)obj;
        if (this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress)) {
            return false;
        }
        return !(this.macAddr == null ? other.macAddr != null : !this.macAddr.equals((Object)other.macAddr));
    }

    public static IHostId fromIPAndMac(InetAddress ip, DataLinkAddress mac) {
        return new IPMacHostId(ip, mac);
    }
}

