/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.hosttracker;

import java.net.InetAddress;
import org.opendaylight.controller.hosttracker.IHostId;
import org.opendaylight.controller.hosttracker.IPHostId;
import org.opendaylight.controller.hosttracker.IPMacHostId;
import org.opendaylight.controller.sal.packet.address.DataLinkAddress;

public class HostIdFactory {
    public static final String DEFAULT_IP_KEY_SCHEME = "IP";
    public static final String IP_MAC_KEY_SCHEME = "IP+MAC";
    private static String scheme = null;

    public static String getScheme() {
        return scheme;
    }

    public static IHostId create(InetAddress ip, DataLinkAddress mac) {
        IPHostId ipHostId = new IPHostId(ip);
        if (scheme != null) {
            switch (scheme) {
                case "IP": {
                    return ipHostId;
                }
                case "IP+MAC": {
                    IPMacHostId ipMacHostId = new IPMacHostId(ip, mac);
                    return ipMacHostId;
                }
            }
            return ipHostId;
        }
        return ipHostId;
    }

    static {
        scheme = System.getProperty("hosttracker.keyscheme");
    }
}

