/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.api.jmx;

import java.util.Set;
import javax.management.NotificationBroadcasterSupport;
import org.opendaylight.controller.netconf.api.jmx.NetconfJMXNotification;
import org.w3c.dom.Element;

public class CommitJMXNotification
extends NetconfJMXNotification {
    private final Element configSnapshot;
    private static final String afterCommitMessageTemplate = "Commit successful: %s";
    private final Set<String> capabilities;
    private static final long serialVersionUID = -8587623362011695514L;

    CommitJMXNotification(NotificationBroadcasterSupport source, String message, Element cfgSnapshot, Set<String> capabilities) {
        super(NetconfJMXNotification.TransactionProviderJMXNotificationType.commit, source, String.format(afterCommitMessageTemplate, message));
        this.configSnapshot = cfgSnapshot;
        this.capabilities = capabilities;
    }

    public Element getConfigSnapshot() {
        return this.configSnapshot;
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("CommitJMXNotification{");
        sb.append("configSnapshot=").append(this.configSnapshot);
        sb.append(", capabilities=").append(this.getCapabilities());
        sb.append('}');
        return sb.toString();
    }
}

