/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.api;

import io.netty.channel.Channel;
import java.io.IOException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.protocol.framework.AbstractProtocolSession;
import org.opendaylight.protocol.framework.ProtocolSession;
import org.opendaylight.protocol.framework.SessionListener;
import org.opendaylight.protocol.framework.TerminationReason;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NetconfSession
extends AbstractProtocolSession<NetconfMessage> {
    protected final Channel channel;
    private final SessionListener sessionListener;
    private final long sessionId;
    private boolean up = false;
    private static final Logger logger = LoggerFactory.getLogger(NetconfSession.class);

    protected NetconfSession(SessionListener sessionListener, Channel channel, long sessionId) {
        this.sessionListener = sessionListener;
        this.channel = channel;
        this.sessionId = sessionId;
        logger.debug("Session {} created", (Object)this.toString());
    }

    public void close() {
        this.channel.close();
        this.up = false;
        this.sessionListener.onSessionTerminated((ProtocolSession)this, (TerminationReason)new NetconfTerminationReason("Session closed"));
    }

    protected void handleMessage(NetconfMessage netconfMessage) {
        logger.debug("handling incoming message");
        this.sessionListener.onMessage((ProtocolSession)this, (Object)netconfMessage);
    }

    public void sendMessage(NetconfMessage netconfMessage) {
        this.channel.writeAndFlush((Object)netconfMessage);
    }

    protected void endOfInput() {
        logger.debug("Session {} end of input detected while session was in state {}", (Object)this.toString(), (Object)(this.isUp() ? "up" : "initialized"));
        if (this.isUp()) {
            this.sessionListener.onSessionDown((ProtocolSession)this, (Exception)new IOException("End of input detected. Close the session."));
        }
    }

    protected void sessionUp() {
        logger.debug("Session {} up", (Object)this.toString());
        this.sessionListener.onSessionUp((ProtocolSession)this);
        this.up = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("ServerNetconfSession{");
        sb.append("sessionId=").append(this.sessionId);
        sb.append('}');
        return sb.toString();
    }

    public boolean isUp() {
        return this.up;
    }

    public long getSessionId() {
        return this.sessionId;
    }
}

