/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.api;

import java.util.Collections;
import java.util.Map;
import org.opendaylight.protocol.framework.DocumentedException;

public class NetconfDocumentedException
extends DocumentedException {
    private static final long serialVersionUID = 1L;
    private final ErrorType errorType;
    private final ErrorTag errorTag;
    private final ErrorSeverity errorSeverity;
    private final Map<String, String> errorInfo;

    public NetconfDocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, errorType, errorTag, errorSeverity, Collections.emptyMap());
    }

    public NetconfDocumentedException(String message, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public NetconfDocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity) {
        this(message, cause, errorType, errorTag, errorSeverity, Collections.emptyMap());
    }

    public NetconfDocumentedException(String message, Exception cause, ErrorType errorType, ErrorTag errorTag, ErrorSeverity errorSeverity, Map<String, String> errorInfo) {
        super(message, cause);
        this.errorType = errorType;
        this.errorTag = errorTag;
        this.errorSeverity = errorSeverity;
        this.errorInfo = errorInfo;
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    public ErrorTag getErrorTag() {
        return this.errorTag;
    }

    public ErrorSeverity getErrorSeverity() {
        return this.errorSeverity;
    }

    public Map<String, String> getErrorInfo() {
        return this.errorInfo;
    }

    public String toString() {
        return "NetconfDocumentedException{message=" + this.getMessage() + ", errorType=" + (Object)((Object)this.errorType) + ", errorTag=" + (Object)((Object)this.errorTag) + ", errorSeverity=" + (Object)((Object)this.errorSeverity) + ", errorInfo=" + this.errorInfo + '}';
    }

    public static enum ErrorSeverity {
        error,
        warning;


        public String getTagValue() {
            return this.name();
        }
    }

    public static enum ErrorTag {
        missing_attribute("missing-attribute"),
        unknown_element("unknown-element"),
        operation_not_supported("operation-not-supported"),
        bad_attribute("bad-attribute"),
        data_missing("data-missing"),
        operation_failed("operation-failed"),
        invalid_value("invalid-value"),
        malformed_message("malformed-message");

        private final String tagValue;

        private ErrorTag(String tagValue) {
            this.tagValue = tagValue;
        }

        public String getTagValue() {
            return this.tagValue;
        }
    }

    public static enum ErrorType {
        transport,
        rpc,
        protocol,
        application;


        public String getTagValue() {
            return this.name();
        }
    }
}

