/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.file.xml.model;

import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.persistence.jaxb.JAXBContextFactory;
import org.opendaylight.controller.config.persist.storage.file.xml.model.ConfigSnapshot;
import org.opendaylight.controller.config.persist.storage.file.xml.model.PersistException;

@XmlRootElement(name="persisted-snapshots")
public final class Config {
    private List<ConfigSnapshot> snapshots;

    Config(List<ConfigSnapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public Config() {
        this.snapshots = Lists.newArrayList();
    }

    @XmlElement(name="snapshot")
    @XmlElementWrapper(name="snapshots")
    public List<ConfigSnapshot> getSnapshots() {
        return this.snapshots;
    }

    public void setSnapshots(List<ConfigSnapshot> snapshots) {
        this.snapshots = snapshots;
    }

    public void toXml(File to) {
        try {
            JAXBContext jaxbContext = JAXBContextFactory.createContext((Class[])new Class[]{Config.class}, null);
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.marshal((Object)this, to);
        }
        catch (JAXBException e) {
            throw new PersistException("Unable to persist configuration", (Exception)((Object)e));
        }
    }

    public static Config fromXml(File from) {
        if (Config.isEmpty(from)) {
            return new Config();
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
            Unmarshaller um = jaxbContext.createUnmarshaller();
            return (Config)um.unmarshal(from);
        }
        catch (JAXBException e) {
            throw new PersistException("Unable to restore configuration", (Exception)((Object)e));
        }
    }

    private static boolean isEmpty(File from) {
        return from.length() == 0L || Config.isBlank(from);
    }

    private static boolean isBlank(File from) {
        try {
            return StringUtils.isBlank((CharSequence)Files.toString((File)from, (Charset)Charsets.UTF_8));
        }
        catch (IOException e) {
            throw new IllegalStateException("Unexpected error reading file" + from, e);
        }
    }

    public Optional<ConfigSnapshot> getLastSnapshot() {
        ConfigSnapshot last = (ConfigSnapshot)Iterables.getLast(this.snapshots, null);
        return last == null ? Optional.absent() : Optional.of((Object)last);
    }

    public void addConfigSnapshot(ConfigSnapshot snap, int numberOfStoredBackups) {
        if (this.shouldReplaceLast(numberOfStoredBackups) && !this.snapshots.isEmpty()) {
            this.snapshots.remove(0);
        }
        this.snapshots.add(snap);
    }

    private boolean shouldReplaceLast(int numberOfStoredBackups) {
        return numberOfStoredBackups == this.snapshots.size();
    }
}

