/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.xml;

import com.google.common.base.Preconditions;
import java.io.File;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.api.PropertiesProvider;
import org.opendaylight.controller.config.persist.api.StorageAdapter;
import org.opendaylight.controller.config.persist.storage.directory.xml.XmlDirectoryPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDirectoryStorageAdapter
implements StorageAdapter {
    private static final Logger logger = LoggerFactory.getLogger(XmlDirectoryStorageAdapter.class);
    public static final String DIRECTORY_STORAGE_PROP = "directoryStorage";

    public Persister instantiate(PropertiesProvider propertiesProvider) {
        String fileStorageProperty = propertiesProvider.getProperty(DIRECTORY_STORAGE_PROP);
        Preconditions.checkNotNull((Object)fileStorageProperty, (Object)("Unable to find " + propertiesProvider.getFullKeyForReporting(DIRECTORY_STORAGE_PROP)));
        File storage = new File(fileStorageProperty);
        logger.debug("Using {}", (Object)storage);
        return new XmlDirectoryPersister(storage);
    }
}

