/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.xml;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.SortedSet;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.storage.file.xml.model.ConfigSnapshot;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlDirectoryPersister
implements Persister {
    private static final Logger logger = LoggerFactory.getLogger(XmlDirectoryPersister.class);
    private final File storage;

    public XmlDirectoryPersister(File storage) {
        Preconditions.checkArgument((storage.exists() && storage.isDirectory() ? 1 : 0) != 0, (Object)("Storage directory does not exist: " + storage));
        this.storage = storage;
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        throw new UnsupportedOperationException("This adapter is read only. Please set readonly=true on " + this.getClass());
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        File[] filesArray = this.storage.listFiles();
        if (filesArray == null || filesArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> sortedFiles = new ArrayList<File>(Arrays.asList(filesArray));
        Collections.sort(sortedFiles);
        logger.debug("Reading files in following order: {}", sortedFiles);
        ArrayList<ConfigSnapshotHolder> result = new ArrayList<ConfigSnapshotHolder>();
        for (File file : sortedFiles) {
            logger.trace("Adding file '{}' to combined result", (Object)file);
            ConfigSnapshotHolder h = this.fromXmlSnapshot(file);
            result.add(h);
        }
        return result;
    }

    private ConfigSnapshotHolder fromXmlSnapshot(File file) {
        try {
            return XmlDirectoryPersister.loadLastConfig(file);
        }
        catch (JAXBException e) {
            logger.warn("Unable to restore configuration snapshot from {}", (Object)file, (Object)e);
            throw new IllegalStateException("Unable to restore configuration snapshot from " + file, e);
        }
    }

    public static ConfigSnapshotHolder loadLastConfig(File file) throws JAXBException {
        JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConfigSnapshot.class});
        Unmarshaller um = jaxbContext.createUnmarshaller();
        return XmlDirectoryPersister.asHolder((ConfigSnapshot)um.unmarshal(file));
    }

    private static ConfigSnapshotHolder asHolder(final ConfigSnapshot unmarshalled) {
        return new ConfigSnapshotHolder(){

            public String getConfigSnapshot() {
                return unmarshalled.getConfigSnapshot();
            }

            public SortedSet<String> getCapabilities() {
                return unmarshalled.getCapabilities();
            }

            public String toString() {
                return unmarshalled.toString();
            }
        };
    }

    public void close() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XmlDirectoryPersister{");
        sb.append("storage=").append(this.storage);
        sb.append('}');
        return sb.toString();
    }
}

