/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.autodetect;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;

enum FileType {
    plaintext,
    xml;

    public static final String XML_STORAGE_FIRST_LINE = "<snapshot>";
    private static final String XML_FILE_DEFINITION_LINE = "<?xml";

    static FileType getFileType(File file) {
        String firstLine = FileType.readFirstLine(file);
        if (FileType.isPlaintextStorage(firstLine)) {
            return plaintext;
        }
        if (FileType.isXmlStorage(firstLine)) {
            return xml;
        }
        throw new IllegalArgumentException("File " + file + " is not of permitted storage type: " + Arrays.toString((Object[])FileType.values()));
    }

    private static boolean isXmlStorage(String firstLine) {
        boolean isXml = false;
        isXml |= firstLine.startsWith(XML_STORAGE_FIRST_LINE);
        return isXml |= firstLine.startsWith(XML_FILE_DEFINITION_LINE);
    }

    private static boolean isPlaintextStorage(String firstLine) {
        return firstLine.startsWith("//MODULES START");
    }

    @VisibleForTesting
    static String readFirstLine(File file) {
        FirstLineReadingProcessor callback = new FirstLineReadingProcessor();
        try {
            return (String)Files.readLines((File)file, (Charset)Charsets.UTF_8, (LineProcessor)callback);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to detect file type of file " + file, e);
        }
    }

    private static class FirstLineReadingProcessor
    implements LineProcessor<String> {
        private String firstNonBlankLine;

        private FirstLineReadingProcessor() {
        }

        public boolean processLine(String line) throws IOException {
            if (this.isEmptyLine(line)) {
                return true;
            }
            this.firstNonBlankLine = line.trim();
            return false;
        }

        private boolean isEmptyLine(String line) {
            return StringUtils.isBlank((CharSequence)line);
        }

        public String getResult() {
            return this.firstNonBlankLine;
        }
    }
}

