/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory.autodetect;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.JAXBException;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.storage.directory.DirectoryPersister;
import org.opendaylight.controller.config.persist.storage.directory.autodetect.FileType;
import org.opendaylight.controller.config.persist.storage.directory.xml.XmlDirectoryPersister;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutodetectDirectoryPersister
implements Persister {
    private static final Logger logger = LoggerFactory.getLogger(AutodetectDirectoryPersister.class);
    private final File storage;

    public AutodetectDirectoryPersister(File storage) {
        Preconditions.checkArgument((storage.exists() && storage.isDirectory() ? 1 : 0) != 0, (Object)("Storage directory does not exist: " + storage));
        this.storage = storage;
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        throw new UnsupportedOperationException("This adapter is read only. Please set readonly=true on " + this.getClass());
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        File[] filesArray = this.storage.listFiles();
        if (filesArray == null || filesArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> sortedFiles = new ArrayList<File>(Arrays.asList(filesArray));
        Collections.sort(sortedFiles);
        logger.debug("Reading files in following order: {}", sortedFiles);
        ArrayList<ConfigSnapshotHolder> result = new ArrayList<ConfigSnapshotHolder>();
        for (File file : sortedFiles) {
            logger.trace("Adding file '{}' to combined result", (Object)file);
            FileType fileType = FileType.getFileType(file);
            logger.trace("File '{}' detected as {} storage", (Object)file, (Object)fileType);
            ConfigSnapshotHolder snapshot = this.loadLastConfig(file, fileType);
            result.add(snapshot);
        }
        return result;
    }

    private ConfigSnapshotHolder loadLastConfig(File file, FileType fileType) throws IOException {
        switch (fileType) {
            case plaintext: {
                logger.warn("Plaintext configuration files are deprecated, and will not be supported in future versions. Use xml files instead");
                return DirectoryPersister.loadLastConfig(file);
            }
            case xml: {
                try {
                    return XmlDirectoryPersister.loadLastConfig(file);
                }
                catch (JAXBException e) {
                    logger.warn("Unable to restore configuration snapshot from {}", (Object)file, (Object)e);
                    throw new IllegalStateException("Unable to restore configuration snapshot from " + file, e);
                }
            }
        }
        throw new IllegalStateException("Unknown storage type " + (Object)((Object)fileType));
    }

    public void close() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("AutodetectDirectoryPersister{");
        sb.append("storage=").append(this.storage);
        sb.append('}');
        return sb.toString();
    }
}

