/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory;

import com.google.common.base.Preconditions;
import com.google.common.io.LineProcessor;
import java.io.IOException;
import java.util.Arrays;
import java.util.SortedSet;
import java.util.TreeSet;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolderImpl;

class MyLineProcessor
implements LineProcessor<String> {
    private final String fileNameForReporting;
    private boolean inModules;
    private boolean inServices;
    private boolean inCapabilities;
    private final StringBuffer modulesBuffer = new StringBuffer();
    private final StringBuffer servicesBuilder = new StringBuffer();
    private final SortedSet<String> caps = new TreeSet<String>();

    MyLineProcessor(String fileNameForReporting) {
        this.fileNameForReporting = fileNameForReporting;
    }

    public String getResult() {
        return null;
    }

    public boolean processLine(String line) throws IOException {
        String lineWithNewLine = line + System.lineSeparator();
        if (line.equals("//MODULES START")) {
            Preconditions.checkState((!this.inModules && !this.inServices && !this.inCapabilities ? 1 : 0) != 0);
            this.inModules = true;
        } else if (line.equals("//SERVICES START")) {
            Preconditions.checkState((this.inModules && !this.inServices && !this.inCapabilities ? 1 : 0) != 0);
            this.inModules = false;
            this.inServices = true;
        } else if (line.equals("//CAPABILITIES START")) {
            Preconditions.checkState((!this.inModules && this.inServices && !this.inCapabilities ? 1 : 0) != 0);
            this.inServices = false;
            this.inCapabilities = true;
        } else if (this.inModules) {
            this.modulesBuffer.append(lineWithNewLine);
        } else if (this.inServices) {
            this.servicesBuilder.append(lineWithNewLine);
        } else {
            this.caps.add(line);
        }
        return true;
    }

    private void checkFileConsistency() {
        Preconditions.checkState((boolean)this.inCapabilities, (String)"File %s is missing delimiters in this order: %s", (Object[])new Object[]{this.fileNameForReporting, Arrays.asList("//MODULES START", "//SERVICES START", "//CAPABILITIES START")});
    }

    String getModules() {
        this.checkFileConsistency();
        return this.modulesBuffer.toString();
    }

    String getServices() {
        this.checkFileConsistency();
        return this.servicesBuilder.toString();
    }

    SortedSet<String> getCapabilities() {
        this.checkFileConsistency();
        return this.caps;
    }

    ConfigSnapshotHolder getConfigSnapshotHolder(String header, String middle, String footer) {
        String combinedSnapshot = header + this.getModules() + middle + this.getServices() + footer;
        ConfigSnapshotHolderImpl result = new ConfigSnapshotHolderImpl(combinedSnapshot, this.getCapabilities(), this.fileNameForReporting);
        return result;
    }
}

