/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.persist.storage.directory;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.common.io.LineProcessor;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.opendaylight.controller.config.persist.api.ConfigSnapshotHolder;
import org.opendaylight.controller.config.persist.api.Persister;
import org.opendaylight.controller.config.persist.storage.directory.MyLineProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirectoryPersister
implements Persister {
    private static final Logger logger = LoggerFactory.getLogger(DirectoryPersister.class);
    private static final Charset ENCODING = Charsets.UTF_8;
    public static final String MODULES_START = "//MODULES START";
    static final String SERVICES_START = "//SERVICES START";
    static final String CAPABILITIES_START = "//CAPABILITIES START";
    private final File storage;
    private static final String header = DirectoryPersister.readResource("header.txt");
    private static final String middle = DirectoryPersister.readResource("middle.txt");
    private static final String footer = DirectoryPersister.readResource("footer.txt");

    public DirectoryPersister(File storage) {
        Preconditions.checkArgument((storage.exists() && storage.isDirectory() ? 1 : 0) != 0, (Object)("Storage directory does not exist: " + storage));
        this.storage = storage;
    }

    private static String readResource(String resource) {
        try {
            return IOUtils.toString((InputStream)DirectoryPersister.class.getResourceAsStream("/" + resource));
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot load " + resource, e);
        }
    }

    public void persistConfig(ConfigSnapshotHolder holder) throws IOException {
        throw new UnsupportedOperationException("This adapter is read only. Please set readonly=true on " + this.getClass());
    }

    public List<ConfigSnapshotHolder> loadLastConfigs() throws IOException {
        File[] filesArray = this.storage.listFiles();
        if (filesArray == null || filesArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<File> sortedFiles = new ArrayList<File>(Arrays.asList(filesArray));
        Collections.sort(sortedFiles);
        logger.debug("Reading files in following order: {}", sortedFiles);
        ArrayList<ConfigSnapshotHolder> result = new ArrayList<ConfigSnapshotHolder>();
        for (File file : sortedFiles) {
            logger.trace("Adding file '{}' to combined result", (Object)file);
            ConfigSnapshotHolder configSnapshotHolder = DirectoryPersister.loadLastConfig(file);
            result.add(configSnapshotHolder);
        }
        return result;
    }

    public static ConfigSnapshotHolder loadLastConfig(File file) throws IOException {
        MyLineProcessor lineProcessor = new MyLineProcessor(file.getAbsolutePath());
        Files.readLines((File)file, (Charset)ENCODING, (LineProcessor)lineProcessor);
        return lineProcessor.getConfigSnapshotHolder(header, middle, footer);
    }

    public void close() {
    }

    public String toString() {
        return "FileStorageAdapter [storage=" + this.storage + "]";
    }
}

