/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Optional;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.net.InetSocketAddress;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.controller.netconf.client.NetconfClientDispatcher;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionListener;
import org.opendaylight.controller.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.controller.netconf.util.AbstractChannelInitializer;
import org.opendaylight.controller.netconf.util.handler.ssh.SshHandler;
import org.opendaylight.controller.netconf.util.handler.ssh.authentication.AuthenticationHandler;
import org.opendaylight.controller.netconf.util.handler.ssh.client.Invoker;
import org.opendaylight.controller.netconf.util.messages.NetconfMessageFactory;
import org.opendaylight.protocol.framework.AbstractDispatcher;
import org.opendaylight.protocol.framework.ProtocolHandlerFactory;
import org.opendaylight.protocol.framework.ProtocolMessageDecoder;
import org.opendaylight.protocol.framework.ProtocolMessageEncoder;
import org.opendaylight.protocol.framework.ProtocolMessageFactory;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.SessionListener;
import org.opendaylight.protocol.framework.SessionListenerFactory;

public class NetconfSshClientDispatcher
extends NetconfClientDispatcher {
    private AuthenticationHandler authHandler;
    private HashedWheelTimer timer;
    private NetconfClientSessionNegotiatorFactory negotatorFactory;

    public NetconfSshClientDispatcher(AuthenticationHandler authHandler, EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        super(bossGroup, workerGroup);
        this.authHandler = authHandler;
        this.timer = new HashedWheelTimer();
        this.negotatorFactory = new NetconfClientSessionNegotiatorFactory((Timer)this.timer, (Optional<String>)Optional.absent());
    }

    public NetconfSshClientDispatcher(AuthenticationHandler authHandler, EventLoopGroup bossGroup, EventLoopGroup workerGroup, String additionalHeader) {
        super(bossGroup, workerGroup, additionalHeader);
        this.authHandler = authHandler;
        this.timer = new HashedWheelTimer();
        this.negotatorFactory = new NetconfClientSessionNegotiatorFactory((Timer)this.timer, (Optional<String>)Optional.of((Object)additionalHeader));
    }

    @Override
    public Future<NetconfClientSession> createClient(InetSocketAddress address, final NetconfClientSessionListener sessionListener, ReconnectStrategy strat) {
        return super.createClient(address, strat, (AbstractDispatcher.PipelineInitializer)new AbstractDispatcher.PipelineInitializer<NetconfClientSession>(){

            public void initializeChannel(SocketChannel arg0, Promise<NetconfClientSession> arg1) {
                new NetconfSshClientInitializer(NetconfSshClientDispatcher.this.authHandler, NetconfSshClientDispatcher.this.negotatorFactory, sessionListener).initialize(arg0, arg1);
            }
        });
    }

    private static final class NetconfHandlerFactory
    extends ProtocolHandlerFactory<NetconfMessage> {
        public NetconfHandlerFactory(NetconfMessageFactory msgFactory) {
            super((ProtocolMessageFactory)msgFactory);
        }

        public ChannelHandler[] getEncoders() {
            return new ChannelHandler[]{new ProtocolMessageEncoder(this.msgFactory)};
        }

        public ChannelHandler[] getDecoders() {
            return new ChannelHandler[]{new ProtocolMessageDecoder(this.msgFactory)};
        }
    }

    private static final class NetconfSshClientInitializer
    extends AbstractChannelInitializer {
        private final NetconfHandlerFactory handlerFactory = new NetconfHandlerFactory(new NetconfMessageFactory());
        private final AuthenticationHandler authenticationHandler;
        private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
        private final NetconfClientSessionListener sessionListener;

        public NetconfSshClientInitializer(AuthenticationHandler authHandler, NetconfClientSessionNegotiatorFactory negotiatorFactory, NetconfClientSessionListener sessionListener) {
            this.authenticationHandler = authHandler;
            this.negotiatorFactory = negotiatorFactory;
            this.sessionListener = sessionListener;
        }

        public void initialize(SocketChannel ch, Promise<? extends NetconfSession> promise) {
            try {
                Invoker invoker = Invoker.subsystem((String)"netconf");
                ch.pipeline().addFirst(new ChannelHandler[]{new SshHandler(this.authenticationHandler, invoker)});
                super.initialize(ch, promise);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        protected void initializeAfterDecoder(SocketChannel ch, Promise<? extends NetconfSession> promise) {
            ch.pipeline().addLast("negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator(new SessionListenerFactory(){

                public SessionListener<NetconfMessage, NetconfClientSession, NetconfTerminationReason> getSessionListener() {
                    return NetconfSshClientInitializer.this.sessionListener;
                }
            }, (Channel)ch, promise));
        }
    }
}

