/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.io.IOException;
import java.io.InputStream;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSessionPreferences;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionNegotiator;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.SessionListenerFactory;
import org.opendaylight.protocol.framework.SessionNegotiator;
import org.opendaylight.protocol.framework.SessionNegotiatorFactory;
import org.xml.sax.SAXException;

public class NetconfClientSessionNegotiatorFactory
implements SessionNegotiatorFactory {
    private final Timer timer;
    private final Optional<String> additionalHeader;

    public NetconfClientSessionNegotiatorFactory(Timer timer, Optional<String> additionalHeader) {
        this.timer = timer;
        this.additionalHeader = additionalHeader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static NetconfMessage loadHelloMessageTemplate() {
        String helloMessagePath = "/client_hello.xml";
        try (InputStream is = NetconfClientSessionNegotiatorFactory.class.getResourceAsStream("/client_hello.xml");){
            Preconditions.checkState((is != null ? 1 : 0) != 0, (String)"Input stream from %s was null", (Object[])new Object[]{"/client_hello.xml"});
            NetconfMessage netconfMessage = new NetconfMessage(XmlUtil.readXmlToDocument((InputStream)is));
            return netconfMessage;
        }
        catch (IOException | SAXException e) {
            throw new RuntimeException("Unable to load hello message", e);
        }
    }

    public SessionNegotiator getSessionNegotiator(SessionListenerFactory sessionListenerFactory, Channel channel, Promise promise) {
        NetconfMessage helloMessage = NetconfClientSessionNegotiatorFactory.loadHelloMessageTemplate();
        if (this.additionalHeader.isPresent()) {
            helloMessage = new NetconfMessage(helloMessage.getDocument(), (String)this.additionalHeader.get());
        }
        NetconfSessionPreferences proposal = new NetconfSessionPreferences(helloMessage);
        return new NetconfClientSessionNegotiator(proposal, (Promise<NetconfClientSession>)promise, channel, this.timer, sessionListenerFactory.getSessionListener());
    }
}

