/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import io.netty.channel.Channel;
import io.netty.util.Timer;
import io.netty.util.concurrent.Promise;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.namespace.QName;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSessionPreferences;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.util.AbstractNetconfSessionNegotiator;
import org.opendaylight.controller.netconf.util.xml.XMLNetconfUtil;
import org.opendaylight.controller.netconf.util.xml.XmlElement;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.opendaylight.protocol.framework.SessionListener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class NetconfClientSessionNegotiator
extends AbstractNetconfSessionNegotiator<NetconfSessionPreferences, NetconfClientSession> {
    private static final XPathExpression sessionIdXPath = XMLNetconfUtil.compileXPath((String)"/netconf:hello/netconf:session-id");

    protected NetconfClientSessionNegotiator(NetconfSessionPreferences sessionPreferences, Promise<NetconfClientSession> promise, Channel channel, Timer timer, SessionListener sessionListener) {
        super(sessionPreferences, promise, channel, timer, sessionListener);
    }

    private static Collection<String> getCapabilities(Document doc) {
        XmlElement responseElement = XmlElement.fromDomDocument((Document)doc);
        XmlElement capabilitiesElement = responseElement.getOnlyChildElementWithSameNamespace("capabilities");
        List caps = capabilitiesElement.getChildElements("capability");
        return Collections2.transform((Collection)caps, (Function)new Function<XmlElement, String>(){

            @Nullable
            public String apply(@Nullable XmlElement input) {
                return input.getTextContent().trim();
            }
        });
    }

    private long extractSessionId(Document doc) {
        Node sessionIdNode = (Node)XmlUtil.evaluateXPath((XPathExpression)sessionIdXPath, (Object)doc, (QName)XPathConstants.NODE);
        String textContent = sessionIdNode.getTextContent();
        if (textContent == null || textContent.equals("")) {
            throw new IllegalStateException("Session id not received from server");
        }
        return Long.valueOf(textContent);
    }

    protected NetconfClientSession getSession(SessionListener sessionListener, Channel channel, NetconfMessage message) {
        return new NetconfClientSession(sessionListener, channel, this.extractSessionId(message.getDocument()), NetconfClientSessionNegotiator.getCapabilities(message.getDocument()));
    }
}

