/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.protocol.framework.SessionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientSessionListener
implements SessionListener<NetconfMessage, NetconfClientSession, NetconfTerminationReason> {
    private static final Logger logger = LoggerFactory.getLogger(NetconfClientSessionListener.class);
    private AtomicBoolean up = new AtomicBoolean(false);
    private int lastReadMessage = -1;
    private List<NetconfMessage> messages = Lists.newArrayList();

    public void onSessionUp(NetconfClientSession clientSession) {
        this.up.set(true);
    }

    public void onSessionDown(NetconfClientSession clientSession, Exception e) {
        logger.debug("Client Session {} down, reason: {}", (Object)clientSession, (Object)e.getMessage());
        this.up.set(false);
    }

    public void onSessionTerminated(NetconfClientSession clientSession, NetconfTerminationReason netconfTerminationReason) {
        logger.debug("Client Session {} terminated, reason: {}", (Object)clientSession, (Object)netconfTerminationReason.getErrorMessage());
        this.up.set(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void onMessage(NetconfClientSession session, NetconfMessage message) {
        List<NetconfMessage> list = this.messages;
        synchronized (list) {
            this.messages.add(message);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NetconfMessage getLastMessage(int attempts, int attemptMsDelay) throws InterruptedException {
        Preconditions.checkState((boolean)this.up.get(), (Object)"Session was not up yet");
        for (int i = 0; i < attempts; ++i) {
            List<NetconfMessage> list = this.messages;
            synchronized (list) {
                if (this.messages.size() - 1 > this.lastReadMessage) {
                    ++this.lastReadMessage;
                    return this.messages.get(this.lastReadMessage);
                }
            }
            if (!this.up.get()) {
                throw new IllegalStateException("Session ended while trying to read message");
            }
            Thread.sleep(attemptMsDelay);
        }
        throw new IllegalStateException("No netconf message to read");
    }
}

