/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Optional;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timer;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.Promise;
import java.io.Closeable;
import java.net.InetSocketAddress;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.api.NetconfTerminationReason;
import org.opendaylight.controller.netconf.client.NetconfClient;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionListener;
import org.opendaylight.controller.netconf.client.NetconfClientSessionNegotiatorFactory;
import org.opendaylight.controller.netconf.util.AbstractChannelInitializer;
import org.opendaylight.protocol.framework.AbstractDispatcher;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.SessionListener;
import org.opendaylight.protocol.framework.SessionListenerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClientDispatcher
extends AbstractDispatcher<NetconfClientSession, NetconfClientSessionListener>
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(NetconfClient.class);
    private final NetconfClientSessionNegotiatorFactory negotatorFactory;
    private final HashedWheelTimer timer = new HashedWheelTimer();

    public NetconfClientDispatcher(EventLoopGroup bossGroup, EventLoopGroup workerGroup) {
        super(bossGroup, workerGroup);
        this.negotatorFactory = new NetconfClientSessionNegotiatorFactory((Timer)this.timer, (Optional<String>)Optional.absent());
    }

    public NetconfClientDispatcher(EventLoopGroup bossGroup, EventLoopGroup workerGroup, String additionalHeader) {
        super(bossGroup, workerGroup);
        this.negotatorFactory = new NetconfClientSessionNegotiatorFactory((Timer)this.timer, (Optional<String>)Optional.of((Object)additionalHeader));
    }

    public Future<NetconfClientSession> createClient(InetSocketAddress address, final NetconfClientSessionListener sessionListener, ReconnectStrategy strat) {
        return super.createClient(address, strat, (AbstractDispatcher.PipelineInitializer)new AbstractDispatcher.PipelineInitializer<NetconfClientSession>(){

            public void initializeChannel(SocketChannel ch, Promise<NetconfClientSession> promise) {
                this.initialize(ch, promise);
            }

            private void initialize(SocketChannel ch, Promise<NetconfClientSession> promise) {
                new ClientChannelInitializer(NetconfClientDispatcher.this.negotatorFactory, sessionListener).initialize(ch, promise);
            }
        });
    }

    @Override
    public void close() {
        try {
            this.timer.stop();
        }
        catch (Exception e) {
            logger.debug("Ignoring exception while closing {}", (Object)this.timer, (Object)e);
        }
    }

    private static class ClientChannelInitializer
    extends AbstractChannelInitializer {
        private final NetconfClientSessionNegotiatorFactory negotiatorFactory;
        private final NetconfClientSessionListener sessionListener;

        private ClientChannelInitializer(NetconfClientSessionNegotiatorFactory negotiatorFactory, NetconfClientSessionListener sessionListener) {
            this.negotiatorFactory = negotiatorFactory;
            this.sessionListener = sessionListener;
        }

        public void initialize(SocketChannel ch, Promise<? extends NetconfSession> promise) {
            super.initialize(ch, promise);
        }

        protected void initializeAfterDecoder(SocketChannel ch, Promise<? extends NetconfSession> promise) {
            ch.pipeline().addLast("negotiator", (ChannelHandler)this.negotiatorFactory.getSessionNegotiator(new SessionListenerFactory(){

                public SessionListener<NetconfMessage, NetconfClientSession, NetconfTerminationReason> getSessionListener() {
                    return ClientChannelInitializer.this.sessionListener;
                }
            }, (Channel)ch, promise));
        }
    }
}

