/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GlobalEventExecutor;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.client.NetconfClientDispatcher;
import org.opendaylight.controller.netconf.client.NetconfClientSession;
import org.opendaylight.controller.netconf.client.NetconfClientSessionListener;
import org.opendaylight.protocol.framework.NeverReconnectStrategy;
import org.opendaylight.protocol.framework.ReconnectStrategy;
import org.opendaylight.protocol.framework.TimedReconnectStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetconfClient
implements Closeable {
    private static final Logger logger = LoggerFactory.getLogger(NetconfClient.class);
    public static final int DEFAULT_CONNECT_TIMEOUT = 5000;
    private final NetconfClientDispatcher dispatch;
    private final String label;
    private final NetconfClientSession clientSession;
    private final NetconfClientSessionListener sessionListener;
    private final long sessionId;
    private final InetSocketAddress address;

    public NetconfClient(String clientLabelForLogging, InetSocketAddress address, int connectionAttempts, int attemptMsTimeout, NetconfClientDispatcher netconfClientDispatcher) throws InterruptedException {
        this(clientLabelForLogging, address, NetconfClient.getReconnectStrategy(connectionAttempts, attemptMsTimeout), netconfClientDispatcher);
    }

    private NetconfClient(String clientLabelForLogging, InetSocketAddress address, ReconnectStrategy strat, NetconfClientDispatcher netconfClientDispatcher) throws InterruptedException {
        this.label = clientLabelForLogging;
        this.dispatch = netconfClientDispatcher;
        this.sessionListener = new NetconfClientSessionListener();
        Future<NetconfClientSession> clientFuture = this.dispatch.createClient(address, this.sessionListener, strat);
        this.address = address;
        this.clientSession = this.get(clientFuture);
        this.sessionId = this.clientSession.getSessionId();
    }

    private NetconfClientSession get(Future<NetconfClientSession> clientFuture) throws InterruptedException {
        try {
            return (NetconfClientSession)((Object)clientFuture.get());
        }
        catch (CancellationException e) {
            throw new RuntimeException("Netconf client interrupted", e);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException("Unable to create netconf client", e);
        }
    }

    public static NetconfClient clientFor(String clientLabelForLogging, InetSocketAddress address, ReconnectStrategy strat, NetconfClientDispatcher netconfClientDispatcher) throws InterruptedException {
        return new NetconfClient(clientLabelForLogging, address, strat, netconfClientDispatcher);
    }

    public static NetconfClient clientFor(String clientLabelForLogging, InetSocketAddress address, ReconnectStrategy strat, NetconfClientDispatcher netconfClientDispatcher, NetconfClientSessionListener listener) throws InterruptedException {
        return new NetconfClient(clientLabelForLogging, address, strat, netconfClientDispatcher, listener);
    }

    public NetconfClient(String clientLabelForLogging, InetSocketAddress address, int connectTimeoutMs, NetconfClientDispatcher netconfClientDispatcher) throws InterruptedException {
        this(clientLabelForLogging, address, (ReconnectStrategy)new NeverReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, connectTimeoutMs), netconfClientDispatcher);
    }

    public NetconfClient(String clientLabelForLogging, InetSocketAddress address, NetconfClientDispatcher netconfClientDispatcher) throws InterruptedException {
        this(clientLabelForLogging, address, (ReconnectStrategy)new NeverReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, 5000), netconfClientDispatcher);
    }

    public NetconfClient(String clientLabelForLogging, InetSocketAddress address, ReconnectStrategy strat, NetconfClientDispatcher netconfClientDispatcher, NetconfClientSessionListener listener) throws InterruptedException {
        this.label = clientLabelForLogging;
        this.dispatch = netconfClientDispatcher;
        this.sessionListener = listener;
        Future<NetconfClientSession> clientFuture = this.dispatch.createClient(address, this.sessionListener, strat);
        this.address = address;
        this.clientSession = this.get(clientFuture);
        this.sessionId = this.clientSession.getSessionId();
    }

    public NetconfMessage sendMessage(NetconfMessage message) {
        return this.sendMessage(message, 5, 1000);
    }

    public NetconfMessage sendMessage(NetconfMessage message, int attempts, int attemptMsDelay) {
        long startTime = System.currentTimeMillis();
        Preconditions.checkState((boolean)this.clientSession.isUp(), (Object)"Session was not up yet");
        this.clientSession.sendMessage(message);
        try {
            NetconfMessage netconfMessage = this.sessionListener.getLastMessage(attempts, attemptMsDelay);
            return netconfMessage;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(this + " Cannot read message from " + this.address, e);
        }
        catch (IllegalStateException e) {
            throw new IllegalStateException(this + " Cannot read message from " + this.address, e);
        }
        finally {
            long diffMillis = System.currentTimeMillis() - startTime;
            logger.debug("Total time spent waiting for response {}", (Object)diffMillis);
        }
    }

    @Override
    public void close() throws IOException {
        this.clientSession.close();
    }

    public NetconfClientDispatcher getNetconfClientDispatcher() {
        return this.dispatch;
    }

    private static ReconnectStrategy getReconnectStrategy(int connectionAttempts, int attemptMsTimeout) {
        return new TimedReconnectStrategy((EventExecutor)GlobalEventExecutor.INSTANCE, attemptMsTimeout, 1000L, 1.0, null, Long.valueOf(connectionAttempts), null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("NetconfClient{");
        sb.append("label=").append(this.label);
        sb.append(", sessionId=").append(this.sessionId);
        sb.append('}');
        return sb.toString();
    }

    public long getSessionId() {
        return this.sessionId;
    }

    public Set<String> getCapabilities() {
        Preconditions.checkState((this.clientSession != null ? 1 : 0) != 0, (Object)"Client was not initialized successfully");
        return Sets.newHashSet(this.clientSession.getServerCapabilities());
    }

    public NetconfClientSession getClientSession() {
        return this.clientSession;
    }
}

