/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.MutableClassToInstanceMap;
import org.opendaylight.controller.md.sal.common.api.routing.RouteChangeListener;
import org.opendaylight.controller.sal.binding.api.BindingAwareBroker;
import org.opendaylight.controller.sal.binding.api.BindingAwareConsumer;
import org.opendaylight.controller.sal.binding.api.BindingAwareProvider;
import org.opendaylight.controller.sal.binding.api.BindingAwareService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.RpcProviderRegistry;
import org.opendaylight.controller.sal.binding.api.rpc.RpcContextIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.RpcService;

public class BindingContextUtils {
    public static BindingAwareBroker.ConsumerContext createConsumerContext(BindingAwareConsumer consumer, ClassToInstanceMap<BindingAwareService> serviceProvider) {
        Preconditions.checkNotNull((Object)consumer, (Object)"Consumer should not be null");
        Preconditions.checkNotNull(serviceProvider, (Object)"Service map should not be null");
        return new SingleConsumerContextImpl(serviceProvider);
    }

    public static BindingAwareBroker.ProviderContext createProviderContext(BindingAwareProvider provider, ClassToInstanceMap<BindingAwareService> serviceProvider) {
        Preconditions.checkNotNull((Object)provider, (Object)"Provider should not be null");
        Preconditions.checkNotNull(serviceProvider, (Object)"Service map should not be null");
        return new SingleProviderContextImpl(serviceProvider);
    }

    public static BindingAwareBroker.ConsumerContext createConsumerContextAndInitialize(BindingAwareConsumer consumer, ClassToInstanceMap<BindingAwareService> serviceProvider) {
        BindingAwareBroker.ConsumerContext context = BindingContextUtils.createConsumerContext(consumer, serviceProvider);
        consumer.onSessionInitialized(context);
        return context;
    }

    public static BindingAwareBroker.ProviderContext createProviderContextAndInitialize(BindingAwareProvider provider, ClassToInstanceMap<BindingAwareService> serviceProvider) {
        BindingAwareBroker.ProviderContext context = BindingContextUtils.createProviderContext(provider, serviceProvider);
        provider.onSessionInitiated(context);
        return context;
    }

    public static <T extends BindingAwareService> T createContextProxyOrReturnService(Class<T> service, T instance) {
        return instance;
    }

    private static class SingleProviderContextImpl
    extends SingleConsumerContextImpl
    implements BindingAwareBroker.ProviderContext {
        public SingleProviderContextImpl(ClassToInstanceMap<BindingAwareService> serviceProvider) {
            super(serviceProvider);
        }

        public <L extends RouteChangeListener<RpcContextIdentifier, InstanceIdentifier<?>>> ListenerRegistration<L> registerRouteChangeListener(L listener) {
            return this.getSALService(RpcProviderRegistry.class).registerRouteChangeListener(listener);
        }

        public <T extends RpcService> BindingAwareBroker.RoutedRpcRegistration<T> addRoutedRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
            return this.getSALService(RpcProviderRegistry.class).addRoutedRpcImplementation(type, implementation);
        }

        public <T extends RpcService> BindingAwareBroker.RpcRegistration<T> addRpcImplementation(Class<T> type, T implementation) throws IllegalStateException {
            return this.getSALService(RpcProviderRegistry.class).addRpcImplementation(type, implementation);
        }

        @Deprecated
        public void registerFunctionality(BindingAwareProvider.ProviderFunctionality functionality) {
        }

        @Deprecated
        public void unregisterFunctionality(BindingAwareProvider.ProviderFunctionality functionality) {
        }
    }

    private static class SingleConsumerContextImpl
    implements BindingAwareBroker.ConsumerContext,
    AutoCloseable {
        private ClassToInstanceMap<BindingAwareService> alreadyRetrievedServices = MutableClassToInstanceMap.create();
        private ClassToInstanceMap<BindingAwareService> serviceProvider;

        public SingleConsumerContextImpl(ClassToInstanceMap<BindingAwareService> serviceProvider) {
            this.serviceProvider = serviceProvider;
        }

        public final <T extends RpcService> T getRpcService(Class<T> module) {
            return (T)this.getSALService(RpcConsumerRegistry.class).getRpcService(module);
        }

        public final <T extends BindingAwareService> T getSALService(Class<T> service) {
            Preconditions.checkNotNull(service, (Object)"Service class should not be null.");
            BindingAwareService potential = (BindingAwareService)this.alreadyRetrievedServices.getInstance(service);
            if (potential != null) {
                return (T)potential;
            }
            return this.tryToRetrieveSalService(service);
        }

        private synchronized <T extends BindingAwareService> T tryToRetrieveSalService(Class<T> service) {
            BindingAwareService potential = (BindingAwareService)this.alreadyRetrievedServices.getInstance(service);
            if (potential != null) {
                return (T)potential;
            }
            BindingAwareService requested = (BindingAwareService)this.serviceProvider.getInstance(service);
            if (requested == null) {
                throw new IllegalArgumentException("Requested service " + service.getName() + " is not available.");
            }
            BindingAwareService retrieved = BindingContextUtils.createContextProxyOrReturnService(service, requested);
            this.alreadyRetrievedServices.put(service, (Object)retrieved);
            return (T)retrieved;
        }

        @Override
        public final void close() throws Exception {
            this.alreadyRetrievedServices = null;
            this.serviceProvider = null;
        }
    }
}

