/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.md.sal.binding.util;

import com.google.common.base.Preconditions;
import java.util.concurrent.Future;
import org.opendaylight.controller.sal.binding.api.NotificationListener;
import org.opendaylight.controller.sal.binding.api.NotificationService;
import org.opendaylight.controller.sal.binding.api.RpcConsumerRegistry;
import org.opendaylight.controller.sal.binding.api.data.DataBrokerService;
import org.opendaylight.controller.sal.binding.api.data.DataChangeListener;
import org.opendaylight.controller.sal.binding.api.data.DataModificationTransaction;
import org.opendaylight.controller.sal.common.DataStoreIdentifier;
import org.opendaylight.yangtools.concepts.ListenerRegistration;
import org.opendaylight.yangtools.concepts.Registration;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.binding.DataRoot;
import org.opendaylight.yangtools.yang.binding.InstanceIdentifier;
import org.opendaylight.yangtools.yang.binding.Notification;
import org.opendaylight.yangtools.yang.binding.RpcService;
import org.opendaylight.yangtools.yang.common.RpcResult;

public abstract class AbstractBindingSalConsumerInstance<D extends DataBrokerService, N extends NotificationService, R extends RpcConsumerRegistry>
implements RpcConsumerRegistry,
NotificationService,
DataBrokerService {
    private final R rpcRegistry;
    private final N notificationBroker;
    private final D dataBroker;

    protected final R getRpcRegistry() {
        return this.rpcRegistry;
    }

    protected final N getNotificationBroker() {
        return this.notificationBroker;
    }

    protected final D getDataBroker() {
        return this.dataBroker;
    }

    protected final R getRpcRegistryChecked() {
        Preconditions.checkState((this.rpcRegistry != null ? 1 : 0) != 0, (Object)"Rpc Registry is not available.");
        return this.rpcRegistry;
    }

    protected final N getNotificationBrokerChecked() {
        Preconditions.checkState((this.notificationBroker != null ? 1 : 0) != 0, (Object)"Notification Broker is not available.");
        return this.notificationBroker;
    }

    protected final D getDataBrokerChecked() {
        Preconditions.checkState((this.dataBroker != null ? 1 : 0) != 0, (Object)"Data Broker is not available");
        return this.dataBroker;
    }

    protected AbstractBindingSalConsumerInstance(R rpcRegistry, N notificationBroker, D dataBroker) {
        this.rpcRegistry = rpcRegistry;
        this.notificationBroker = notificationBroker;
        this.dataBroker = dataBroker;
    }

    public <T extends RpcService> T getRpcService(Class<T> module) {
        return (T)this.getRpcRegistryChecked().getRpcService(module);
    }

    @Deprecated
    public <T extends Notification> void addNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        this.getNotificationBrokerChecked().addNotificationListener(notificationType, listener);
    }

    @Deprecated
    public void addNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        this.getNotificationBrokerChecked().addNotificationListener(listener);
    }

    @Deprecated
    public void removeNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        this.getNotificationBrokerChecked().removeNotificationListener(listener);
    }

    @Deprecated
    public <T extends Notification> void removeNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        this.getNotificationBrokerChecked().removeNotificationListener(notificationType, listener);
    }

    public <T extends Notification> Registration<NotificationListener<T>> registerNotificationListener(Class<T> notificationType, NotificationListener<T> listener) {
        return this.getNotificationBrokerChecked().registerNotificationListener(notificationType, listener);
    }

    public Registration<org.opendaylight.yangtools.yang.binding.NotificationListener> registerNotificationListener(org.opendaylight.yangtools.yang.binding.NotificationListener listener) {
        return this.getNotificationBrokerChecked().registerNotificationListener(listener);
    }

    @Deprecated
    public <T extends DataRoot> T getData(DataStoreIdentifier store, Class<T> rootType) {
        return (T)this.getDataBrokerChecked().getData(store, rootType);
    }

    @Deprecated
    public <T extends DataRoot> T getData(DataStoreIdentifier store, T filter) {
        return (T)this.getDataBrokerChecked().getData(store, filter);
    }

    @Deprecated
    public <T extends DataRoot> T getCandidateData(DataStoreIdentifier store, Class<T> rootType) {
        return (T)this.getDataBrokerChecked().getCandidateData(store, rootType);
    }

    @Deprecated
    public <T extends DataRoot> T getCandidateData(DataStoreIdentifier store, T filter) {
        return (T)this.getDataBrokerChecked().getCandidateData(store, filter);
    }

    @Deprecated
    public RpcResult<DataRoot> editCandidateData(DataStoreIdentifier store, DataRoot changeSet) {
        return this.getDataBrokerChecked().editCandidateData(store, changeSet);
    }

    @Deprecated
    public Future<RpcResult<Void>> commit(DataStoreIdentifier store) {
        return this.getDataBrokerChecked().commit(store);
    }

    @Deprecated
    public DataObject getData(InstanceIdentifier<? extends DataObject> data) {
        return this.getDataBrokerChecked().getData(data);
    }

    @Deprecated
    public DataObject getConfigurationData(InstanceIdentifier<?> data) {
        return this.getDataBrokerChecked().getConfigurationData(data);
    }

    public DataModificationTransaction beginTransaction() {
        return this.getDataBrokerChecked().beginTransaction();
    }

    @Deprecated
    public void registerChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener changeListener) {
        this.getDataBrokerChecked().registerChangeListener(path, changeListener);
    }

    @Deprecated
    public void unregisterChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener changeListener) {
        this.getDataBrokerChecked().unregisterChangeListener(path, changeListener);
    }

    @Deprecated
    public DataObject readConfigurationData(InstanceIdentifier<? extends DataObject> path) {
        return this.getDataBrokerChecked().readConfigurationData(path);
    }

    public DataObject readOperationalData(InstanceIdentifier<? extends DataObject> path) {
        return this.getDataBrokerChecked().readOperationalData(path);
    }

    @Deprecated
    public ListenerRegistration<DataChangeListener> registerDataChangeListener(InstanceIdentifier<? extends DataObject> path, DataChangeListener listener) {
        return this.getDataBrokerChecked().registerDataChangeListener(path, listener);
    }
}

