/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableCompositeNode;
import org.opendaylight.yangtools.yang.data.api.MutableSimpleNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.util.AbstractContainerNode;
import org.opendaylight.yangtools.yang.data.util.AbstractNode;

public final class Nodes {
    private Nodes() {
    }

    public static <T> SimpleNode<T> leafNode(QName name, T value) {
        return new SimpleNodeTO<T>(name, value, null);
    }

    public static CompositeNode containerNode(QName name, List<Node<?>> children) {
        return Nodes.containerNode(name, children, null);
    }

    public static CompositeNode containerNode(QName name, List<Node<?>> children, CompositeNode parent) {
        return new ContainerNodeTO(name, parent, Nodes.nodeMapFromList(children));
    }

    public static Map<QName, List<Node<?>>> nodeMapFromList(List<Node<?>> children) {
        HashMap map = new HashMap();
        for (Node<?> node : children) {
            QName name = node.getNodeType();
            ArrayList targetList = (ArrayList)map.get(name);
            if (targetList == null) {
                targetList = new ArrayList();
                map.put(name, targetList);
            }
            targetList.add(node);
        }
        return map;
    }

    private static class SimpleNodeTO<T>
    extends AbstractNode<T>
    implements SimpleNode<T> {
        private final T value;

        protected SimpleNodeTO(QName name, T val, CompositeNode parent) {
            super(name, parent);
            this.value = val;
        }

        public T getValue() {
            return this.value;
        }

        public MutableSimpleNode<T> asMutable() {
            return null;
        }

        public T setValue(T value) {
            return null;
        }

        public QName getKey() {
            return this.getNodeType();
        }
    }

    private static class ContainerNodeTO
    extends AbstractContainerNode {
        private final Map<QName, List<Node<?>>> nodeMap;

        public ContainerNodeTO(QName name, Map<QName, List<Node<?>>> nodeMap) {
            super(name);
            this.nodeMap = nodeMap;
        }

        public ContainerNodeTO(QName name, CompositeNode parent, Map<QName, List<Node<?>>> nodeMap) {
            super(name, parent);
            this.nodeMap = nodeMap;
        }

        @Override
        protected Map<QName, List<Node<?>>> getNodeMap() {
            return this.nodeMap;
        }

        public MutableCompositeNode asMutable() {
            return null;
        }

        public QName getKey() {
            return this.getNodeType();
        }

        public List<Node<?>> setValue(List<Node<?>> value) {
            return null;
        }

        public int size() {
            return this.nodeMap.size();
        }

        public boolean isEmpty() {
            return this.nodeMap.isEmpty();
        }

        public boolean containsKey(Object key) {
            return this.nodeMap.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.nodeMap.containsValue(value);
        }

        public List<Node<?>> get(Object key) {
            return this.nodeMap.get(key);
        }

        public List<Node<?>> put(QName key, List<Node<?>> value) {
            return this.nodeMap.put(key, value);
        }

        public List<Node<?>> remove(Object key) {
            return this.nodeMap.remove(key);
        }

        public void putAll(Map<? extends QName, ? extends List<Node<?>>> m) {
            this.nodeMap.putAll(m);
        }

        public void clear() {
            this.nodeMap.clear();
        }

        public Set<QName> keySet() {
            return this.nodeMap.keySet();
        }

        public Collection<List<Node<?>>> values() {
            return this.nodeMap.values();
        }

        public Set<Map.Entry<QName, List<Node<?>>>> entrySet() {
            return this.nodeMap.entrySet();
        }
    }
}

