/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yangtools.yang.data.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.data.api.CompositeNode;
import org.opendaylight.yangtools.yang.data.api.Node;
import org.opendaylight.yangtools.yang.data.api.SimpleNode;
import org.opendaylight.yangtools.yang.data.util.AbstractNode;

public abstract class AbstractContainerNode
extends AbstractNode<List<Node<?>>>
implements CompositeNode {
    public SimpleNode<?> getFirstSimpleByName(QName leaf) {
        List<SimpleNode<?>> list = this.getSimpleNodesByName(leaf);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    protected AbstractContainerNode(QName name, CompositeNode parent) {
        super(name, parent);
    }

    public AbstractContainerNode(QName name) {
        super(name, null);
    }

    public List<Node<?>> getChildren() {
        return this.getValue();
    }

    public List<Node<?>> getValue() {
        Map<QName, List<Node<?>>> map = this.getNodeMap();
        if (map == null) {
            throw new IllegalStateException("nodeMap should not be null");
        }
        ArrayList ret = new ArrayList();
        Collection<List<Node<?>>> values = map.values();
        for (List<Node<?>> list : values) {
            ret.addAll(list);
        }
        return ret;
    }

    protected abstract Map<QName, List<Node<?>>> getNodeMap();

    public List<CompositeNode> getCompositesByName(QName children) {
        Map<QName, List<Node<?>>> map = this.getNodeMap();
        if (map == null) {
            throw new IllegalStateException("nodeMap should not be null");
        }
        List<Node<?>> toFilter = map.get(children);
        ArrayList<CompositeNode> list = new ArrayList<CompositeNode>();
        for (Node<?> node : toFilter) {
            if (!(node instanceof CompositeNode)) continue;
            list.add((CompositeNode)node);
        }
        return list;
    }

    public List<SimpleNode<?>> getSimpleNodesByName(QName children) {
        Map<QName, List<Node<?>>> map = this.getNodeMap();
        if (map == null) {
            throw new IllegalStateException("nodeMap should not be null");
        }
        List<Node<?>> toFilter = map.get(children);
        ArrayList list = new ArrayList();
        for (Node<?> node : toFilter) {
            if (!(node instanceof SimpleNode)) continue;
            list.add((SimpleNode)node);
        }
        return list;
    }

    public CompositeNode getFirstCompositeByName(QName container) {
        List<CompositeNode> list = this.getCompositesByName(container);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public SimpleNode<?> getFirstLeafByName(QName leaf) {
        List<SimpleNode<?>> list = this.getSimpleNodesByName(leaf);
        if (list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public List<CompositeNode> getCompositesByName(String children) {
        return this.getCompositesByName(this.localQName(children));
    }

    public List<SimpleNode<?>> getSimpleNodesByName(String children) {
        return this.getSimpleNodesByName(this.localQName(children));
    }

    private QName localQName(String str) {
        return new QName(this.getNodeType(), str);
    }
}

