/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.web;

import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Name;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.usermanager.IUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaylightWebUtil {
    private static final String AUDIT = "audit";
    private static final Logger logger = LoggerFactory.getLogger((String)"audit");

    public static Privilege getContainerPrivilege(String userName, String container, Object bundle) {
        IUserManager userManager;
        String resource = container == null ? GlobalConstants.DEFAULT.toString() : container;
        IContainerAuthorization auth = (IContainerAuthorization)ServiceHelper.getGlobalInstance(IContainerAuthorization.class, (Object)bundle);
        if (auth != null) {
            return auth.getResourcePrivilege(userName, (Object)resource);
        }
        if (resource.equals(GlobalConstants.DEFAULT.toString()) && (userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)bundle)) != null) {
            switch (userManager.getUserLevel(userName)) {
                case NETWORKADMIN: {
                    return Privilege.WRITE;
                }
                case NETWORKOPERATOR: {
                    return Privilege.READ;
                }
            }
            return Privilege.NONE;
        }
        return Privilege.NONE;
    }

    public static void auditlog(String moduleName, String user, String action, String resource, String containerName) {
        String auditMsg = "";
        String mode = "UI";
        auditMsg = containerName != null ? "Mode: " + mode + " User " + user + " " + action + " " + moduleName + " " + resource + " in container " + containerName : "Mode: " + mode + " User " + user + " " + action + " " + moduleName + " " + resource;
        logger.trace(auditMsg);
    }

    public static void auditlog(String moduleName, String user, String action, String resource) {
        DaylightWebUtil.auditlog(moduleName, user, action, resource, null);
    }

    public static String getNodeDesc(Node node, ISwitchManager switchManager) {
        Description desc = (Description)switchManager.getNodeProp(node, "description");
        String description = desc == null ? "" : desc.getValue();
        return description.isEmpty() || description.equalsIgnoreCase("none") ? node.toString() : description;
    }

    public static String getNodeDesc(Node node, String containerName, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)containerName, (Object)bundle);
        if (switchManager == null) {
            return null;
        }
        return DaylightWebUtil.getNodeDesc(node, switchManager);
    }

    public static String getNodeDesc(Node node, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)bundle);
        if (switchManager == null) {
            return null;
        }
        return DaylightWebUtil.getNodeDesc(node, switchManager);
    }

    public static String getPortName(NodeConnector nodeConnector, String container, Object bundle) {
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)container, (Object)bundle);
        return DaylightWebUtil.getPortName(nodeConnector, switchManager);
    }

    public static String getPortName(NodeConnector nodeConnector, Object bundle) {
        return DaylightWebUtil.getPortName(nodeConnector, GlobalConstants.DEFAULT.toString(), bundle);
    }

    public static String getPortName(NodeConnector nodeConnector, ISwitchManager switchManager) {
        Name ncName = (Name)switchManager.getNodeConnectorProp(nodeConnector, "name");
        String nodeConnectorName = ncName != null ? ncName.getValue() : nodeConnector.getNodeConnectorIdAsString();
        nodeConnectorName = nodeConnectorName + "@" + DaylightWebUtil.getNodeDesc(nodeConnector.getNode(), switchManager);
        return nodeConnectorName.substring(0, nodeConnectorName.length());
    }
}

