/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.web;

import com.google.gson.Gson;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.opendaylight.controller.clustering.services.IClusterGlobalServices;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.core.Description;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.usermanager.IUserManager;
import org.opendaylight.controller.usermanager.UserConfig;
import org.opendaylight.controller.web.ClusterNodeBean;
import org.opendaylight.controller.web.DaylightWebUtil;
import org.opendaylight.controller.web.NodeBean;
import org.opendaylight.controller.web.UserBean;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/admin"})
public class DaylightWebAdmin {
    Gson gson = new Gson();

    @RequestMapping(value={"/cluster"})
    @ResponseBody
    public String getClusteredControllers() {
        IClusterGlobalServices clusterServices = (IClusterGlobalServices)ServiceHelper.getGlobalInstance(IClusterGlobalServices.class, (Object)this);
        if (clusterServices == null) {
            return null;
        }
        IConnectionManager connectionManager = (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
        if (connectionManager == null) {
            return null;
        }
        ArrayList<ClusterNodeBean> clusterNodes = new ArrayList<ClusterNodeBean>();
        List controllers = clusterServices.getClusteredControllers();
        for (InetAddress controller : controllers) {
            ClusterNodeBean.Builder clusterBeanBuilder = new ClusterNodeBean.Builder(controller);
            Set connectedNodes = connectionManager.getNodes(controller);
            int numNodes = connectedNodes == null ? 0 : connectedNodes.size();
            clusterBeanBuilder.nodesConnected(numNodes);
            if (controller.equals(clusterServices.getMyAddress())) {
                clusterBeanBuilder.highlightMe();
            }
            if (clusterServices.getCoordinatorAddress().equals(controller)) {
                clusterBeanBuilder.iAmCoordinator();
            }
            clusterNodes.add(clusterBeanBuilder.build());
        }
        return this.gson.toJson(clusterNodes);
    }

    @RequestMapping(value={"/cluster/controller/{controller}"})
    @ResponseBody
    public String getNodesConnectedToController(@PathVariable(value="controller") String controller) {
        IClusterGlobalServices clusterServices = (IClusterGlobalServices)ServiceHelper.getGlobalInstance(IClusterGlobalServices.class, (Object)this);
        if (clusterServices == null) {
            return null;
        }
        IConnectionManager connectionManager = (IConnectionManager)ServiceHelper.getGlobalInstance(IConnectionManager.class, (Object)this);
        if (connectionManager == null) {
            return null;
        }
        ISwitchManager switchManager = (ISwitchManager)ServiceHelper.getInstance(ISwitchManager.class, (String)GlobalConstants.DEFAULT.toString(), (Object)this);
        if (switchManager == null) {
            return null;
        }
        byte[] address = (byte[])this.gson.fromJson(controller, byte[].class);
        InetAddress controllerAddress = null;
        try {
            controllerAddress = InetAddress.getByAddress(address);
        }
        catch (UnknownHostException e) {
            return null;
        }
        ArrayList<NodeBean> result = new ArrayList<NodeBean>();
        Set nodes = connectionManager.getNodes(controllerAddress);
        if (nodes == null) {
            return this.gson.toJson(result);
        }
        for (Node node : nodes) {
            Description description = (Description)switchManager.getNodeProp(node, "description");
            NodeBean nodeBean = description == null || description.getValue().equals("None") ? new NodeBean(node) : new NodeBean(node, description.getValue());
            result.add(nodeBean);
        }
        return this.gson.toJson(result);
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<UserBean> getUsers() {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return null;
        }
        ArrayList<UserBean> result = new ArrayList<UserBean>();
        List configs = userManager.getLocalUserList();
        for (UserConfig config : configs) {
            UserBean bean = new UserBean(config);
            result.add(bean);
        }
        return result;
    }

    @RequestMapping(value={"/users"}, method={RequestMethod.POST})
    @ResponseBody
    public Status saveLocalUserConfig(@RequestParam(required=true) String json, @RequestParam(required=true) String action, HttpServletRequest request) {
        Status result;
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return new Status(StatusCode.NOSERVICE, "User Manager unavailable");
        }
        if (!this.authorize(userManager, UserLevel.NETWORKADMIN, request)) {
            return new Status(StatusCode.UNAUTHORIZED, "Operation not permitted");
        }
        Gson gson = new Gson();
        UserConfig plainConfig = (UserConfig)gson.fromJson(json, UserConfig.class);
        UserConfig config = new UserConfig(plainConfig.getUser(), plainConfig.getPassword(), plainConfig.getRoles());
        Status status = result = action.equals("add") ? userManager.addLocalUser(config) : userManager.removeLocalUser(config);
        if (result.isSuccess()) {
            if (action.equals("add")) {
                DaylightWebUtil.auditlog("User", request.getUserPrincipal().getName(), "added", config.getUser() + " as " + config.getRoles().toString());
            } else {
                DaylightWebUtil.auditlog("User", request.getUserPrincipal().getName(), "removed", config.getUser());
            }
        }
        return result;
    }

    @RequestMapping(value={"/user/modify"}, method={RequestMethod.POST})
    @ResponseBody
    public Status modifyUser(@RequestParam(required=true) String json, @RequestParam(required=true) String action, HttpServletRequest request) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return new Status(StatusCode.NOSERVICE, "User Manager unavailable");
        }
        if (!this.authorize(userManager, UserLevel.NETWORKADMIN, request)) {
            return new Status(StatusCode.UNAUTHORIZED, "Operation not permitted");
        }
        UserConfig newConfig = (UserConfig)this.gson.fromJson(json, UserConfig.class);
        List currentUserConfig = userManager.getLocalUserList();
        String password = null;
        String user = newConfig.getUser();
        for (UserConfig userConfig : currentUserConfig) {
            if (!userConfig.getUser().equals(user)) continue;
            password = userConfig.getPassword();
            break;
        }
        if (password == null) {
            String msg = String.format("User %s not found in configuration database", user);
            return new Status(StatusCode.NOTFOUND, msg);
        }
        Gson gson = new Gson();
        newConfig = (UserConfig)gson.fromJson(json = json.replace("\"roles\"", "\"password\":\"" + password + "\",\"roles\""), UserConfig.class);
        Status result = userManager.modifyLocalUser(newConfig);
        if (result.isSuccess()) {
            DaylightWebUtil.auditlog("Roles of", request.getUserPrincipal().getName(), "updated", newConfig.getUser() + " to " + newConfig.getRoles().toString());
        }
        return result;
    }

    @RequestMapping(value={"/users/{username}"}, method={RequestMethod.POST})
    @ResponseBody
    public Status removeLocalUser(@PathVariable(value="username") String userName, HttpServletRequest request) {
        String loggedInUser = request.getUserPrincipal().getName();
        if (loggedInUser.equals(userName)) {
            String msg = "Invalid Request: User cannot delete itself";
            return new Status(StatusCode.NOTALLOWED, msg);
        }
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return new Status(StatusCode.NOSERVICE, "User Manager unavailable");
        }
        if (!this.authorize(userManager, UserLevel.NETWORKADMIN, request)) {
            return new Status(StatusCode.UNAUTHORIZED, "Operation not permitted");
        }
        Status status = userManager.removeLocalUser(userName);
        if (status.isSuccess()) {
            DaylightWebUtil.auditlog("User", request.getUserPrincipal().getName(), "removed", userName);
            return status;
        }
        return status;
    }

    @RequestMapping(value={"/users/password/{username}"}, method={RequestMethod.POST})
    @ResponseBody
    public Status changePassword(@PathVariable(value="username") String username, HttpServletRequest request, @RequestParam(value="currentPassword", required=false) String currentPassword, @RequestParam(value="newPassword") String newPassword) {
        Status status;
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return new Status(StatusCode.NOSERVICE, "User Manager unavailable");
        }
        String requestingUser = request.getUserPrincipal().getName();
        if (requestingUser.equals(username)) {
            status = userManager.changeLocalUserPassword(username, currentPassword, newPassword);
            if (status.isSuccess() && !newPassword.equals(currentPassword)) {
                userManager.userLogout(username);
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.invalidate();
                }
            }
        } else if (this.authorize(userManager, UserLevel.NETWORKADMIN, request)) {
            List roles = userManager.getUserRoles(username);
            UserConfig newConfig = new UserConfig(username, newPassword, roles);
            status = newConfig.validate();
            if (!status.isSuccess()) {
                return status;
            }
            userManager.userLogout(username);
            status = userManager.removeLocalUser(username);
            if (!status.isSuccess()) {
                return status;
            }
            status = userManager.addLocalUser(newConfig).isSuccess() ? new Status(StatusCode.SUCCESS, "Password for user " + username + " reset successfully.") : new Status(StatusCode.INTERNALERROR, "Failed resetting password for user " + username + ". User is now removed.");
        } else {
            status = new Status(StatusCode.UNAUTHORIZED, "Operation not permitted");
        }
        if (status.isSuccess()) {
            DaylightWebUtil.auditlog("User", request.getUserPrincipal().getName(), "changed password for", username);
        }
        return status;
    }

    private boolean authorize(IUserManager userManager, UserLevel level, HttpServletRequest request) {
        String username = request.getUserPrincipal().getName();
        UserLevel userLevel = userManager.getUserLevel(username);
        return userLevel.toNumber() <= level.toNumber();
    }
}

