/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.web;

import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.configuration.IConfigurationService;
import org.opendaylight.controller.containermanager.IContainerAuthorization;
import org.opendaylight.controller.sal.authorization.Privilege;
import org.opendaylight.controller.sal.authorization.Resource;
import org.opendaylight.controller.sal.authorization.UserLevel;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.usermanager.IUserManager;
import org.opendaylight.controller.web.IDaylightWeb;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/"})
public class DaylightWeb {
    @RequestMapping(value={""})
    public String index(Model model, HttpServletRequest request) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return "User Manager is not available";
        }
        String username = request.getUserPrincipal().getName();
        model.addAttribute("username", (Object)username);
        model.addAttribute("role", (Object)userManager.getUserLevel(username).toNumber());
        return "main";
    }

    @RequestMapping(value={"/versionProperty/{property}"}, method={RequestMethod.GET})
    @ResponseBody
    public String getVersion(HttpServletRequest request, @PathVariable(value="property") String property) {
        Properties prop = new Properties();
        try {
            prop.load(new FileInputStream("version.properties"));
            return prop.getProperty(property + ".version");
        }
        catch (Exception e) {
            return null;
        }
    }

    @RequestMapping(value={"web.json"})
    @ResponseBody
    public Map<String, Map<String, Object>> bundles(HttpServletRequest request) {
        Object[] instances = ServiceHelper.getGlobalInstances(IDaylightWeb.class, (Object)this, null);
        HashMap<String, Map<String, Object>> bundles = new HashMap<String, Map<String, Object>>();
        String username = request.getUserPrincipal().getName();
        IUserManager userManger = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        for (Object instance : instances) {
            IDaylightWeb bundle = (IDaylightWeb)instance;
            if (userManger == null || !bundle.isAuthorized(userManger.getUserLevel(username))) continue;
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("name", bundle.getWebName());
            entry.put("order", bundle.getWebOrder());
            bundles.put(bundle.getWebId(), entry);
        }
        return bundles;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST})
    @ResponseBody
    public String save(HttpServletRequest request) {
        Status status;
        String username = request.getUserPrincipal().getName();
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return "User Manager is not available";
        }
        UserLevel level = userManager.getUserLevel(username);
        switch (level) {
            case SYSTEMADMIN: 
            case NETWORKADMIN: {
                IConfigurationService configService = (IConfigurationService)ServiceHelper.getGlobalInstance(IConfigurationService.class, (Object)this);
                if (configService != null) {
                    status = configService.saveConfigurations();
                    break;
                }
                status = new Status(StatusCode.NOSERVICE, "Configuration Service is not available");
                break;
            }
            case NETWORKOPERATOR: 
            case CONTAINERUSER: {
                IContainerAuthorization containerAuth = (IContainerAuthorization)ServiceHelper.getGlobalInstance(IContainerAuthorization.class, (Object)this);
                if (containerAuth != null) {
                    boolean oneSaved = false;
                    Set authorizedContainers = containerAuth.getAllResourcesforUser(username);
                    if (authorizedContainers.isEmpty()) {
                        status = new Status(StatusCode.UNAUTHORIZED, "User is not authorized for any container");
                        break;
                    }
                    for (Resource container : authorizedContainers) {
                        String containerName;
                        IConfigurationContainerService containerConfigService;
                        if (container.getPrivilege() != Privilege.WRITE || (containerConfigService = (IConfigurationContainerService)ServiceHelper.getInstance(IConfigurationContainerService.class, (String)(containerName = (String)container.getResource()), (Object)this)) == null || !(status = containerConfigService.saveConfigurations()).isSuccess()) continue;
                        oneSaved = true;
                    }
                    if (oneSaved) {
                        status = new Status(StatusCode.SUCCESS);
                        break;
                    }
                    status = new Status(StatusCode.UNAUTHORIZED, "Operation not allowed for current user");
                    break;
                }
                status = new Status(StatusCode.NOSERVICE, "Container Authorization Service is not available");
                break;
            }
            default: {
                status = new Status(StatusCode.UNAUTHORIZED, "Operation not allowed for current user");
            }
        }
        return status.getDescription();
    }

    @RequestMapping(value={"logout"})
    public String logout(Map<String, Object> model, HttpServletRequest request) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return "User Manager is not available";
        }
        String username = request.getUserPrincipal().getName();
        HttpSession session = request.getSession(false);
        if (session != null) {
            if (username != null) {
                userManager.userLogout(username);
            }
            session.invalidate();
        }
        return "redirect:/";
    }

    @RequestMapping(value={"login"})
    public String login(Model model, HttpServletRequest request, HttpServletResponse response) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager == null) {
            return "User Manager is not available";
        }
        String username = request.getUserPrincipal().getName();
        model.addAttribute("username", (Object)username);
        model.addAttribute("role", (Object)userManager.getUserLevel(username).toNumber());
        return "forward:/";
    }
}

