/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.web;

import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.opendaylight.controller.usermanager.IUserManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerUISessionManager
implements HttpSessionListener {
    private static final Logger logger = LoggerFactory.getLogger(ControllerUISessionManager.class);

    public void sessionCreated(HttpSessionEvent se) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager != null) {
            userManager.getSessionManager().sessionCreated(se);
        } else {
            logger.warn("User Manager is currently unavailable. Unable to register UI session.");
        }
    }

    public void sessionDestroyed(HttpSessionEvent se) {
        IUserManager userManager = (IUserManager)ServiceHelper.getGlobalInstance(IUserManager.class, (Object)this);
        if (userManager != null) {
            userManager.getSessionManager().sessionDestroyed(se);
        } else {
            logger.warn("User Manager is currently unavailable. Unable to destroy UI session.");
        }
    }
}

