/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.web;

import java.net.InetAddress;

public class ClusterNodeBean {
    private final byte[] address;
    private final String name;
    private final Boolean me;
    private final Boolean coordinator;
    private final Integer numConnectedNodes;

    private ClusterNodeBean(Builder builder) {
        this.address = builder.address;
        this.name = builder.name;
        this.me = builder.me;
        this.coordinator = builder.coordinator;
        this.numConnectedNodes = builder.numConnectedNodes;
    }

    public static class Builder {
        private final byte[] address;
        private final String name;
        private Boolean me = null;
        private Boolean coordinator = null;
        private Integer numConnectedNodes = null;

        public Builder(InetAddress address) {
            this.address = address.getAddress();
            this.name = address.getHostAddress();
        }

        public Builder highlightMe() {
            this.me = true;
            return this;
        }

        public Builder iAmCoordinator() {
            this.coordinator = true;
            return this;
        }

        public Builder nodesConnected(int numNodes) {
            this.numConnectedNodes = numNodes;
            return this;
        }

        public ClusterNodeBean build() {
            return new ClusterNodeBean(this);
        }
    }
}

