/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.plugin.util;

import org.opendaylight.yangtools.yang.common.QName;

public class NameConflictException
extends RuntimeException {
    private static final String messageBlueprint = "Name conflict for name: %s, first defined in: %s, then defined in: %s";
    private final String conflictingName;
    private final QName secondParentQName;
    private final QName firstParentQName;

    public NameConflictException(String conflictingName, QName firstDefinedParentQName, QName secondDefinedParentQName) {
        super(String.format(messageBlueprint, conflictingName, firstDefinedParentQName, secondDefinedParentQName));
        this.conflictingName = conflictingName;
        this.firstParentQName = firstDefinedParentQName;
        this.secondParentQName = secondDefinedParentQName;
    }

    public String getConflictingName() {
        return this.conflictingName;
    }

    public QName getSecondParentQName() {
        return this.secondParentQName;
    }

    public QName getFirstParentQName() {
        return this.firstParentQName;
    }
}

