/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.attribute;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AbstractAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TypedAttribute;
import org.opendaylight.yangtools.binding.generator.util.ReferencedTypeImpl;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.AugmentationTarget;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;

public class TOAttribute
extends AbstractAttribute
implements TypedAttribute {
    private final String nullableDescription;
    private final String nullableDefault;
    private final Map<String, AttributeIfc> yangNameToAttributeMap;
    private final Map<String, String> attributeNameMap;
    private final String packageName;
    private static final Set<Class<? extends DataSchemaNode>> ALLOWED_CHILDREN = Sets.newHashSet();

    public static <T extends DataNodeContainer & AugmentationTarget> TOAttribute create(T containerSchemaNode, TypeProviderWrapper typeProviderWrapper, String packageName) {
        HashMap<String, AttributeIfc> map = new HashMap<String, AttributeIfc>();
        HashMap<String, String> attributeNameMap = new HashMap<String, String>();
        for (DataSchemaNode dataSchemaNode : containerSchemaNode.getChildNodes()) {
            try {
                String yangName = dataSchemaNode.getQName().getLocalName();
                map.put(yangName, TOAttribute.createInnerAttribute(dataSchemaNode, typeProviderWrapper, packageName));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalStateException("Unable to create TO", e);
            }
        }
        return new TOAttribute((DataSchemaNode)containerSchemaNode, map, attributeNameMap, ((SchemaNode)containerSchemaNode).getDescription(), packageName);
    }

    private static AttributeIfc createInnerAttribute(DataSchemaNode dataSchemaNode, TypeProviderWrapper typeProviderWrapper, String packageName) {
        Class<? extends DataSchemaNode> type = TOAttribute.isAllowedType(dataSchemaNode);
        if (type.equals(LeafSchemaNode.class)) {
            return new JavaAttribute((LeafSchemaNode)dataSchemaNode, typeProviderWrapper);
        }
        if (type.equals(ListSchemaNode.class)) {
            return ListAttribute.create((ListSchemaNode)dataSchemaNode, typeProviderWrapper, packageName);
        }
        if (type.equals(LeafListSchemaNode.class)) {
            return ListAttribute.create((LeafListSchemaNode)dataSchemaNode, typeProviderWrapper);
        }
        if (type.equals(ContainerSchemaNode.class)) {
            return TOAttribute.create((ContainerSchemaNode)dataSchemaNode, typeProviderWrapper, packageName);
        }
        throw new IllegalStateException("This should never happen");
    }

    private static Class<? extends DataSchemaNode> isAllowedType(DataSchemaNode dataSchemaNode) {
        for (Class<? extends DataSchemaNode> allowedType : ALLOWED_CHILDREN) {
            if (!allowedType.isAssignableFrom(dataSchemaNode.getClass())) continue;
            return allowedType;
        }
        throw new IllegalArgumentException("Illegal child node for TO: " + dataSchemaNode.getClass() + " allowed node types: " + ALLOWED_CHILDREN);
    }

    private TOAttribute(DataSchemaNode attrNode, Map<String, AttributeIfc> transferObject, Map<String, String> attributeNameMap, String nullableDescription, String packageName) {
        super(attrNode);
        this.yangNameToAttributeMap = transferObject;
        this.attributeNameMap = attributeNameMap;
        this.nullableDescription = nullableDescription;
        this.nullableDefault = null;
        this.packageName = packageName;
    }

    public Map<String, String> getAttributeNameMap() {
        return this.attributeNameMap;
    }

    public Map<String, AttributeIfc> getCapitalizedPropertiesToTypesMap() {
        HashMap capitalizedPropertiesToTypesMap = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> entry : this.yangNameToAttributeMap.entrySet()) {
            capitalizedPropertiesToTypesMap.put(ModuleMXBeanEntry.convertToJavaName(entry.getKey(), true), entry.getValue());
        }
        return capitalizedPropertiesToTypesMap;
    }

    public Map<String, AttributeIfc> getJmxPropertiesToTypesMap() {
        HashMap jmxPropertiesToTypesMap = Maps.newHashMap();
        for (Map.Entry<String, AttributeIfc> entry : this.yangNameToAttributeMap.entrySet()) {
            jmxPropertiesToTypesMap.put(ModuleMXBeanEntry.convertToJavaName(entry.getKey(), false), entry.getValue());
        }
        return jmxPropertiesToTypesMap;
    }

    public Map<String, AttributeIfc> getYangPropertiesToTypesMap() {
        return this.yangNameToAttributeMap;
    }

    @Override
    public String getNullableDescription() {
        return this.nullableDescription;
    }

    @Override
    public String getNullableDefault() {
        return this.nullableDefault;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TOAttribute that = (TOAttribute)o;
        if (this.nullableDefault != null ? !this.nullableDefault.equals(that.nullableDefault) : that.nullableDefault != null) {
            return false;
        }
        if (this.nullableDescription != null ? !this.nullableDescription.equals(that.nullableDescription) : that.nullableDescription != null) {
            return false;
        }
        return !(this.yangNameToAttributeMap != null ? !this.yangNameToAttributeMap.equals(that.yangNameToAttributeMap) : that.yangNameToAttributeMap != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nullableDescription != null ? this.nullableDescription.hashCode() : 0);
        result = 31 * result + (this.nullableDefault != null ? this.nullableDefault.hashCode() : 0);
        result = 31 * result + (this.yangNameToAttributeMap != null ? this.yangNameToAttributeMap.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "TOAttribute{" + this.getAttributeYangName() + "," + "to=" + this.yangNameToAttributeMap + '}';
    }

    @Override
    public Type getType() {
        return new ReferencedTypeImpl(this.packageName, this.getUpperCaseCammelCase());
    }

    public CompositeType getOpenType() {
        String[] itemNames;
        String description = this.getNullableDescription() == null ? this.getAttributeYangName() : this.getNullableDescription();
        String[] itemDescriptions = itemNames = new String[this.yangNameToAttributeMap.keySet().size()];
        FunctionImpl functionImpl = new FunctionImpl(itemNames);
        Map<String, AttributeIfc> jmxPropertiesToTypesMap = this.getJmxPropertiesToTypesMap();
        OpenType[] itemTypes = Collections2.transform(jmxPropertiesToTypesMap.entrySet(), (Function)functionImpl).toArray(new OpenType[0]);
        try {
            CompositeType compositeType = new CompositeType(this.getUpperCaseCammelCase(), description, itemNames, itemDescriptions, itemTypes);
            return compositeType;
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create CompositeType for " + this, e);
        }
    }

    public String getPackageName() {
        return this.packageName;
    }

    static {
        ALLOWED_CHILDREN.add(LeafListSchemaNode.class);
        ALLOWED_CHILDREN.add(ListSchemaNode.class);
        ALLOWED_CHILDREN.add(LeafSchemaNode.class);
        ALLOWED_CHILDREN.add(ContainerSchemaNode.class);
    }

    private static final class FunctionImpl
    implements Function<Map.Entry<String, AttributeIfc>, OpenType<?>> {
        private final String[] itemNames;
        int i = 0;

        private FunctionImpl(String[] itemNames) {
            this.itemNames = itemNames;
        }

        public OpenType<?> apply(Map.Entry<String, AttributeIfc> input) {
            AttributeIfc innerType = input.getValue();
            this.itemNames[this.i++] = input.getKey();
            return innerType.getOpenType();
        }
    }
}

