/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.attribute;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Date;
import java.util.Map;
import javax.management.openmbean.SimpleType;
import org.opendaylight.yangtools.sal.binding.model.api.Type;

public class SimpleTypeResolver {
    private static final Map<String, SimpleType<?>> JAVA_TYPE_TO_SIMPLE_TYPE = Maps.newHashMap();

    public static SimpleType<?> getSimpleType(Type type) {
        SimpleType<?> expectedSimpleType = JAVA_TYPE_TO_SIMPLE_TYPE.get(type.getFullyQualifiedName());
        Preconditions.checkState((expectedSimpleType != null ? 1 : 0) != 0, (Object)("Cannot find simple type for " + type.getFullyQualifiedName()));
        return expectedSimpleType;
    }

    public static boolean canResolve(Type type) {
        return JAVA_TYPE_TO_SIMPLE_TYPE.containsKey(type.getFullyQualifiedName());
    }

    public static SimpleType<?> getSimpleType(String fullyQualifiedName) {
        SimpleType<?> expectedSimpleType = JAVA_TYPE_TO_SIMPLE_TYPE.get(fullyQualifiedName);
        Preconditions.checkState((expectedSimpleType != null ? 1 : 0) != 0, (Object)("Cannot find simple type for " + fullyQualifiedName));
        return expectedSimpleType;
    }

    static {
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Integer.class.getName(), SimpleType.INTEGER);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Integer.TYPE.getName(), SimpleType.INTEGER);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Short.class.getName(), SimpleType.SHORT);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Short.TYPE.getName(), SimpleType.SHORT);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Long.class.getName(), SimpleType.LONG);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Long.TYPE.getName(), SimpleType.LONG);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(String.class.getName(), SimpleType.STRING);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Enum.class.getName(), SimpleType.STRING);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Boolean.class.getName(), SimpleType.BOOLEAN);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Boolean.TYPE.getName(), SimpleType.BOOLEAN);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(BigInteger.class.getName(), SimpleType.BIGINTEGER);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(BigDecimal.class.getName(), SimpleType.BIGDECIMAL);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Byte.class.getName(), SimpleType.BYTE);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Byte.TYPE.getName(), SimpleType.BYTE);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Date.class.getName(), SimpleType.DATE);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Double.class.getName(), SimpleType.DOUBLE);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Double.TYPE.getName(), SimpleType.DOUBLE);
        JAVA_TYPE_TO_SIMPLE_TYPE.put(Character.TYPE.getName(), SimpleType.CHARACTER);
    }
}

