/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.attribute;

import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AbstractAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TypedAttribute;
import org.opendaylight.yangtools.binding.generator.util.Types;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;

public class ListAttribute
extends AbstractAttribute
implements TypedAttribute {
    private final String nullableDescription;
    private final String nullableDefault;
    private final TypedAttribute innerAttribute;

    public static ListAttribute create(ListSchemaNode node, TypeProviderWrapper typeProvider, String packageName) {
        TOAttribute innerAttribute = TOAttribute.create(node, typeProvider, packageName);
        return new ListAttribute((DataSchemaNode)node, innerAttribute, node.getDescription());
    }

    public static ListAttribute create(LeafListSchemaNode node, TypeProviderWrapper typeProvider) {
        JavaAttribute innerAttribute = new JavaAttribute(node, typeProvider);
        return new ListAttribute((DataSchemaNode)node, innerAttribute, node.getDescription());
    }

    ListAttribute(DataSchemaNode attrNode, TypedAttribute innerAttribute, String description) {
        super(attrNode);
        this.nullableDescription = description;
        this.innerAttribute = innerAttribute;
        this.nullableDefault = null;
    }

    @Override
    public String getNullableDescription() {
        return this.nullableDescription;
    }

    @Override
    public String getNullableDefault() {
        return this.nullableDefault;
    }

    public AttributeIfc getInnerAttribute() {
        return this.innerAttribute;
    }

    public String toString() {
        return "ListAttribute{" + this.getAttributeYangName() + "," + "to=" + this.innerAttribute + '}';
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.nullableDescription != null ? this.nullableDescription.hashCode() : 0);
        result = 31 * result + (this.nullableDefault != null ? this.nullableDefault.hashCode() : 0);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ListAttribute that = (ListAttribute)o;
        if (this.nullableDefault != null ? !this.nullableDefault.equals(that.nullableDefault) : that.nullableDefault != null) {
            return false;
        }
        return !(this.nullableDescription != null ? !this.nullableDescription.equals(that.nullableDescription) : that.nullableDescription != null);
    }

    @Override
    public Type getType() {
        return Types.parameterizedTypeFor((Type)Types.typeForClass(List.class), (Type[])new Type[]{this.innerAttribute.getType()});
    }

    public ArrayType<?> getOpenType() {
        OpenType<?> innerOpenType = this.innerAttribute.getOpenType();
        return ListAttribute.constructArrayType(innerOpenType);
    }

    static ArrayType<?> constructArrayType(OpenType<?> innerOpenType) {
        try {
            return new ArrayType(1, innerOpenType);
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create " + ArrayType.class + " with inner element of type " + innerOpenType, e);
        }
    }
}

