/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator.attribute;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.List;
import javax.management.openmbean.ArrayType;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.SimpleType;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AbstractAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.SimpleTypeResolver;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TypedAttribute;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.IdentityrefTypeDefinition;
import org.opendaylight.yangtools.yang.model.api.type.UnionTypeDefinition;

public class JavaAttribute
extends AbstractAttribute
implements TypedAttribute {
    public static final String DESCRIPTION_OF_VALUE_ATTRIBUTE_FOR_UNION = "valueOfArtificialUnionProperty";
    private final Type type;
    private final String nullableDescription;
    private final String nullableDefault;
    private final String nullableDefaultWrappedForCode;
    private final TypeProviderWrapper typeProviderWrapper;
    private final TypeDefinition<?> typeDefinition;
    public static final Class<Character> TYPE_OF_ARTIFICIAL_UNION_PROPERTY = Character.TYPE;

    public JavaAttribute(LeafSchemaNode leaf, TypeProviderWrapper typeProviderWrapper) {
        super((DataSchemaNode)leaf);
        this.type = typeProviderWrapper.getType(leaf);
        this.typeDefinition = leaf.getType();
        this.typeProviderWrapper = typeProviderWrapper;
        this.nullableDefault = leaf.getDefault();
        this.nullableDefaultWrappedForCode = leaf.getDefault() == null ? null : typeProviderWrapper.getDefault(leaf);
        this.nullableDescription = leaf.getDescription();
    }

    public JavaAttribute(LeafListSchemaNode leaf, TypeProviderWrapper typeProviderWrapper) {
        super((DataSchemaNode)leaf);
        this.type = typeProviderWrapper.getType(leaf);
        this.typeDefinition = leaf.getType();
        this.typeProviderWrapper = typeProviderWrapper;
        this.nullableDefaultWrappedForCode = null;
        this.nullableDefault = null;
        this.nullableDescription = leaf.getDescription();
    }

    public boolean isUnion() {
        TypeDefinition<?> base = this.getBaseType(this.typeProviderWrapper, this.typeDefinition);
        return base instanceof UnionTypeDefinition;
    }

    public TypeDefinition<?> getTypeDefinition() {
        return this.typeDefinition;
    }

    private TypeDefinition<?> getBaseType(TypeProviderWrapper typeProviderWrapper, TypeDefinition<?> baseType) {
        while (baseType.getBaseType() != null) {
            baseType = baseType.getBaseType();
        }
        return baseType;
    }

    public String getNullableDefaultWrappedForCode() {
        return this.nullableDefaultWrappedForCode;
    }

    @Override
    public Type getType() {
        return this.type;
    }

    @Override
    public String getNullableDescription() {
        return this.nullableDescription;
    }

    @Override
    public String getNullableDefault() {
        return this.nullableDefault;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        JavaAttribute that = (JavaAttribute)o;
        if (this.nullableDefault != null ? !this.nullableDefault.equals(that.nullableDefault) : that.nullableDefault != null) {
            return false;
        }
        if (this.nullableDescription != null ? !this.nullableDescription.equals(that.nullableDescription) : that.nullableDescription != null) {
            return false;
        }
        return !(this.type != null ? !this.type.equals(that.type) : that.type != null);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
        result = 31 * result + (this.nullableDescription != null ? this.nullableDescription.hashCode() : 0);
        result = 31 * result + (this.nullableDefault != null ? this.nullableDefault.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "JavaAttribute{" + this.getAttributeYangName() + "," + "type=" + this.type + '}';
    }

    @Override
    public OpenType<?> getOpenType() {
        TypeDefinition<?> baseTypeDefinition = this.getBaseType(this.typeProviderWrapper, this.typeDefinition);
        Type baseType = this.typeProviderWrapper.getType((SchemaNode)baseTypeDefinition, baseTypeDefinition);
        if (this.isArray()) {
            return this.getArrayType();
        }
        if (this.isEnum(baseType)) {
            return this.getSimpleType(baseType);
        }
        if (this.isUnion()) {
            return this.getCompositeTypeForUnion(baseTypeDefinition);
        }
        if (this.isDerivedType(baseType, this.getType())) {
            return this.getCompositeType(baseType, baseTypeDefinition);
        }
        if (this.isIdentityRef()) {
            return this.getCompositeTypeForIdentity();
        }
        return this.getSimpleType(this.getType());
    }

    public boolean isIdentityRef() {
        return this.typeDefinition instanceof IdentityrefTypeDefinition;
    }

    private OpenType<?> getCompositeTypeForUnion(TypeDefinition<?> baseTypeDefinition) {
        Preconditions.checkArgument((boolean)(baseTypeDefinition instanceof UnionTypeDefinition), (String)"Expected %s instance but was %s", (Object[])new Object[]{UnionTypeDefinition.class, baseTypeDefinition});
        List types = ((UnionTypeDefinition)baseTypeDefinition).getTypes();
        String[] itemNames = new String[types.size() + 1];
        Object[] itemTypes = new OpenType[itemNames.length];
        this.addArtificialPropertyToUnionCompositeType(baseTypeDefinition, itemNames, (OpenType<?>[])itemTypes);
        String description = this.getNullableDescription() == null ? this.getAttributeYangName() : this.getNullableDescription();
        int i = 1;
        for (TypeDefinition innerTypeDefinition : types) {
            Type innerType = this.typeProviderWrapper.getType((SchemaNode)innerTypeDefinition, innerTypeDefinition);
            TypeDefinition<?> baseInnerTypeDefinition = this.getBaseType(this.typeProviderWrapper, innerTypeDefinition);
            Type innerTypeBaseType = this.typeProviderWrapper.getType((SchemaNode)baseInnerTypeDefinition, baseInnerTypeDefinition);
            OpenType innerCompositeType = this.isDerivedType(innerTypeBaseType, innerType) ? this.getCompositeType(innerTypeBaseType, baseInnerTypeDefinition) : SimpleTypeResolver.getSimpleType(innerType);
            itemNames[i] = this.typeProviderWrapper.getJMXParamForUnionInnerType(innerTypeDefinition);
            itemTypes[i++] = innerCompositeType;
        }
        String[] descriptions = Arrays.copyOf(itemNames, itemNames.length);
        descriptions[0] = DESCRIPTION_OF_VALUE_ATTRIBUTE_FOR_UNION;
        try {
            return new CompositeType(this.getUpperCaseCammelCase(), description, itemNames, descriptions, (OpenType<?>[])itemTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create " + CompositeType.class + " with inner elements " + Arrays.toString(itemTypes), e);
        }
    }

    private void addArtificialPropertyToUnionCompositeType(TypeDefinition<?> baseTypeDefinition, String[] itemNames, OpenType<?>[] itemTypes) {
        String artificialPropertyName;
        itemNames[0] = artificialPropertyName = this.typeProviderWrapper.getJMXParamForBaseType(baseTypeDefinition);
        OpenType<?> artificialPropertyType = this.getArrayOpenTypeForSimpleType(TYPE_OF_ARTIFICIAL_UNION_PROPERTY.getName(), SimpleTypeResolver.getSimpleType(TYPE_OF_ARTIFICIAL_UNION_PROPERTY.getName()));
        itemTypes[0] = artificialPropertyType;
    }

    private boolean isEnum(Type baseType) {
        return baseType.getFullyQualifiedName().equals(Enum.class.getName());
    }

    private OpenType<?> getSimpleType(Type type) {
        SimpleType<?> simpleType = SimpleTypeResolver.getSimpleType(type);
        return simpleType;
    }

    private OpenType<?> getCompositeType(Type baseType, TypeDefinition<?> baseTypeDefinition) {
        SimpleType<?> innerItemType = SimpleTypeResolver.getSimpleType(baseType);
        String innerItemName = this.typeProviderWrapper.getJMXParamForBaseType(baseTypeDefinition);
        String[] itemNames = new String[]{innerItemName};
        String description = this.getNullableDescription() == null ? this.getAttributeYangName() : this.getNullableDescription();
        OpenType[] itemTypes = new OpenType[]{innerItemType};
        try {
            return new CompositeType(this.getUpperCaseCammelCase(), description, itemNames, itemNames, itemTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create " + CompositeType.class + " with inner element of type " + itemTypes, e);
        }
    }

    public OpenType<?> getCompositeTypeForIdentity() {
        String[] itemNames = new String[]{"qNameOfIdentity"};
        String description = this.getNullableDescription() == null ? this.getAttributeYangName() : this.getNullableDescription();
        OpenType[] itemTypes = new OpenType[]{SimpleType.STRING};
        try {
            return new CompositeType(this.getUpperCaseCammelCase(), description, itemNames, itemNames, itemTypes);
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create " + CompositeType.class + " with inner element of type " + itemTypes, e);
        }
    }

    private OpenType<?> getArrayType() {
        String innerTypeFullyQName = JavaAttribute.getInnerType(this.getType());
        SimpleType<?> innerSimpleType = SimpleTypeResolver.getSimpleType(innerTypeFullyQName);
        return this.getArrayOpenTypeForSimpleType(innerTypeFullyQName, innerSimpleType);
    }

    private OpenType<?> getArrayOpenTypeForSimpleType(String innerTypeFullyQName, SimpleType<?> innerSimpleType) {
        try {
            ArrayType arrayType = this.isPrimitive(innerTypeFullyQName) ? new ArrayType(innerSimpleType, true) : new ArrayType(1, innerSimpleType);
            return arrayType;
        }
        catch (OpenDataException e) {
            throw new RuntimeException("Unable to create " + ArrayType.class + " with inner element of type " + innerSimpleType, e);
        }
    }

    private boolean isPrimitive(String innerTypeFullyQName) {
        return !innerTypeFullyQName.contains(".");
    }

    private boolean isArray() {
        return this.type.getName().endsWith("[]");
    }

    private boolean isDerivedType(Type baseType, Type currentType) {
        return !baseType.equals(currentType);
    }

    private static String getInnerType(Type type) {
        String fullyQualifiedName = type.getFullyQualifiedName();
        return fullyQualifiedName.substring(0, fullyQualifiedName.length() - 2);
    }
}

