/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import org.opendaylight.yangtools.sal.binding.generator.spi.TypeProvider;
import org.opendaylight.yangtools.sal.binding.model.api.Type;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.TypeDefinition;

public class TypeProviderWrapper {
    private final TypeProvider typeProvider;

    public TypeProviderWrapper(TypeProvider typeProvider) {
        this.typeProvider = typeProvider;
    }

    public Type getType(LeafSchemaNode leaf) {
        TypeDefinition type = leaf.getType();
        return this.getType((SchemaNode)leaf, type);
    }

    public String getDefault(LeafSchemaNode node) {
        return this.typeProvider.getTypeDefaultConstruction(node);
    }

    public Type getType(SchemaNode leaf, TypeDefinition<?> type) {
        Type javaType;
        try {
            javaType = this.typeProvider.javaTypeForSchemaDefinitionType(type, leaf);
            if (javaType == null) {
                throw new IllegalArgumentException("Unknown type received for " + leaf.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error while resolving type of " + leaf, e);
        }
        return javaType;
    }

    public Type getType(LeafListSchemaNode leaf) {
        Type javaType;
        try {
            javaType = this.typeProvider.javaTypeForSchemaDefinitionType(leaf.getType(), (SchemaNode)leaf);
            if (javaType == null) {
                throw new IllegalArgumentException("Unknown type received for  " + leaf.toString());
            }
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Error while resolving type of " + leaf, e);
        }
        return javaType;
    }

    public String getJMXParamForBaseType(TypeDefinition<?> baseType) {
        return this.typeProvider.getConstructorPropertyName(baseType);
    }

    public String getJMXParamForUnionInnerType(TypeDefinition<?> unionInnerType) {
        return this.typeProvider.getParamNameFromType(unionInnerType);
    }
}

