/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServiceInterfaceEntry
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(ServiceInterfaceEntry.class);
    private static final String CLASS_NAME_SUFFIX = "ServiceInterface";
    private final Optional<ServiceInterfaceEntry> maybeBaseCache;
    private final String exportedOsgiClassName;
    private final QName qName;
    private final String nullableDescription;
    private final String packageName;
    private final String typeName;
    private final QName yangModuleQName;

    private ServiceInterfaceEntry(IdentitySchemaNode id, String packageName, QName yangModuleQName) {
        this((Optional<ServiceInterfaceEntry>)Optional.absent(), id, packageName, yangModuleQName);
    }

    private ServiceInterfaceEntry(Optional<ServiceInterfaceEntry> base, IdentitySchemaNode id, String packageName, QName yangModuleQName) {
        Preconditions.checkNotNull(base);
        this.maybeBaseCache = base;
        List unknownSchemaNodes = id.getUnknownSchemaNodes();
        ArrayList<String> exportedOsgiClassNames = new ArrayList<String>(unknownSchemaNodes.size());
        for (UnknownSchemaNode usn : unknownSchemaNodes) {
            if (ConfigConstants.JAVA_CLASS_EXTENSION_QNAME.equals((Object)usn.getNodeType())) {
                String localName = usn.getNodeParameter();
                exportedOsgiClassNames.add(localName);
                continue;
            }
            throw new IllegalStateException(String.format("Unexpected unknown schema node. Expected %s, got %s", ConfigConstants.JAVA_CLASS_EXTENSION_QNAME, usn.getNodeType()));
        }
        if (exportedOsgiClassNames.size() != 1) {
            throw new IllegalArgumentException(String.format("Cannot find one to one mapping from %s to java class defined by %s language extension in %s", this.getClass(), ConfigConstants.JAVA_CLASS_EXTENSION_QNAME, id));
        }
        this.exportedOsgiClassName = (String)exportedOsgiClassNames.get(0);
        this.qName = id.getQName();
        this.nullableDescription = id.getDescription();
        this.typeName = ServiceInterfaceEntry.getSimpleName(this.exportedOsgiClassName) + CLASS_NAME_SUFFIX;
        this.packageName = packageName;
        this.yangModuleQName = yangModuleQName;
    }

    private static final String getSimpleName(String fullyQualifiedName) {
        int lastDotPosition = fullyQualifiedName.lastIndexOf(".");
        return fullyQualifiedName.substring(lastDotPosition + 1);
    }

    public String getNullableDescription() {
        return this.nullableDescription;
    }

    public Optional<ServiceInterfaceEntry> getBase() {
        return this.maybeBaseCache;
    }

    public String getExportedOsgiClassName() {
        return this.exportedOsgiClassName;
    }

    public QName getQName() {
        return this.qName;
    }

    public static Map<QName, ServiceInterfaceEntry> create(Module currentModule, String packageName, Map<IdentitySchemaNode, ServiceInterfaceEntry> definedSEItracker) {
        logger.debug("Generating ServiceInterfaces from {} to package {}", (Object)currentModule.getNamespace(), (Object)packageName);
        HashMap<IdentitySchemaNode, ServiceInterfaceEntry> identitiesToSIs = new HashMap<IdentitySchemaNode, ServiceInterfaceEntry>();
        HashSet notVisited = new HashSet(currentModule.getIdentities());
        int lastSize = notVisited.size() + 1;
        while (notVisited.size() > 0) {
            if (notVisited.size() == lastSize) {
                logger.debug("Following identities will be ignored while generating ServiceInterfaces, as they are not derived from {} : {}", (Object)ConfigConstants.SERVICE_TYPE_Q_NAME, notVisited);
                break;
            }
            lastSize = notVisited.size();
            Iterator iterator = notVisited.iterator();
            while (iterator.hasNext()) {
                IdentitySchemaNode identity = (IdentitySchemaNode)iterator.next();
                ServiceInterfaceEntry created = null;
                if (identity.getBaseIdentity() == null) continue;
                if (identity.getBaseIdentity().getQName().equals((Object)ConfigConstants.SERVICE_TYPE_Q_NAME)) {
                    created = new ServiceInterfaceEntry(identity, packageName, ModuleUtil.getQName(currentModule));
                } else {
                    ServiceInterfaceEntry foundBase = definedSEItracker.get(identity.getBaseIdentity());
                    if (foundBase != null) {
                        created = new ServiceInterfaceEntry((Optional<ServiceInterfaceEntry>)Optional.of((Object)foundBase), identity, packageName, ModuleUtil.getQName(currentModule));
                    }
                }
                if (created == null) continue;
                created.setYangModuleName(currentModule.getName());
                created.setYangModuleLocalname(identity.getQName().getLocalName());
                identitiesToSIs.put(identity, created);
                definedSEItracker.put(identity, created);
                iterator.remove();
            }
        }
        HashMap<QName, ServiceInterfaceEntry> resultMap = new HashMap<QName, ServiceInterfaceEntry>();
        for (ServiceInterfaceEntry sie : identitiesToSIs.values()) {
            resultMap.put(sie.getQName(), sie);
        }
        logger.debug("Number of ServiceInterfaces to be generated: {}", (Object)resultMap.size());
        return resultMap;
    }

    public String getFullyQualifiedName() {
        return this.packageName + "." + this.typeName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public QName getYangModuleQName() {
        return this.yangModuleQName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInterfaceEntry that = (ServiceInterfaceEntry)o;
        if (!this.maybeBaseCache.equals(that.maybeBaseCache)) {
            return false;
        }
        if (!this.nullableDescription.equals(that.nullableDescription)) {
            return false;
        }
        if (!this.exportedOsgiClassName.equals(that.exportedOsgiClassName)) {
            return false;
        }
        if (!this.qName.equals((Object)that.qName)) {
            return false;
        }
        if (!this.packageName.equals(that.packageName)) {
            return false;
        }
        return this.typeName.equals(that.typeName);
    }

    public int hashCode() {
        int result = this.maybeBaseCache.hashCode();
        result = 31 * result + this.exportedOsgiClassName.hashCode();
        result = 31 * result + this.nullableDescription.hashCode();
        result = 31 * result + this.typeName.hashCode();
        result = 31 * result + this.packageName.hashCode();
        result = 31 * result + this.qName.hashCode();
        return result;
    }

    public String toString() {
        return "ServiceInterfaceEntry{maybeBaseCache=" + this.maybeBaseCache + ", qName='" + this.qName + '\'' + ", fullyQualifiedName='" + this.getFullyQualifiedName() + '\'' + ", exportedOsgiClassName=" + this.exportedOsgiClassName + ", nullableDescription='" + this.nullableDescription + '\'' + '}';
    }
}

