/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleMXBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.VoidAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FullyQualifiedNameHelper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.NameConflictException;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.RpcDefinition;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;

public class RuntimeBeanEntry {
    private final String packageName;
    private final String yangName;
    private final String javaNamePrefix;
    private final boolean isRoot;
    private final Optional<String> keyYangName;
    private final Optional<String> keyJavaName;
    private final Map<String, AttributeIfc> attributeMap;
    private final List<RuntimeBeanEntry> children;
    private final Set<Rpc> rpcs;
    private static final String MXBEAN_SUFFIX = "RuntimeMXBean";

    @VisibleForTesting
    RuntimeBeanEntry(String packageName, DataSchemaNode nodeForReporting, String yangName, String javaNamePrefix, boolean isRoot, Optional<String> keyYangName, List<AttributeIfc> attributes, List<RuntimeBeanEntry> children, Set<Rpc> rpcs) {
        Preconditions.checkArgument((!isRoot || !keyYangName.isPresent() ? 1 : 0) != 0, (Object)"Root RuntimeBeanEntry must not have key set");
        this.packageName = packageName;
        this.isRoot = isRoot;
        this.yangName = yangName;
        this.javaNamePrefix = javaNamePrefix;
        this.children = Collections.unmodifiableList(children);
        this.rpcs = Collections.unmodifiableSet(rpcs);
        this.keyYangName = keyYangName;
        HashMap<String, AttributeIfc> map = new HashMap<String, AttributeIfc>();
        for (AttributeIfc a : attributes) {
            Preconditions.checkState((!map.containsKey(a.getAttributeYangName()) ? 1 : 0) != 0, (Object)("Attribute already defined: " + a.getAttributeYangName() + " in " + nodeForReporting));
            map.put(a.getAttributeYangName(), a);
        }
        if (keyYangName.isPresent()) {
            AttributeIfc keyJavaName = (AttributeIfc)map.get(keyYangName.get());
            Preconditions.checkArgument((keyJavaName != null ? 1 : 0) != 0, (Object)("Key " + (String)keyYangName.get() + " not found in attribute " + "list " + attributes + " in " + nodeForReporting));
            this.keyJavaName = Optional.of((Object)keyJavaName.getUpperCaseCammelCase());
        } else {
            this.keyJavaName = Optional.absent();
        }
        this.attributeMap = Collections.unmodifiableMap(map);
    }

    public static Map<String, RuntimeBeanEntry> extractClassNameToRuntimeBeanMap(String packageName, ChoiceCaseNode container, String moduleYangName, TypeProviderWrapper typeProviderWrapper, String javaNamePrefix, Module currentModule) {
        Set rpcs;
        List attributes;
        Map<QName, Set<RpcDefinition>> identitiesToRpcs = RuntimeBeanEntry.getIdentitiesToRpcs(currentModule);
        AttributesRpcsAndRuntimeBeans attributesRpcsAndRuntimeBeans = RuntimeBeanEntry.extractSubtree(packageName, (DataNodeContainer)container, typeProviderWrapper, currentModule, identitiesToRpcs);
        HashMap<String, RuntimeBeanEntry> result = new HashMap<String, RuntimeBeanEntry>();
        if (!attributesRpcsAndRuntimeBeans.isEmpty()) {
            attributes = attributesRpcsAndRuntimeBeans.getAttributes();
            rpcs = attributesRpcsAndRuntimeBeans.getRpcs();
        } else {
            attributes = Collections.emptyList();
            rpcs = Collections.emptySet();
        }
        RuntimeBeanEntry rootRuntimeBeanEntry = RuntimeBeanEntry.createRoot(packageName, (DataSchemaNode)container, moduleYangName, attributes, javaNamePrefix, attributesRpcsAndRuntimeBeans.getRuntimeBeanEntries(), rpcs);
        LinkedList<RuntimeBeanEntry> stack = new LinkedList<RuntimeBeanEntry>();
        stack.add(rootRuntimeBeanEntry);
        while (!stack.isEmpty()) {
            RuntimeBeanEntry first = (RuntimeBeanEntry)stack.pollFirst();
            if (result.containsKey(first.getJavaNameOfRuntimeMXBean())) {
                throw new NameConflictException(first.getJavaNameOfRuntimeMXBean(), null, null);
            }
            result.put(first.getJavaNameOfRuntimeMXBean(), first);
            stack.addAll(first.getChildren());
        }
        return result;
    }

    private static Map<QName, Set<RpcDefinition>> getIdentitiesToRpcs(Module currentModule) {
        HashMap<QName, Set<RpcDefinition>> result = new HashMap<QName, Set<RpcDefinition>>();
        for (IdentitySchemaNode identity : currentModule.getIdentities()) {
            result.put(identity.getQName(), new HashSet());
        }
        for (RpcDefinition rpc : currentModule.getRpcs()) {
            ContainerSchemaNode input = rpc.getInput();
            if (input == null) continue;
            for (UsesNode uses : input.getUses()) {
                QName qname;
                if (uses.getGroupingPath().getPath().size() != 1 || !(qname = (QName)uses.getGroupingPath().getPath().get(0)).equals((Object)ConfigConstants.RPC_CONTEXT_REF_GROUPING_QNAME)) continue;
                for (SchemaNode refinedNode : uses.getRefines().values()) {
                    for (UnknownSchemaNode unknownSchemaNode : refinedNode.getUnknownSchemaNodes()) {
                        if (!ConfigConstants.RPC_CONTEXT_INSTANCE_EXTENSION_QNAME.equals((Object)unknownSchemaNode.getNodeType())) continue;
                        String localIdentityName = unknownSchemaNode.getNodeParameter();
                        QName identityQName = new QName(currentModule.getNamespace(), currentModule.getRevision(), localIdentityName);
                        Set rpcDefinitions = (Set)result.get(identityQName);
                        if (rpcDefinitions == null) {
                            throw new IllegalArgumentException("Identity referenced by rpc not found. Identity:" + localIdentityName + " , rpc " + rpc);
                        }
                        rpcDefinitions.add(rpc);
                    }
                }
            }
        }
        return result;
    }

    private static AttributesRpcsAndRuntimeBeans extractSubtree(String packageName, DataNodeContainer subtree, TypeProviderWrapper typeProviderWrapper, Module currentModule, Map<QName, Set<RpcDefinition>> identitiesToRpcs) {
        ArrayList attributes = Lists.newArrayList();
        ArrayList<RuntimeBeanEntry> runtimeBeanEntries = new ArrayList<RuntimeBeanEntry>();
        for (DataSchemaNode child : subtree.getChildNodes()) {
            ListAttribute listAttribute;
            if (child instanceof LeafSchemaNode) {
                LeafSchemaNode leaf = (LeafSchemaNode)child;
                attributes.add(new JavaAttribute(leaf, typeProviderWrapper));
                continue;
            }
            if (child instanceof ContainerSchemaNode) {
                ContainerSchemaNode container = (ContainerSchemaNode)child;
                TOAttribute toAttribute = TOAttribute.create(container, typeProviderWrapper, packageName);
                attributes.add(toAttribute);
                continue;
            }
            if (child instanceof ListSchemaNode) {
                if (RuntimeBeanEntry.isInnerStateBean(child)) {
                    ListSchemaNode listSchemaNode = (ListSchemaNode)child;
                    RuntimeBeanEntry hierarchicalChild = RuntimeBeanEntry.createHierarchical(packageName, listSchemaNode, typeProviderWrapper, currentModule, identitiesToRpcs);
                    runtimeBeanEntries.add(hierarchicalChild);
                    continue;
                }
                listAttribute = ListAttribute.create((ListSchemaNode)child, typeProviderWrapper, packageName);
                attributes.add(listAttribute);
                continue;
            }
            if (child instanceof LeafListSchemaNode) {
                listAttribute = ListAttribute.create((LeafListSchemaNode)child, typeProviderWrapper);
                attributes.add(listAttribute);
                continue;
            }
            throw new IllegalStateException("Unexpected running-data node " + child);
        }
        HashSet<Rpc> rpcs = new HashSet<Rpc>();
        SchemaNode subtreeSchemaNode = (SchemaNode)subtree;
        for (UnknownSchemaNode unknownSchemaNode : subtreeSchemaNode.getUnknownSchemaNodes()) {
            if (!ConfigConstants.RPC_CONTEXT_INSTANCE_EXTENSION_QNAME.equals((Object)unknownSchemaNode.getNodeType())) continue;
            String localIdentityName = unknownSchemaNode.getNodeParameter();
            QName identityQName = new QName(currentModule.getNamespace(), currentModule.getRevision(), localIdentityName);
            Set<RpcDefinition> rpcDefinitions = identitiesToRpcs.get(identityQName);
            if (rpcDefinitions == null) {
                throw new IllegalArgumentException("Cannot find identity " + localIdentityName + " to be used as " + "context reference when resolving " + unknownSchemaNode);
            }
            for (RpcDefinition rpcDefinition : rpcDefinitions) {
                AttributeIfc returnType;
                String name = ModuleMXBeanEntry.findJavaParameter((SchemaNode)rpcDefinition);
                if (rpcDefinition.getOutput() == null || rpcDefinition.getOutput().getChildNodes().size() == 0) {
                    returnType = VoidAttribute.getInstance();
                } else if (rpcDefinition.getOutput().getChildNodes().size() == 1) {
                    DataSchemaNode returnDSN = (DataSchemaNode)rpcDefinition.getOutput().getChildNodes().iterator().next();
                    returnType = RuntimeBeanEntry.getReturnTypeAttribute(returnDSN, typeProviderWrapper, packageName);
                } else {
                    throw new IllegalArgumentException("More than one child node in rpc output is not supported. Error occured in " + rpcDefinition);
                }
                ArrayList<JavaAttribute> parameters = new ArrayList<JavaAttribute>();
                for (DataSchemaNode childNode : RuntimeBeanEntry.sortAttributes(rpcDefinition.getInput().getChildNodes())) {
                    if (childNode.isAddedByUses()) continue;
                    Preconditions.checkArgument((boolean)(childNode instanceof LeafSchemaNode), (Object)("Unexpected type of rpc input type. Currently only leafs and empty output nodes are supported, got " + childNode));
                    JavaAttribute javaAttribute = new JavaAttribute((LeafSchemaNode)childNode, typeProviderWrapper);
                    parameters.add(javaAttribute);
                }
                Rpc newRpc = new Rpc(returnType, name, rpcDefinition.getQName().getLocalName(), parameters);
                rpcs.add(newRpc);
            }
        }
        return new AttributesRpcsAndRuntimeBeans(runtimeBeanEntries, attributes, rpcs);
    }

    private static AttributeIfc getReturnTypeAttribute(DataSchemaNode child, TypeProviderWrapper typeProviderWrapper, String packageName) {
        if (child instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)child;
            return new JavaAttribute(leaf, typeProviderWrapper);
        }
        if (child instanceof ContainerSchemaNode) {
            ContainerSchemaNode container = (ContainerSchemaNode)child;
            TOAttribute toAttribute = TOAttribute.create(container, typeProviderWrapper, packageName);
            return toAttribute;
        }
        if (child instanceof ListSchemaNode) {
            return ListAttribute.create((ListSchemaNode)child, typeProviderWrapper, packageName);
        }
        if (child instanceof LeafListSchemaNode) {
            return ListAttribute.create((LeafListSchemaNode)child, typeProviderWrapper);
        }
        throw new IllegalStateException("Unknown output data node " + child + " for rpc");
    }

    private static Collection<DataSchemaNode> sortAttributes(Set<DataSchemaNode> childNodes) {
        TreeSet<DataSchemaNode> dataSchemaNodes = new TreeSet<DataSchemaNode>(new Comparator<DataSchemaNode>(){

            @Override
            public int compare(DataSchemaNode o1, DataSchemaNode o2) {
                return o1.getQName().getLocalName().compareTo(o2.getQName().getLocalName());
            }
        });
        dataSchemaNodes.addAll(childNodes);
        return dataSchemaNodes;
    }

    private static boolean isInnerStateBean(DataSchemaNode child) {
        for (UnknownSchemaNode unknownSchemaNode : child.getUnknownSchemaNodes()) {
            if (!unknownSchemaNode.getNodeType().equals((Object)ConfigConstants.INNER_STATE_BEAN_EXTENSION_QNAME)) continue;
            return true;
        }
        return false;
    }

    private static RuntimeBeanEntry createHierarchical(String packageName, ListSchemaNode listSchemaNode, TypeProviderWrapper typeProviderWrapper, Module currentModule, Map<QName, Set<RpcDefinition>> identitiesToRpcs) {
        Optional keyYangName;
        AttributesRpcsAndRuntimeBeans attributesRpcsAndRuntimeBeans = RuntimeBeanEntry.extractSubtree(packageName, (DataNodeContainer)listSchemaNode, typeProviderWrapper, currentModule, identitiesToRpcs);
        if (listSchemaNode.getKeyDefinition().size() == 0) {
            keyYangName = Optional.absent();
        } else if (listSchemaNode.getKeyDefinition().size() == 1) {
            QName keyQName = (QName)listSchemaNode.getKeyDefinition().iterator().next();
            keyYangName = Optional.of((Object)keyQName.getLocalName());
        } else {
            throw new IllegalArgumentException("More than one key is not supported in " + listSchemaNode);
        }
        String javaNamePrefix = ModuleMXBeanEntry.findJavaNamePrefix((SchemaNode)listSchemaNode);
        RuntimeBeanEntry rbFromAttributes = new RuntimeBeanEntry(packageName, (DataSchemaNode)listSchemaNode, listSchemaNode.getQName().getLocalName(), javaNamePrefix, false, (Optional<String>)keyYangName, attributesRpcsAndRuntimeBeans.getAttributes(), attributesRpcsAndRuntimeBeans.getRuntimeBeanEntries(), attributesRpcsAndRuntimeBeans.getRpcs());
        return rbFromAttributes;
    }

    private static RuntimeBeanEntry createRoot(String packageName, DataSchemaNode nodeForReporting, String attributeYangName, List<AttributeIfc> attributes, String javaNamePrefix, List<RuntimeBeanEntry> children, Set<Rpc> rpcs) {
        return new RuntimeBeanEntry(packageName, nodeForReporting, attributeYangName, javaNamePrefix, true, (Optional<String>)Optional.absent(), attributes, children, rpcs);
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public Optional<String> getKeyYangName() {
        return this.keyYangName;
    }

    public Optional<String> getKeyJavaName() {
        return this.keyJavaName;
    }

    public Collection<AttributeIfc> getAttributes() {
        return this.attributeMap.values();
    }

    public Map<String, AttributeIfc> getYangPropertiesToTypesMap() {
        return this.attributeMap;
    }

    public String getYangName() {
        return this.yangName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getJavaNamePrefix() {
        return this.javaNamePrefix;
    }

    public List<RuntimeBeanEntry> getChildren() {
        return this.children;
    }

    public Set<Rpc> getRpcs() {
        return this.rpcs;
    }

    public String getJavaNameOfRuntimeMXBean() {
        return RuntimeBeanEntry.getJavaNameOfRuntimeMXBean(this.javaNamePrefix);
    }

    public String getFullyQualifiedName(String typeName) {
        return FullyQualifiedNameHelper.getFullyQualifiedName(this.packageName, typeName);
    }

    private static String getJavaNameOfRuntimeMXBean(String javaNamePrefix) {
        return javaNamePrefix + MXBEAN_SUFFIX;
    }

    public String toString() {
        return "RuntimeBeanEntry{isRoot=" + this.isRoot + ", yangName='" + this.yangName + '\'' + ", packageName='" + this.packageName + '\'' + ", keyYangName=" + this.keyYangName + '}';
    }

    public static class Rpc {
        private final String name;
        private final List<JavaAttribute> parameters;
        private final AttributeIfc returnType;
        private final String yangName;

        Rpc(AttributeIfc returnType, String name, String yangName, List<JavaAttribute> parameters) {
            this.returnType = returnType;
            this.name = name;
            this.parameters = parameters;
            this.yangName = yangName;
        }

        public String getYangName() {
            return this.yangName;
        }

        public String getName() {
            return this.name;
        }

        public List<JavaAttribute> getParameters() {
            return this.parameters;
        }

        public AttributeIfc getReturnType() {
            return this.returnType;
        }
    }

    private static class AttributesRpcsAndRuntimeBeans {
        private final List<RuntimeBeanEntry> runtimeBeanEntries;
        private final List<AttributeIfc> attributes;
        private final Set<Rpc> rpcs;

        public AttributesRpcsAndRuntimeBeans(List<RuntimeBeanEntry> runtimeBeanEntries, List<AttributeIfc> attributes, Set<Rpc> rpcs) {
            this.runtimeBeanEntries = runtimeBeanEntries;
            this.attributes = attributes;
            this.rpcs = rpcs;
        }

        private List<AttributeIfc> getAttributes() {
            return this.attributes;
        }

        public List<RuntimeBeanEntry> getRuntimeBeanEntries() {
            return this.runtimeBeanEntries;
        }

        public boolean isEmpty() {
            return this.attributes.isEmpty() && this.rpcs.isEmpty();
        }

        private Set<Rpc> getRpcs() {
            return this.rpcs;
        }
    }
}

