/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import java.util.Map;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.yang.model.api.Module;

public class PackageTranslator {
    private final Map<String, String> namespacePrefixToPackageMap;

    public PackageTranslator(Map<String, String> namespacePrefixToPackageMap) {
        this.namespacePrefixToPackageMap = namespacePrefixToPackageMap;
    }

    public String getPackageName(Module module) {
        Map.Entry<String, String> longestMatch = null;
        int longestMatchLength = 0;
        String namespace = module.getNamespace().toString();
        for (Map.Entry<String, String> entry : this.namespacePrefixToPackageMap.entrySet()) {
            if (!namespace.startsWith(entry.getKey()) || entry.getKey().length() <= longestMatchLength) continue;
            longestMatch = entry;
            longestMatchLength = entry.getKey().length();
        }
        if (longestMatch != null) {
            return (String)longestMatch.getValue() + PackageTranslator.sanitizePackage(namespace.substring(longestMatchLength));
        }
        return BindingGeneratorUtil.moduleNamespaceToPackageName((Module)module);
    }

    private static String sanitizePackage(String namespace) {
        namespace = namespace.replace("://", ".");
        namespace = namespace.replace("/", ".");
        namespace = namespace.replace(":", ".");
        namespace = namespace.replace("-", "_");
        namespace = namespace.replace("@", ".");
        namespace = namespace.replace("$", ".");
        namespace = namespace.replace("#", ".");
        namespace = namespace.replace("'", ".");
        namespace = namespace.replace("*", ".");
        namespace = namespace.replace("+", ".");
        namespace = namespace.replace(",", ".");
        namespace = namespace.replace(";", ".");
        namespace = namespace.replace("=", ".");
        return namespace;
    }
}

