/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opendaylight.controller.config.yangjmxgenerator.AbstractEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ConfigConstants;
import org.opendaylight.controller.config.yangjmxgenerator.ModuleUtil;
import org.opendaylight.controller.config.yangjmxgenerator.RuntimeBeanEntry;
import org.opendaylight.controller.config.yangjmxgenerator.ServiceInterfaceEntry;
import org.opendaylight.controller.config.yangjmxgenerator.TypeProviderWrapper;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AbstractDependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.AttributeIfc;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.DependencyAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.JavaAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.ListDependenciesAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.attribute.TOAttribute;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.FullyQualifiedNameHelper;
import org.opendaylight.controller.config.yangjmxgenerator.plugin.util.NameConflictException;
import org.opendaylight.yangtools.binding.generator.util.BindingGeneratorUtil;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.model.api.AugmentationSchema;
import org.opendaylight.yangtools.yang.model.api.ChoiceCaseNode;
import org.opendaylight.yangtools.yang.model.api.ContainerSchemaNode;
import org.opendaylight.yangtools.yang.model.api.DataNodeContainer;
import org.opendaylight.yangtools.yang.model.api.DataSchemaNode;
import org.opendaylight.yangtools.yang.model.api.IdentitySchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.LeafSchemaNode;
import org.opendaylight.yangtools.yang.model.api.ListSchemaNode;
import org.opendaylight.yangtools.yang.model.api.Module;
import org.opendaylight.yangtools.yang.model.api.ModuleImport;
import org.opendaylight.yangtools.yang.model.api.RevisionAwareXPath;
import org.opendaylight.yangtools.yang.model.api.SchemaContext;
import org.opendaylight.yangtools.yang.model.api.SchemaNode;
import org.opendaylight.yangtools.yang.model.api.SchemaPath;
import org.opendaylight.yangtools.yang.model.api.UnknownSchemaNode;
import org.opendaylight.yangtools.yang.model.api.UsesNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModuleMXBeanEntry
extends AbstractEntry {
    private static final Logger logger = LoggerFactory.getLogger(ModuleMXBeanEntry.class);
    private static final String MAGIC_STRING = "MAGIC_STRING";
    private static final String MODULE_CONDITION_XPATH_TEMPLATE = "^/MAGIC_STRING:modules/MAGIC_STRING:module/MAGIC_STRING:type\\s*=\\s*['\"](.+)['\"]$";
    private static final SchemaPath expectedConfigurationAugmentationSchemaPath = new SchemaPath(Arrays.asList(ConfigConstants.createConfigQName("modules"), ConfigConstants.createConfigQName("module"), ConfigConstants.createConfigQName("configuration")), true);
    private static final SchemaPath expectedStateAugmentationSchemaPath = new SchemaPath(Arrays.asList(ConfigConstants.createConfigQName("modules"), ConfigConstants.createConfigQName("module"), ConfigConstants.createConfigQName("state")), true);
    private static final Pattern PREFIX_COLON_LOCAL_NAME = Pattern.compile("^(.+):(.+)$");
    private static final String MODULE_SUFFIX = "Module";
    private static final String FACTORY_SUFFIX = "ModuleFactory";
    private static final String CLASS_NAME_SUFFIX = "ModuleMXBean";
    private static final String ABSTRACT_PREFIX = "Abstract";
    private final String globallyUniqueName;
    private Map<String, AttributeIfc> yangToAttributes;
    private final String nullableDescription;
    private final String packageName;
    private final String javaNamePrefix;
    private final String namespace;
    private final Map<String, QName> providedServices;
    private Collection<RuntimeBeanEntry> runtimeBeans;
    private final QName yangModuleQName;

    public ModuleMXBeanEntry(IdentitySchemaNode id, Map<String, AttributeIfc> yangToAttributes, String packageName, Map<String, QName> providedServices2, String javaNamePrefix, String namespace, Collection<RuntimeBeanEntry> runtimeBeans, QName yangModuleQName) {
        this.globallyUniqueName = id.getQName().getLocalName();
        this.yangToAttributes = yangToAttributes;
        this.nullableDescription = id.getDescription();
        this.packageName = packageName;
        this.javaNamePrefix = (String)Preconditions.checkNotNull((Object)javaNamePrefix);
        this.namespace = (String)Preconditions.checkNotNull((Object)namespace);
        this.providedServices = Collections.unmodifiableMap(providedServices2);
        this.runtimeBeans = runtimeBeans;
        this.yangModuleQName = yangModuleQName;
    }

    public String getMXBeanInterfaceName() {
        return this.javaNamePrefix + CLASS_NAME_SUFFIX;
    }

    public String getStubFactoryName() {
        return this.javaNamePrefix + FACTORY_SUFFIX;
    }

    public String getAbstractFactoryName() {
        return ABSTRACT_PREFIX + this.getStubFactoryName();
    }

    public String getStubModuleName() {
        return this.javaNamePrefix + MODULE_SUFFIX;
    }

    public String getAbstractModuleName() {
        return ABSTRACT_PREFIX + this.getStubModuleName();
    }

    public String getFullyQualifiedName(String typeName) {
        return FullyQualifiedNameHelper.getFullyQualifiedName(this.packageName, typeName);
    }

    public String getGloballyUniqueName() {
        return this.globallyUniqueName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public Map<String, QName> getProvidedServices() {
        return this.providedServices;
    }

    public void setRuntimeBeans(Collection<RuntimeBeanEntry> newRuntimeBeans) {
        this.runtimeBeans = newRuntimeBeans;
    }

    public Collection<RuntimeBeanEntry> getRuntimeBeans() {
        return this.runtimeBeans;
    }

    public String getJavaNamePrefix() {
        return this.javaNamePrefix;
    }

    public String getNamespace() {
        return this.namespace;
    }

    @VisibleForTesting
    static Matcher getWhenConditionMatcher(String prefix, RevisionAwareXPath whenConstraint) {
        String xpathRegex = MODULE_CONDITION_XPATH_TEMPLATE.replace(MAGIC_STRING, prefix);
        Pattern pattern = Pattern.compile(xpathRegex);
        return pattern.matcher(whenConstraint.toString());
    }

    static String getConfigModulePrefixFromImport(Module currentModule) {
        for (ModuleImport currentImport : currentModule.getImports()) {
            if (!currentImport.getModuleName().equals("config")) continue;
            return currentImport.getPrefix();
        }
        throw new IllegalArgumentException("Cannot find import config in " + currentModule);
    }

    public static Map<String, ModuleMXBeanEntry> create(Module currentModule, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, SchemaContext schemaContext, TypeProviderWrapper typeProviderWrapper, String packageName) {
        String configModulePrefix;
        HashMap<String, QName> uniqueGeneratedClassesNames = new HashMap<String, QName>();
        logger.debug("Generating ModuleMXBeans of {} to package {}", (Object)currentModule.getNamespace(), (Object)packageName);
        try {
            configModulePrefix = ModuleMXBeanEntry.getConfigModulePrefixFromImport(currentModule);
        }
        catch (IllegalArgumentException e) {
            return Collections.emptyMap();
        }
        HashMap<String, IdentitySchemaNode> moduleIdentities = new HashMap<String, IdentitySchemaNode>();
        for (IdentitySchemaNode id : currentModule.getIdentities()) {
            if (id.getBaseIdentity() == null || !ConfigConstants.MODULE_TYPE_Q_NAME.equals((Object)id.getBaseIdentity().getQName())) continue;
            String identityLocalName = id.getQName().getLocalName();
            if (moduleIdentities.containsKey(identityLocalName)) {
                throw new IllegalStateException("Module name already defined in this module: " + identityLocalName);
            }
            moduleIdentities.put(identityLocalName, id);
            logger.debug("Found identity {}", (Object)identityLocalName);
            boolean bl = false;
            for (UnknownSchemaNode unknownNode : id.getUnknownSchemaNodes()) {
                if (ConfigConstants.PROVIDED_SERVICE_EXTENSION_QNAME.equals((Object)unknownNode.getNodeType())) continue;
                if (ConfigConstants.JAVA_NAME_PREFIX_EXTENSION_QNAME.equals((Object)unknownNode.getNodeType())) {
                    Preconditions.checkState((!bl ? 1 : 0) != 0, (Object)String.format("More than one language extension %s is not allowed here: %s", ConfigConstants.JAVA_NAME_PREFIX_EXTENSION_QNAME, id));
                    bl = true;
                    continue;
                }
                throw new IllegalStateException("Unexpected language extension " + unknownNode.getNodeType());
            }
        }
        HashMap<String, ModuleMXBeanEntry> result = new HashMap<String, ModuleMXBeanEntry>();
        HashMap unaugmentedModuleIdentities = new HashMap(moduleIdentities);
        for (AugmentationSchema augmentationSchema : currentModule.getAugmentations()) {
            ModuleMXBeanEntry moduleMXBeanEntry;
            RevisionAwareXPath xPath;
            Matcher matcher;
            ChoiceCaseNode choiceCaseNode;
            DataSchemaNode when;
            Set childNodes = augmentationSchema.getChildNodes();
            if (childNodes.size() != 1 || !((when = (DataSchemaNode)childNodes.iterator().next()) instanceof ChoiceCaseNode) || (choiceCaseNode = (ChoiceCaseNode)when).getConstraints() == null || choiceCaseNode.getConstraints().getWhenCondition() == null || !(matcher = ModuleMXBeanEntry.getWhenConditionMatcher(configModulePrefix, xPath = choiceCaseNode.getConstraints().getWhenCondition())).matches()) continue;
            String moduleLocalNameFromXPath = matcher.group(1);
            IdentitySchemaNode moduleIdentity = (IdentitySchemaNode)moduleIdentities.get(moduleLocalNameFromXPath);
            unaugmentedModuleIdentities.remove(moduleLocalNameFromXPath);
            Preconditions.checkState((moduleIdentity != null ? 1 : 0) != 0, (Object)("Cannot find identity " + moduleLocalNameFromXPath + " matching augmentation " + augmentationSchema));
            Map<String, QName> providedServices = ModuleMXBeanEntry.findProvidedServices(moduleIdentity, currentModule, qNamesToSIEs, schemaContext);
            if (moduleIdentity == null) {
                throw new IllegalStateException("Cannot find identity specified by augmentation xpath constraint: " + moduleLocalNameFromXPath + " of " + augmentationSchema);
            }
            String javaNamePrefix = ModuleMXBeanEntry.findJavaNamePrefix((SchemaNode)moduleIdentity);
            Map<String, AttributeIfc> yangToAttributes = null;
            Collection<RuntimeBeanEntry> runtimeBeans = null;
            if (expectedConfigurationAugmentationSchemaPath.equals((Object)augmentationSchema.getTargetPath())) {
                logger.debug("Parsing configuration of {}", (Object)moduleLocalNameFromXPath);
                yangToAttributes = ModuleMXBeanEntry.fillConfiguration(choiceCaseNode, currentModule, typeProviderWrapper, qNamesToSIEs, schemaContext, packageName);
                ModuleMXBeanEntry.checkUniqueAttributesWithGeneratedClass(uniqueGeneratedClassesNames, when.getQName(), yangToAttributes);
            } else if (expectedStateAugmentationSchemaPath.equals((Object)augmentationSchema.getTargetPath())) {
                logger.debug("Parsing state of {}", (Object)moduleLocalNameFromXPath);
                try {
                    runtimeBeans = ModuleMXBeanEntry.fillRuntimeBeans(choiceCaseNode, currentModule, typeProviderWrapper, packageName, moduleLocalNameFromXPath, javaNamePrefix);
                }
                catch (NameConflictException e) {
                    throw new NameConflictException(e.getConflictingName(), when.getQName(), when.getQName());
                }
                ModuleMXBeanEntry.checkUniqueRuntimeBeansGeneratedClasses(uniqueGeneratedClassesNames, when, runtimeBeans);
                HashSet runtimeBeanEntryValues = Sets.newHashSet(runtimeBeans);
                for (RuntimeBeanEntry entry : runtimeBeanEntryValues) {
                    ModuleMXBeanEntry.checkUniqueAttributesWithGeneratedClass(uniqueGeneratedClassesNames, when.getQName(), entry.getYangPropertiesToTypesMap());
                }
            } else {
                throw new IllegalArgumentException("Cannot parse augmentation " + augmentationSchema);
            }
            if (result.containsKey(moduleLocalNameFromXPath)) {
                moduleMXBeanEntry = (ModuleMXBeanEntry)result.get(moduleLocalNameFromXPath);
                if (yangToAttributes != null && moduleMXBeanEntry.getAttributes() == null) {
                    moduleMXBeanEntry.setYangToAttributes(yangToAttributes);
                    continue;
                }
                if (runtimeBeans == null || moduleMXBeanEntry.getRuntimeBeans() != null) continue;
                moduleMXBeanEntry.setRuntimeBeans(runtimeBeans);
                continue;
            }
            moduleMXBeanEntry = new ModuleMXBeanEntry(moduleIdentity, yangToAttributes, packageName, providedServices, javaNamePrefix, currentModule.getNamespace().toString(), runtimeBeans, ModuleUtil.getQName(currentModule));
            moduleMXBeanEntry.setYangModuleName(currentModule.getName());
            moduleMXBeanEntry.setYangModuleLocalname(moduleLocalNameFromXPath);
            result.put(moduleLocalNameFromXPath, moduleMXBeanEntry);
        }
        for (Map.Entry entry : result.entrySet()) {
            ModuleMXBeanEntry module = (ModuleMXBeanEntry)entry.getValue();
            if (module.getAttributes() == null) {
                module.setYangToAttributes(Collections.emptyMap());
                continue;
            }
            if (module.getRuntimeBeans() != null) continue;
            module.setRuntimeBeans(Collections.emptyList());
        }
        for (Map.Entry entry : result.entrySet()) {
            ModuleMXBeanEntry.checkUniqueRuntimeBeanAttributesName((ModuleMXBeanEntry)entry.getValue(), uniqueGeneratedClassesNames);
        }
        if (unaugmentedModuleIdentities.size() > 0) {
            logger.warn("Augmentation not found for all module identities: {}", unaugmentedModuleIdentities.keySet());
        }
        logger.debug("Number of ModuleMXBeans to be generated: {}", (Object)result.size());
        return result;
    }

    private static void checkUniqueRuntimeBeansGeneratedClasses(Map<String, QName> uniqueGeneratedClassesNames, DataSchemaNode when, Collection<RuntimeBeanEntry> runtimeBeans) {
        for (RuntimeBeanEntry runtimeBean : runtimeBeans) {
            String javaNameOfRuntimeMXBean = runtimeBean.getJavaNameOfRuntimeMXBean();
            if (uniqueGeneratedClassesNames.containsKey(javaNameOfRuntimeMXBean)) {
                QName firstDefinedQName = uniqueGeneratedClassesNames.get(javaNameOfRuntimeMXBean);
                throw new NameConflictException(javaNameOfRuntimeMXBean, firstDefinedQName, when.getQName());
            }
            uniqueGeneratedClassesNames.put(javaNameOfRuntimeMXBean, when.getQName());
        }
    }

    private static void checkUniqueRuntimeBeanAttributesName(ModuleMXBeanEntry mxBeanEntry, Map<String, QName> uniqueGeneratedClassesNames) {
        for (RuntimeBeanEntry runtimeBeanEntry : mxBeanEntry.getRuntimeBeans()) {
            for (String runtimeAttName : runtimeBeanEntry.getYangPropertiesToTypesMap().keySet()) {
                if (!mxBeanEntry.getAttributes().keySet().contains(runtimeAttName)) continue;
                QName qName1 = uniqueGeneratedClassesNames.get(runtimeBeanEntry.getJavaNameOfRuntimeMXBean());
                QName qName2 = uniqueGeneratedClassesNames.get(mxBeanEntry.getGloballyUniqueName());
                throw new NameConflictException(runtimeAttName, qName1, qName2);
            }
        }
    }

    private static void checkUniqueAttributesWithGeneratedClass(Map<String, QName> uniqueGeneratedClassNames, QName parentQName, Map<String, AttributeIfc> yangToAttributes) {
        for (Map.Entry<String, AttributeIfc> attr : yangToAttributes.entrySet()) {
            if (attr.getValue() instanceof TOAttribute) {
                ModuleMXBeanEntry.checkUniqueTOAttr(uniqueGeneratedClassNames, parentQName, (TOAttribute)attr.getValue());
                continue;
            }
            if (!(attr.getValue() instanceof ListAttribute) || !(((ListAttribute)attr.getValue()).getInnerAttribute() instanceof TOAttribute)) continue;
            ModuleMXBeanEntry.checkUniqueTOAttr(uniqueGeneratedClassNames, parentQName, (TOAttribute)((ListAttribute)attr.getValue()).getInnerAttribute());
        }
    }

    private static void checkUniqueTOAttr(Map<String, QName> uniqueGeneratedClassNames, QName parentQName, TOAttribute attr) {
        String upperCaseCammelCase = attr.getUpperCaseCammelCase();
        if (uniqueGeneratedClassNames.containsKey(upperCaseCammelCase)) {
            QName firstDefinedQName = uniqueGeneratedClassNames.get(upperCaseCammelCase);
            throw new NameConflictException(upperCaseCammelCase, firstDefinedQName, parentQName);
        }
        uniqueGeneratedClassNames.put(upperCaseCammelCase, parentQName);
    }

    private static Collection<RuntimeBeanEntry> fillRuntimeBeans(ChoiceCaseNode choiceCaseNode, Module currentModule, TypeProviderWrapper typeProviderWrapper, String packageName, String moduleLocalNameFromXPath, String javaNamePrefix) {
        return RuntimeBeanEntry.extractClassNameToRuntimeBeanMap(packageName, choiceCaseNode, moduleLocalNameFromXPath, typeProviderWrapper, javaNamePrefix, currentModule).values();
    }

    private static Map<String, AttributeIfc> fillConfiguration(ChoiceCaseNode choiceCaseNode, Module currentModule, TypeProviderWrapper typeProviderWrapper, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, SchemaContext schemaContext, String packageName) {
        HashMap<String, AttributeIfc> yangToAttributes = new HashMap<String, AttributeIfc>();
        for (DataSchemaNode attrNode : choiceCaseNode.getChildNodes()) {
            AttributeIfc attributeValue = ModuleMXBeanEntry.getAttributeValue(attrNode, currentModule, qNamesToSIEs, typeProviderWrapper, schemaContext, packageName);
            yangToAttributes.put(attributeValue.getAttributeYangName(), attributeValue);
        }
        return yangToAttributes;
    }

    private static Map<String, QName> findProvidedServices(IdentitySchemaNode moduleIdentity, Module currentModule, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, SchemaContext schemaContext) {
        HashMap<String, QName> result = new HashMap<String, QName>();
        for (UnknownSchemaNode unknownNode : moduleIdentity.getUnknownSchemaNodes()) {
            if (!ConfigConstants.PROVIDED_SERVICE_EXTENSION_QNAME.equals((Object)unknownNode.getNodeType())) continue;
            String prefixAndIdentityLocalName = unknownNode.getNodeParameter();
            ServiceInterfaceEntry sie = ModuleMXBeanEntry.findSIE(prefixAndIdentityLocalName, currentModule, qNamesToSIEs, schemaContext);
            result.put(sie.getFullyQualifiedName(), sie.getQName());
        }
        return result;
    }

    public static String findJavaNamePrefix(SchemaNode schemaNode) {
        return ModuleMXBeanEntry.convertToJavaName(schemaNode, true);
    }

    public static String findJavaParameter(SchemaNode schemaNode) {
        return ModuleMXBeanEntry.convertToJavaName(schemaNode, false);
    }

    public static String convertToJavaName(SchemaNode schemaNode, boolean capitalizeFirstLetter) {
        for (UnknownSchemaNode unknownNode : schemaNode.getUnknownSchemaNodes()) {
            if (!ConfigConstants.JAVA_NAME_PREFIX_EXTENSION_QNAME.equals((Object)unknownNode.getNodeType())) continue;
            String value = unknownNode.getNodeParameter();
            return ModuleMXBeanEntry.convertToJavaName(value, capitalizeFirstLetter);
        }
        return ModuleMXBeanEntry.convertToJavaName(schemaNode.getQName().getLocalName(), capitalizeFirstLetter);
    }

    public static String convertToJavaName(String localName, boolean capitalizeFirstLetter) {
        if (capitalizeFirstLetter) {
            return BindingGeneratorUtil.parseToClassName((String)localName);
        }
        return BindingGeneratorUtil.parseToValidParamName((String)localName);
    }

    private static int getChildNodeSizeWithoutUses(DataNodeContainer csn) {
        int result = 0;
        for (DataSchemaNode dsn : csn.getChildNodes()) {
            if (dsn.isAddedByUses()) continue;
            ++result;
        }
        return result;
    }

    private static AttributeIfc getAttributeValue(DataSchemaNode attrNode, Module currentModule, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, TypeProviderWrapper typeProviderWrapper, SchemaContext schemaContext, String packageName) {
        if (attrNode instanceof LeafSchemaNode) {
            LeafSchemaNode leaf = (LeafSchemaNode)attrNode;
            return new JavaAttribute(leaf, typeProviderWrapper);
        }
        if (attrNode instanceof ContainerSchemaNode) {
            ContainerSchemaNode containerSchemaNode = (ContainerSchemaNode)attrNode;
            Optional<? extends AbstractDependencyAttribute> dependencyAttributeOptional = ModuleMXBeanEntry.extractDependency((DataNodeContainer)containerSchemaNode, attrNode, currentModule, qNamesToSIEs, schemaContext);
            if (dependencyAttributeOptional.isPresent()) {
                return (AttributeIfc)dependencyAttributeOptional.get();
            }
            return TOAttribute.create(containerSchemaNode, typeProviderWrapper, packageName);
        }
        if (attrNode instanceof LeafListSchemaNode) {
            return ListAttribute.create((LeafListSchemaNode)attrNode, typeProviderWrapper);
        }
        if (attrNode instanceof ListSchemaNode) {
            ListSchemaNode listSchemaNode = (ListSchemaNode)attrNode;
            Optional<? extends AbstractDependencyAttribute> dependencyAttributeOptional = ModuleMXBeanEntry.extractDependency((DataNodeContainer)listSchemaNode, attrNode, currentModule, qNamesToSIEs, schemaContext);
            if (dependencyAttributeOptional.isPresent()) {
                return (AttributeIfc)dependencyAttributeOptional.get();
            }
            return ListAttribute.create(listSchemaNode, typeProviderWrapper, packageName);
        }
        throw new UnsupportedOperationException("Unknown configuration node " + attrNode.toString());
    }

    private static Optional<? extends AbstractDependencyAttribute> extractDependency(DataNodeContainer dataNodeContainer, DataSchemaNode attrNode, Module currentModule, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, SchemaContext schemaContext) {
        if (dataNodeContainer.getUses().size() == 1 && ModuleMXBeanEntry.getChildNodeSizeWithoutUses(dataNodeContainer) == 0) {
            UsesNode usesNode = (UsesNode)dataNodeContainer.getUses().iterator().next();
            Preconditions.checkState((usesNode.getRefines().size() == 1 ? 1 : 0) != 0, (Object)("Unexpected 'refine' child node size of " + dataNodeContainer));
            LeafSchemaNode refine = (LeafSchemaNode)usesNode.getRefines().values().iterator().next();
            Preconditions.checkState((refine.getUnknownSchemaNodes().size() == 1 ? 1 : 0) != 0, (Object)("Unexpected unknown schema node size of " + refine));
            UnknownSchemaNode requiredIdentity = (UnknownSchemaNode)refine.getUnknownSchemaNodes().iterator().next();
            Preconditions.checkState((boolean)ConfigConstants.REQUIRED_IDENTITY_EXTENSION_QNAME.equals((Object)requiredIdentity.getNodeType()), (Object)("Unexpected language extension " + requiredIdentity));
            String prefixAndIdentityLocalName = requiredIdentity.getNodeParameter();
            ServiceInterfaceEntry serviceInterfaceEntry = ModuleMXBeanEntry.findSIE(prefixAndIdentityLocalName, currentModule, qNamesToSIEs, schemaContext);
            boolean mandatory = refine.getConstraints().isMandatory();
            AbstractDependencyAttribute reference = dataNodeContainer instanceof ContainerSchemaNode ? new DependencyAttribute(attrNode, serviceInterfaceEntry, mandatory, attrNode.getDescription()) : new ListDependenciesAttribute(attrNode, serviceInterfaceEntry, mandatory, attrNode.getDescription());
            return Optional.of((Object)reference);
        }
        return Optional.absent();
    }

    private static ServiceInterfaceEntry findSIE(String prefixAndIdentityLocalName, Module currentModule, Map<QName, ServiceInterfaceEntry> qNamesToSIEs, SchemaContext schemaContext) {
        String localSIName;
        Module foundModule;
        Matcher m = PREFIX_COLON_LOCAL_NAME.matcher(prefixAndIdentityLocalName);
        if (m.matches()) {
            String prefix = m.group(1);
            ModuleImport moduleImport = ModuleMXBeanEntry.findModuleImport(currentModule, prefix);
            foundModule = schemaContext.findModuleByName(moduleImport.getModuleName(), moduleImport.getRevision());
            Preconditions.checkState((foundModule != null ? 1 : 0) != 0, (Object)String.format("Module not found in SchemaContext by %s", moduleImport));
            localSIName = m.group(2);
        } else {
            foundModule = currentModule;
            localSIName = prefixAndIdentityLocalName;
        }
        QName siQName = new QName(foundModule.getNamespace(), foundModule.getRevision(), localSIName);
        ServiceInterfaceEntry sie = qNamesToSIEs.get(siQName);
        Preconditions.checkState((sie != null ? 1 : 0) != 0, (Object)("Cannot find referenced Service Interface by " + prefixAndIdentityLocalName));
        return sie;
    }

    private static ModuleImport findModuleImport(Module module, String prefix) {
        for (ModuleImport moduleImport : module.getImports()) {
            if (!moduleImport.getPrefix().equals(prefix)) continue;
            return moduleImport;
        }
        throw new IllegalStateException(String.format("Import not found with prefix %s in %s", prefix, module));
    }

    public Map<String, AttributeIfc> getAttributes() {
        return this.yangToAttributes;
    }

    private void setYangToAttributes(Map<String, AttributeIfc> newAttributes) {
        this.yangToAttributes = newAttributes;
    }

    public String getNullableDescription() {
        return this.nullableDescription;
    }

    public QName getYangModuleQName() {
        return this.yangModuleQName;
    }

    public String toString() {
        return "ModuleMXBeanEntry{globallyUniqueName='" + this.globallyUniqueName + '\'' + ", packageName='" + this.packageName + '\'' + '}';
    }
}

