/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.config.yangjmxgenerator;

import java.net.URI;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.opendaylight.yangtools.yang.common.QName;

public class ConfigConstants {
    public static final String CONFIG_NAMESPACE = "urn:opendaylight:params:xml:ns:yang:controller:config";
    public static final String CONFIG_MODULE = "config";
    public static final String CONFIG_THREADS_MODULE = "config-threads";
    public static final String IETF_INET_TYPES = "ietf-inet-types";
    public static final QName SERVICE_TYPE_Q_NAME = ConfigConstants.createConfigQName("service-type");
    public static final QName MODULE_TYPE_Q_NAME = ConfigConstants.createConfigQName("module-type");
    public static final QName JAVA_CLASS_EXTENSION_QNAME = ConfigConstants.createConfigQName("java-class");
    public static final QName REQUIRED_IDENTITY_EXTENSION_QNAME = ConfigConstants.createConfigQName("required-identity");
    public static final QName INNER_STATE_BEAN_EXTENSION_QNAME = ConfigConstants.createConfigQName("inner-state-bean");
    public static final QName PROVIDED_SERVICE_EXTENSION_QNAME = ConfigConstants.createConfigQName("provided-service");
    public static final QName JAVA_NAME_PREFIX_EXTENSION_QNAME = ConfigConstants.createConfigQName("java-name-prefix");
    public static final QName RPC_CONTEXT_REF_GROUPING_QNAME = ConfigConstants.createRpcXQName("rpc-context-ref");
    public static final QName RPC_CONTEXT_REF_GROUPING_LEAF = ConfigConstants.createRpcXQName("context-instance");
    public static final QName RPC_CONTEXT_INSTANCE_EXTENSION_QNAME = ConfigConstants.createRpcXQName("rpc-context-instance");

    public static QName createConfigQName(String localName) {
        return ConfigConstants.createQName(CONFIG_NAMESPACE, "2013-04-05", localName);
    }

    public static QName createRpcXQName(String localName) {
        return ConfigConstants.createQName("urn:ietf:params:xml:ns:yang:rpc-context", "2013-06-17", localName);
    }

    private static QName createQName(String uri, String revisionDate, String localName) {
        Date revision;
        SimpleDateFormat revisionFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            revision = revisionFormat.parse(revisionDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
        return new QName(URI.create(uri), revision, localName);
    }
}

