/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager.internal;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.List;
import org.apache.felix.service.command.Descriptor;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.utils.ServiceHelper;
import org.osgi.framework.ServiceRegistration;

public class ForwardingRulesManagerCLI {
    private ServiceRegistration sr = null;

    public void init() {
    }

    public void destroy() {
    }

    public void start() {
        Hashtable<String, Object> props = new Hashtable<String, Object>();
        ((Dictionary)props).put("osgi.command.scope", "odpcontroller");
        ((Dictionary)props).put("osgi.command.function", new String[]{"showRequestedGroupFlows", "showInstalledGroupFlows", "showRequestedNodeFlows", "showInstalledNodeFlows"});
        this.sr = ServiceHelper.registerGlobalServiceWReg(ForwardingRulesManagerCLI.class, (Object)this, props);
    }

    public void stop() {
        if (this.sr != null) {
            this.sr.unregister();
            this.sr = null;
        }
    }

    @Descriptor(value="Displays all the flow entries in a given group")
    public void showRequestedGroupFlows(@Descriptor(value="Container in which to query FRM") String container, @Descriptor(value="Group name") String group, @Descriptor(value="True for verbose else false") Boolean verbose) {
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)container, (Object)this);
        if (frm == null) {
            System.out.println("Cannot find the FRM instance on container: " + container);
            return;
        }
        List groupFlows = frm.getFlowEntriesForGroup(group);
        System.out.println("Group " + group);
        for (FlowEntry flowEntry : groupFlows) {
            if (!verbose.booleanValue()) {
                System.out.println(flowEntry.getNode() + " " + flowEntry.getFlowName());
                continue;
            }
            System.out.println(flowEntry.getNode() + " " + flowEntry.toString());
        }
    }

    @Descriptor(value="Displays all the installed flow entries in a given group")
    public void showInstalledGroupFlows(@Descriptor(value="Container in which to query FRM") String container, @Descriptor(value="Group name") String group, @Descriptor(value="True for verbose else false") Boolean verbose) {
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)container, (Object)this);
        if (frm == null) {
            System.out.println("Cannot find the FRM instance on container: " + container);
            return;
        }
        List groupFlows = frm.getInstalledFlowEntriesForGroup(group);
        System.out.println("Group " + group);
        for (FlowEntry flowEntry : groupFlows) {
            if (!verbose.booleanValue()) {
                System.out.println(flowEntry.getNode() + " " + flowEntry.getFlowName());
                continue;
            }
            System.out.println(flowEntry.getNode() + " " + flowEntry.toString());
        }
    }

    @Descriptor(value="Displays all the flow entries for a network node")
    public void showRequestedNodeFlows(@Descriptor(value="Container in which to query FRM") String container, @Descriptor(value="String representation of the Node, this need to be consumable from Node.fromString()") String nodeId, @Descriptor(value="True for verbose else false") Boolean verbose) {
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)container, (Object)this);
        if (frm == null) {
            System.out.println("Cannot find the FRM instance on container: " + container);
            return;
        }
        Node node = Node.fromString((String)nodeId);
        if (node == null) {
            System.out.println("Please enter a valid node id");
            return;
        }
        List groupFlows = frm.getFlowEntriesForNode(node);
        System.out.println("Node " + nodeId);
        for (FlowEntry flowEntry : groupFlows) {
            if (!verbose.booleanValue()) {
                System.out.println(flowEntry.getNode() + " " + flowEntry.getFlowName());
                continue;
            }
            System.out.println(flowEntry.getNode() + " " + flowEntry.toString());
        }
    }

    @Descriptor(value="Displays all the flow entries installed in a network node")
    public void showInstalledNodeFlows(@Descriptor(value="Container in which to query FRM") String container, @Descriptor(value="String representation of the Node, this need to be consumable from Node.fromString()") String nodeId, @Descriptor(value="True for verbose else false") Boolean verbose) {
        IForwardingRulesManager frm = (IForwardingRulesManager)ServiceHelper.getInstance(IForwardingRulesManager.class, (String)container, (Object)this);
        if (frm == null) {
            System.out.println("Cannot find the FRM instance on container: " + container);
            return;
        }
        Node node = Node.fromString((String)nodeId);
        if (node == null) {
            System.out.println("Please enter a valid node id");
            return;
        }
        List groupFlows = frm.getInstalledFlowEntriesForNode(node);
        System.out.println("Node " + nodeId);
        for (FlowEntry flowEntry : groupFlows) {
            if (!verbose.booleanValue()) {
                System.out.println(flowEntry.getNode() + " " + flowEntry.getFlowName());
                continue;
            }
            System.out.println(flowEntry.getNode() + " " + flowEntry.toString());
        }
    }
}

