/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager.internal;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import org.opendaylight.controller.clustering.services.CacheConfigException;
import org.opendaylight.controller.clustering.services.CacheExistException;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.clustering.services.IClusterServices;
import org.opendaylight.controller.configuration.ConfigurationObject;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.forwardingrulesmanager.FlowConfig;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntry;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntryInstall;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManagerAware;
import org.opendaylight.controller.forwardingrulesmanager.PortGroup;
import org.opendaylight.controller.forwardingrulesmanager.PortGroupChangeListener;
import org.opendaylight.controller.forwardingrulesmanager.PortGroupConfig;
import org.opendaylight.controller.forwardingrulesmanager.PortGroupProvider;
import org.opendaylight.controller.forwardingrulesmanager.implementation.data.FlowEntryDistributionOrder;
import org.opendaylight.controller.forwardingrulesmanager.internal.FlowEntryDistributionOrderFutureTask;
import org.opendaylight.controller.sal.action.Action;
import org.opendaylight.controller.sal.action.ActionType;
import org.opendaylight.controller.sal.action.Output;
import org.opendaylight.controller.sal.connection.ConnectionLocality;
import org.opendaylight.controller.sal.core.Config;
import org.opendaylight.controller.sal.core.ContainerFlow;
import org.opendaylight.controller.sal.core.IContainer;
import org.opendaylight.controller.sal.core.IContainerLocalListener;
import org.opendaylight.controller.sal.core.Node;
import org.opendaylight.controller.sal.core.NodeConnector;
import org.opendaylight.controller.sal.core.Property;
import org.opendaylight.controller.sal.core.UpdateType;
import org.opendaylight.controller.sal.flowprogrammer.Flow;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerListener;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerService;
import org.opendaylight.controller.sal.match.Match;
import org.opendaylight.controller.sal.match.MatchType;
import org.opendaylight.controller.sal.utils.EtherTypes;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.sal.utils.IObjectReader;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.opendaylight.controller.switchmanager.Subnet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardingRulesManager
implements IForwardingRulesManager,
PortGroupChangeListener,
IContainerLocalListener,
ISwitchManagerAware,
IConfigurationContainerAware,
IInventoryListener,
IObjectReader,
ICacheUpdateAware<Object, Object>,
IFlowProgrammerListener {
    private static final Logger log = LoggerFactory.getLogger(ForwardingRulesManager.class);
    private static final Logger logsync = LoggerFactory.getLogger((String)"FRMsync");
    private static final String PORT_REMOVED = "Port removed";
    private static final String NODE_DOWN = "Node is Down";
    private static final String INVALID_FLOW_ENTRY = "Invalid FlowEntry";
    private static final String STATIC_FLOWS_FILE_NAME = "frm_staticflows.conf";
    private static final String PORT_GROUP_FILE_NAME = "portgroup.conf";
    private ConcurrentMap<Integer, FlowConfig> staticFlows;
    private ConcurrentMap<Integer, Integer> staticFlowsOrdinal;
    private ConcurrentMap<String, PortGroupConfig> portGroupConfigs;
    private ConcurrentMap<PortGroupConfig, Map<Node, PortGroup>> portGroupData;
    private ConcurrentMap<String, Object> TSPolicies;
    private IContainerManager containerManager;
    private IConfigurationContainerService configurationService;
    private boolean inContainerMode;
    protected boolean stopping;
    private ConcurrentMap<FlowEntry, FlowEntry> originalSwView;
    private ConcurrentMap<FlowEntryInstall, FlowEntryInstall> installedSwView;
    private ConcurrentMap<Node, List<FlowEntryInstall>> nodeFlows;
    private ConcurrentMap<String, List<FlowEntryInstall>> groupFlows;
    private ConcurrentMap<FlowEntry, FlowEntry> inactiveFlows;
    private IContainer container;
    private Set<IForwardingRulesManagerAware> frmAware = Collections.synchronizedSet(new HashSet());
    private PortGroupProvider portGroupProvider;
    private IFlowProgrammerService programmer;
    private IClusterContainerServices clusterContainerService = null;
    private ISwitchManager switchManager;
    private Thread frmEventHandler;
    protected BlockingQueue<FRMEvent> pendingEvents;
    private IConnectionManager connectionManager;
    static final String WORK_ORDER_CACHE = "frm.workOrder";
    static final String WORK_STATUS_CACHE = "frm.workStatus";
    static final String ORIGINAL_SW_VIEW_CACHE = "frm.originalSwView";
    static final String INSTALLED_SW_VIEW_CACHE = "frm.installedSwView";
    protected ConcurrentMap<FlowEntryDistributionOrder, FlowEntryInstall> workOrder;
    protected ConcurrentMap<FlowEntryDistributionOrder, Status> workStatus;
    private ConcurrentMap<FlowEntryDistributionOrder, FlowEntryDistributionOrderFutureTask> workMonitor = new ConcurrentHashMap<FlowEntryDistributionOrder, FlowEntryDistributionOrderFutureTask>();
    private static final int maxPoolSize = 10;
    private ExecutorService executor;

    private FlowEntryDistributionOrderFutureTask distributeWorkOrder(FlowEntryInstall e, FlowEntryInstall u, UpdateType t) {
        if (e == null) {
            return null;
        }
        Node n = e.getNode();
        if (this.connectionManager.getLocalityStatus(n) == ConnectionLocality.NOT_LOCAL) {
            FlowEntryDistributionOrder fe = new FlowEntryDistributionOrder(e, t, this.clusterContainerService.getMyAddress());
            FlowEntryDistributionOrderFutureTask ret = new FlowEntryDistributionOrderFutureTask(fe);
            logsync.trace("Node {} not local so sending fe {}", (Object)n, (Object)fe);
            this.workMonitor.put(fe, ret);
            if (t.equals((Object)UpdateType.CHANGED)) {
                this.workOrder.put(fe, u);
            } else {
                this.workOrder.put(fe, e);
            }
            logsync.trace("WorkOrder requested");
            return ret;
        }
        logsync.trace("Node {} could be local. so processing Entry:{} UpdateType:{}", new Object[]{n, e, t});
        return null;
    }

    private Status addEntry(FlowEntry flowEntry, boolean async) {
        List<FlowEntryInstall> toInstallList;
        if (flowEntry == null || flowEntry.getNode() == null || flowEntry.getFlow() == null) {
            String logMsg = "Invalid FlowEntry: {}";
            log.warn(logMsg, (Object)flowEntry);
            return new Status(StatusCode.NOTACCEPTABLE, INVALID_FLOW_ENTRY);
        }
        FlowEntry present = (FlowEntry)this.originalSwView.get(flowEntry);
        if (present != null) {
            boolean sameApp;
            boolean sameFlow = present.getFlow().equals((Object)flowEntry.getFlow());
            boolean bl = sameApp = present.getFlowName() != null && present.getFlowName().equals(flowEntry.getFlowName());
            if (sameFlow && sameApp) {
                log.trace("Skipping redundant request for flow {} on node {}", (Object)flowEntry.getFlowName(), (Object)flowEntry.getNode());
                return new Status(StatusCode.SUCCESS, "Entry is already present");
            }
        }
        if ((toInstallList = this.deriveInstallEntries(flowEntry.clone(), this.container.getContainerFlows())).isEmpty()) {
            String msg = "Flow Entry conflicts with all Container Flows";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)flowEntry);
            return new Status(StatusCode.CONFLICT, msg);
        }
        ArrayList<FlowEntryInstall> toInstallSafe = new ArrayList<FlowEntryInstall>();
        for (FlowEntryInstall entry : toInstallList) {
            if (this.installedSwView.containsKey(entry)) {
                log.warn("Operation Rejected: A flow with same match and priority exists on the target node");
                log.trace("Aborting to install {}", (Object)entry);
                continue;
            }
            toInstallSafe.add(entry);
        }
        if (toInstallSafe.size() == 0) {
            String msg = "A flow with same match and priority exists on the target node";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)flowEntry);
            return new Status(StatusCode.CONFLICT, msg);
        }
        Status error = new Status(null, null);
        Status succeded = null;
        boolean oneSucceded = false;
        for (FlowEntryInstall installEntry : toInstallSafe) {
            Status ret = this.addEntriesInternal(installEntry, async);
            if (ret.isSuccess()) {
                oneSucceded = true;
                succeded = ret;
                continue;
            }
            error = ret;
            log.trace("Failed to install the entry: {}. The failure is: {}", (Object)installEntry, (Object)ret.getDescription());
        }
        return oneSucceded ? succeded : error;
    }

    private List<FlowEntryInstall> deriveInstallEntries(FlowEntry request, List<ContainerFlow> cFlowList) {
        ArrayList<FlowEntryInstall> toInstallList = new ArrayList<FlowEntryInstall>(1);
        if (this.container.getContainerFlows() == null || this.container.getContainerFlows().isEmpty()) {
            toInstallList.add(new FlowEntryInstall(request.clone(), null));
        } else {
            for (ContainerFlow cFlow : this.container.getContainerFlows()) {
                if (!cFlow.allowsFlow(request.getFlow())) continue;
                toInstallList.add(new FlowEntryInstall(request.clone(), cFlow));
            }
        }
        return toInstallList;
    }

    private Status modifyEntry(FlowEntry currentFlowEntry, FlowEntry newFlowEntry, boolean async) {
        if (currentFlowEntry == null || currentFlowEntry.getNode() == null || newFlowEntry == null || newFlowEntry.getNode() == null || newFlowEntry.getFlow() == null) {
            String msg = "Modify: Invalid FlowEntry";
            String logMsg = msg + ": {} or {}";
            log.warn(logMsg, (Object)currentFlowEntry, (Object)newFlowEntry);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        if (!currentFlowEntry.getNode().equals((Object)newFlowEntry.getNode()) || !currentFlowEntry.getFlowName().equals(newFlowEntry.getFlowName())) {
            String msg = "Modify: Incompatible Flow Entries";
            String logMsg = msg + ": {} and {}";
            log.warn(logMsg, (Object)currentFlowEntry, (Object)newFlowEntry);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        if (currentFlowEntry.getFlow().equals((Object)newFlowEntry.getFlow())) {
            String msg = "Modify skipped as flows are the same";
            String logMsg = msg + ": {} and {}";
            log.debug(logMsg, (Object)currentFlowEntry, (Object)newFlowEntry);
            return new Status(StatusCode.SUCCESS, msg);
        }
        FlowEntry sameMatchOriginalEntry = (FlowEntry)this.originalSwView.get(newFlowEntry);
        if (sameMatchOriginalEntry != null && !sameMatchOriginalEntry.equals((Object)currentFlowEntry)) {
            String msg = "Operation Rejected: Another flow with same match and priority exists on the target node";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)currentFlowEntry);
            return new Status(StatusCode.CONFLICT, msg);
        }
        List<FlowEntryInstall> installedList = this.deriveInstallEntries(currentFlowEntry.clone(), this.container.getContainerFlows());
        List<FlowEntryInstall> toInstallList = this.deriveInstallEntries(newFlowEntry.clone(), this.container.getContainerFlows());
        if (toInstallList.isEmpty()) {
            String msg = "Modify Operation Rejected: The new entry conflicts with all the container flows";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)newFlowEntry);
            log.warn(msg);
            return new Status(StatusCode.CONFLICT, msg);
        }
        Status succeeded = null;
        boolean decouple = false;
        if (installedList.size() != toInstallList.size()) {
            log.trace("Modify: New flow entry does not satisfy the same number of container flows as the original entry does");
            decouple = true;
        }
        ArrayList<FlowEntryInstall> toInstallSafe = new ArrayList<FlowEntryInstall>();
        for (FlowEntryInstall installEntry : toInstallList) {
            FlowEntryInstall sameMatchEntry = (FlowEntryInstall)this.installedSwView.get(installEntry);
            if (sameMatchEntry != null && !sameMatchEntry.getOriginal().equals((Object)currentFlowEntry)) {
                log.trace("Modify: new container flow merged flow entry clashes with existing flow");
                decouple = true;
                continue;
            }
            toInstallSafe.add(installEntry);
        }
        if (decouple) {
            for (FlowEntryInstall currEntry : installedList) {
                this.removeEntryInternal(currEntry, async);
            }
            for (FlowEntryInstall newEntry : toInstallSafe) {
                succeeded = this.addEntriesInternal(newEntry, async);
            }
        } else {
            int i;
            Status retModify = null;
            int size = toInstallList.size();
            for (i = 0; i < size && (retModify = this.modifyEntryInternal(installedList.get(i), toInstallList.get(i), async)).isSuccess(); ++i) {
            }
            if (i < size) {
                int j;
                log.warn("Unable to perform a complete modify for all  the container flows merged entries");
                for (j = 0; j < i; ++j) {
                    log.info("Attempting to restore initial entries");
                    Status retExt = this.modifyEntryInternal(toInstallList.get(i), installedList.get(i), async);
                    if (!retExt.isSuccess()) break;
                }
                if (j < i) {
                    String msg = "Flow recovery failed ! Unrecoverable Error";
                    log.error(msg);
                    return new Status(StatusCode.INTERNALERROR, msg);
                }
            }
            succeeded = retModify;
        }
        return succeeded;
    }

    private Status modifyEntryInternal(FlowEntryInstall currentEntries, FlowEntryInstall newEntries, boolean async) {
        Status status;
        FlowEntryDistributionOrderFutureTask futureStatus = this.distributeWorkOrder(currentEntries, newEntries, UpdateType.CHANGED);
        if (futureStatus != null) {
            Status retStatus = new Status(StatusCode.UNDEFINED);
            try {
                retStatus = futureStatus.get();
                if (retStatus.getCode().equals((Object)StatusCode.TIMEOUT)) {
                    this.workMonitor.remove(futureStatus.getOrder());
                }
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("", (Throwable)e);
            }
            return retStatus;
        }
        Status status2 = status = async ? this.programmer.modifyFlowAsync(currentEntries.getNode(), currentEntries.getInstall().getFlow(), newEntries.getInstall().getFlow()) : this.programmer.modifyFlow(currentEntries.getNode(), currentEntries.getInstall().getFlow(), newEntries.getInstall().getFlow());
        if (!status.isSuccess()) {
            log.trace("SDN Plugin failed to program the flow: {}. The failure is: {}", (Object)newEntries.getInstall(), (Object)status.getDescription());
            return status;
        }
        log.trace("Modified {} => {}", (Object)currentEntries.getInstall(), (Object)newEntries.getInstall());
        newEntries.setRequestId(status.getRequestId());
        this.updateSwViews(currentEntries, false);
        this.updateSwViews(newEntries, true);
        return status;
    }

    private Status removeEntry(FlowEntry flowEntry, boolean async) {
        Status error = new Status(null, null);
        if (flowEntry == null || flowEntry.getNode() == null || flowEntry.getFlow() == null) {
            String logMsg = "Invalid FlowEntry: {}";
            log.warn(logMsg, (Object)flowEntry);
            return new Status(StatusCode.NOTACCEPTABLE, INVALID_FLOW_ENTRY);
        }
        List<FlowEntryInstall> installedList = this.deriveInstallEntries(flowEntry.clone(), this.container.getContainerFlows());
        Status succeeded = null;
        boolean atLeastOneRemoved = false;
        for (FlowEntryInstall entry : installedList) {
            if (!this.installedSwView.containsKey(entry)) {
                String logMsg = "Removal skipped (not present in software view) for flow entry: {}";
                log.debug(logMsg, (Object)flowEntry);
                if (installedList.size() != 1) continue;
                return new Status(StatusCode.SUCCESS);
            }
            Status ret = this.removeEntryInternal(entry, async);
            if (!ret.isSuccess()) {
                error = ret;
                log.trace("Failed to remove the entry: {}. The failure is: {}", (Object)entry.getInstall(), (Object)ret.getDescription());
                if (installedList.size() != 1) continue;
                return error;
            }
            succeeded = ret;
            atLeastOneRemoved = true;
        }
        return atLeastOneRemoved ? succeeded : error;
    }

    private Status removeEntryInternal(FlowEntryInstall entry, boolean async) {
        Status status;
        FlowEntryDistributionOrderFutureTask futureStatus = this.distributeWorkOrder(entry, null, UpdateType.REMOVED);
        if (futureStatus != null) {
            Status retStatus = new Status(StatusCode.UNDEFINED);
            try {
                retStatus = futureStatus.get();
                if (retStatus.getCode().equals((Object)StatusCode.TIMEOUT)) {
                    this.workMonitor.remove(futureStatus.getOrder());
                }
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("", (Throwable)e);
            }
            return retStatus;
        }
        entry.toBeDeleted();
        Status status2 = status = async ? this.programmer.removeFlowAsync(entry.getNode(), entry.getInstall().getFlow()) : this.programmer.removeFlow(entry.getNode(), entry.getInstall().getFlow());
        if (!status.isSuccess()) {
            log.trace("SDN Plugin failed to remove the flow: {}. The failure is: {}", (Object)entry.getInstall(), (Object)status.getDescription());
            return status;
        }
        log.trace("Removed  {}", (Object)entry.getInstall());
        this.updateSwViews(entry, false);
        return status;
    }

    private Status addEntriesInternal(FlowEntryInstall entry, boolean async) {
        Status status;
        FlowEntryDistributionOrderFutureTask futureStatus = this.distributeWorkOrder(entry, null, UpdateType.ADDED);
        if (futureStatus != null) {
            Status retStatus = new Status(StatusCode.UNDEFINED);
            try {
                retStatus = futureStatus.get();
                if (retStatus.getCode().equals((Object)StatusCode.TIMEOUT)) {
                    this.workMonitor.remove(futureStatus.getOrder());
                }
            }
            catch (InterruptedException e) {
                log.error("", (Throwable)e);
            }
            catch (ExecutionException e) {
                log.error("", (Throwable)e);
            }
            return retStatus;
        }
        Status status2 = status = async ? this.programmer.addFlowAsync(entry.getNode(), entry.getInstall().getFlow()) : this.programmer.addFlow(entry.getNode(), entry.getInstall().getFlow());
        if (!status.isSuccess()) {
            log.trace("SDN Plugin failed to program the flow: {}. The failure is: {}", (Object)entry.getInstall(), (Object)status.getDescription());
            return status;
        }
        log.trace("Added    {}", (Object)entry.getInstall());
        entry.setRequestId(status.getRequestId());
        this.updateSwViews(entry, true);
        return status;
    }

    private boolean entryConflictsWithContainerFlows(FlowEntry flowEntry) {
        List cFlowList = this.container.getContainerFlows();
        if (cFlowList == null || cFlowList.isEmpty()) {
            return false;
        }
        for (ContainerFlow cFlow : cFlowList) {
            if (!cFlow.allowsFlow(flowEntry.getFlow())) continue;
            return false;
        }
        return true;
    }

    private Map.Entry<Integer, FlowConfig> getStaticFlowEntry(String name, Node node) {
        for (Map.Entry<Integer, FlowConfig> entry : this.staticFlows.entrySet()) {
            FlowConfig flowConfig = (FlowConfig)entry.getValue();
            if (!flowConfig.isByNameAndNodeIdEqual(name, node)) continue;
            return entry;
        }
        return null;
    }

    private void updateIndexDatabase(FlowEntryInstall entry, boolean add) {
        this.updateNodeFlowsDB(entry, add);
        this.updateGroupFlowsDB(entry, add);
    }

    private void updateSwViews(FlowEntryInstall flowEntries, boolean add) {
        if (add) {
            this.originalSwView.put(flowEntries.getOriginal(), flowEntries.getOriginal());
            this.installedSwView.put(flowEntries, flowEntries);
        } else {
            this.originalSwView.remove(flowEntries.getOriginal());
            this.installedSwView.remove(flowEntries);
        }
    }

    private void updateNodeFlowsDB(FlowEntryInstall flowEntries, boolean add) {
        Node node = flowEntries.getNode();
        ArrayList<FlowEntryInstall> nodeIndeces = (ArrayList<FlowEntryInstall>)this.nodeFlows.get(node);
        if (nodeIndeces == null) {
            if (!add) {
                return;
            }
            nodeIndeces = new ArrayList<FlowEntryInstall>();
        }
        if (add) {
            if (nodeIndeces.contains(flowEntries)) {
                nodeIndeces.remove(flowEntries);
            }
            nodeIndeces.add(flowEntries);
        } else {
            nodeIndeces.remove(flowEntries);
        }
        if (nodeIndeces.isEmpty()) {
            this.nodeFlows.remove(node);
        } else {
            this.nodeFlows.put(node, nodeIndeces);
        }
    }

    private void updateGroupFlowsDB(FlowEntryInstall flowEntries, boolean add) {
        String groupName = flowEntries.getGroupName();
        if (groupName == null) {
            return;
        }
        ArrayList<FlowEntryInstall> indices = (ArrayList<FlowEntryInstall>)this.groupFlows.get(groupName);
        if (indices == null) {
            if (!add) {
                return;
            }
            indices = new ArrayList<FlowEntryInstall>();
        }
        if (add) {
            if (indices.contains(flowEntries)) {
                indices.remove(flowEntries);
            }
            indices.add(flowEntries);
        } else {
            indices.remove(flowEntries);
        }
        if (indices.isEmpty()) {
            this.groupFlows.remove(groupName);
        } else {
            this.groupFlows.put(groupName, indices);
        }
    }

    private Status removeEntry(Node node, String flowName) {
        FlowEntryInstall target = null;
        for (FlowEntryInstall entry : this.installedSwView.values()) {
            if (!entry.equalsByNodeAndName(node, flowName)) continue;
            target = entry;
            break;
        }
        if (target == null) {
            return new Status(StatusCode.SUCCESS, "Entry is not present");
        }
        Status status = this.programmer.removeFlow(target.getNode(), target.getInstall().getFlow());
        if (status.isSuccess()) {
            this.updateSwViews(target, false);
        } else {
            log.trace("SDN Plugin failed to remove the flow: {}. The failure is: {}", (Object)target.getInstall(), (Object)status.getDescription());
        }
        return status;
    }

    public Status installFlowEntry(FlowEntry flowEntry) {
        Status status;
        if (this.isContainerModeAllowed(flowEntry)) {
            status = this.addEntry(flowEntry, false);
        } else {
            String msg = "Controller in container mode: Install Refused";
            String logMsg = msg + ": {}";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(logMsg, (Object)flowEntry);
        }
        return status;
    }

    public Status installFlowEntryAsync(FlowEntry flowEntry) {
        Status status;
        if (this.isContainerModeAllowed(flowEntry)) {
            status = this.addEntry(flowEntry, true);
        } else {
            String msg = "Controller in container mode: Install Refused";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(msg);
        }
        return status;
    }

    public Status uninstallFlowEntry(FlowEntry flowEntry) {
        Status status;
        if (this.isContainerModeAllowed(flowEntry)) {
            status = this.removeEntry(flowEntry, false);
        } else {
            String msg = "Controller in container mode: Uninstall Refused";
            String logMsg = msg + ": {}";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(logMsg, (Object)flowEntry);
        }
        return status;
    }

    public Status uninstallFlowEntryAsync(FlowEntry flowEntry) {
        Status status;
        if (this.isContainerModeAllowed(flowEntry)) {
            status = this.removeEntry(flowEntry, true);
        } else {
            String msg = "Controller in container mode: Uninstall Refused";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(msg);
        }
        return status;
    }

    public Status modifyFlowEntry(FlowEntry currentFlowEntry, FlowEntry newFlowEntry) {
        Status status = null;
        if (this.isContainerModeAllowed(currentFlowEntry)) {
            status = this.modifyEntry(currentFlowEntry, newFlowEntry, false);
        } else {
            String msg = "Controller in container mode: Modify Refused";
            String logMsg = msg + ": {}";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(logMsg, (Object)newFlowEntry);
        }
        return status;
    }

    public Status modifyFlowEntryAsync(FlowEntry currentFlowEntry, FlowEntry newFlowEntry) {
        Status status = null;
        if (this.isContainerModeAllowed(currentFlowEntry)) {
            status = this.modifyEntry(currentFlowEntry, newFlowEntry, true);
        } else {
            String msg = "Controller in container mode: Modify Refused";
            status = new Status(StatusCode.NOTACCEPTABLE, msg);
            log.warn(msg);
        }
        return status;
    }

    private boolean isContainerModeAllowed(FlowEntry flowEntry) {
        return !this.inContainerMode ? true : flowEntry.isInternal();
    }

    public Status modifyOrAddFlowEntry(FlowEntry newFlowEntry) {
        FlowEntry currentFlowEntry = (FlowEntry)this.originalSwView.get(newFlowEntry);
        if (currentFlowEntry != null) {
            return this.modifyFlowEntry(currentFlowEntry, newFlowEntry);
        }
        return this.installFlowEntry(newFlowEntry);
    }

    public Status modifyOrAddFlowEntryAsync(FlowEntry newFlowEntry) {
        FlowEntry currentFlowEntry = (FlowEntry)this.originalSwView.get(newFlowEntry);
        if (currentFlowEntry != null) {
            return this.modifyFlowEntryAsync(currentFlowEntry, newFlowEntry);
        }
        return this.installFlowEntryAsync(newFlowEntry);
    }

    public Status uninstallFlowEntryGroup(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        if (groupName.equals("__InternalStaticFlows__")) {
            return new Status(StatusCode.BADREQUEST, "Internal static flows group cannot be deleted through this api");
        }
        if (this.inContainerMode) {
            String msg = "Controller in container mode: Group Uninstall Refused";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)groupName);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        int toBeRemoved = 0;
        String error = "";
        if (this.groupFlows.containsKey(groupName)) {
            ArrayList list = new ArrayList((Collection)this.groupFlows.get(groupName));
            toBeRemoved = list.size();
            for (FlowEntryInstall entry : list) {
                Status status = this.removeEntry(entry.getOriginal(), false);
                if (status.isSuccess()) {
                    --toBeRemoved;
                    continue;
                }
                error = status.getDescription();
            }
        }
        return toBeRemoved == 0 ? new Status(StatusCode.SUCCESS) : new Status(StatusCode.INTERNALERROR, "Not all the flows were removed: " + error);
    }

    public Status uninstallFlowEntryGroupAsync(String groupName) {
        if (groupName == null || groupName.isEmpty()) {
            return new Status(StatusCode.BADREQUEST, "Invalid group name");
        }
        if (groupName.equals("__InternalStaticFlows__")) {
            return new Status(StatusCode.BADREQUEST, "Static flows group cannot be deleted through this api");
        }
        if (this.inContainerMode) {
            String msg = "Controller in container mode: Group Uninstall Refused";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)groupName);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        if (this.groupFlows.containsKey(groupName)) {
            ArrayList list = new ArrayList((Collection)this.groupFlows.get(groupName));
            for (FlowEntryInstall entry : list) {
                this.removeEntry(entry.getOriginal(), true);
            }
        }
        return new Status(StatusCode.SUCCESS);
    }

    public boolean checkFlowEntryConflict(FlowEntry flowEntry) {
        return this.entryConflictsWithContainerFlows(flowEntry);
    }

    protected void updateFlowsContainerFlow() {
        HashSet<FlowEntry> toReInstall = new HashSet<FlowEntry>();
        for (Map.Entry entry : this.installedSwView.entrySet()) {
            FlowEntryInstall current = (FlowEntryInstall)entry.getValue();
            toReInstall.add(current.getOriginal());
            this.removeEntryInternal(current, false);
        }
        for (FlowEntry flowEntry : toReInstall) {
            this.installFlowEntry(flowEntry);
        }
    }

    private void nonClusterObjectCreate() {
        this.originalSwView = new ConcurrentHashMap<FlowEntry, FlowEntry>();
        this.installedSwView = new ConcurrentHashMap<FlowEntryInstall, FlowEntryInstall>();
        this.TSPolicies = new ConcurrentHashMap<String, Object>();
        this.staticFlowsOrdinal = new ConcurrentHashMap<Integer, Integer>();
        this.portGroupConfigs = new ConcurrentHashMap<String, PortGroupConfig>();
        this.portGroupData = new ConcurrentHashMap<PortGroupConfig, Map<Node, PortGroup>>();
        this.staticFlows = new ConcurrentHashMap<Integer, FlowConfig>();
        this.inactiveFlows = new ConcurrentHashMap<FlowEntry, FlowEntry>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTSPolicyData(String policyname, Object o, boolean add) {
        if (add) {
            if (!this.TSPolicies.containsKey(policyname)) {
                this.TSPolicies.put(policyname, o);
            }
        } else {
            this.TSPolicies.remove(policyname);
        }
        if (this.frmAware != null) {
            Set<IForwardingRulesManagerAware> set = this.frmAware;
            synchronized (set) {
                for (IForwardingRulesManagerAware frma : this.frmAware) {
                    try {
                        frma.policyUpdate(policyname, add);
                    }
                    catch (Exception e) {
                        log.warn("Exception on callback", (Throwable)e);
                    }
                }
            }
        }
    }

    public Map<String, Object> getTSPolicyData() {
        return this.TSPolicies;
    }

    public Object getTSPolicyData(String policyName) {
        if (this.TSPolicies.containsKey(policyName)) {
            return this.TSPolicies.get(policyName);
        }
        return null;
    }

    public List<FlowEntry> getFlowEntriesForGroup(String policyName) {
        ArrayList<FlowEntry> list = new ArrayList<FlowEntry>();
        if (policyName != null && !policyName.trim().isEmpty()) {
            for (Map.Entry entry : this.originalSwView.entrySet()) {
                if (!policyName.equals(((FlowEntry)entry.getKey()).getGroupName())) continue;
                list.add(((FlowEntry)entry.getValue()).clone());
            }
        }
        return list;
    }

    public List<FlowEntry> getInstalledFlowEntriesForGroup(String policyName) {
        ArrayList<FlowEntry> list = new ArrayList<FlowEntry>();
        if (policyName != null && !policyName.trim().isEmpty()) {
            for (Map.Entry entry : this.installedSwView.entrySet()) {
                if (!policyName.equals(((FlowEntryInstall)entry.getKey()).getGroupName())) continue;
                list.add(((FlowEntryInstall)entry.getValue()).getInstall().clone());
            }
        }
        return list;
    }

    public void addOutputPort(Node node, String flowName, List<NodeConnector> portList) {
        for (FlowEntryInstall flow : (List)this.nodeFlows.get(node)) {
            if (!flow.getFlowName().equals(flowName)) continue;
            FlowEntry currentFlowEntry = flow.getOriginal();
            FlowEntry newFlowEntry = currentFlowEntry.clone();
            for (NodeConnector dstPort : portList) {
                newFlowEntry.getFlow().addAction((Action)new Output(dstPort));
            }
            Status error = this.modifyEntry(currentFlowEntry, newFlowEntry, false);
            if (error.isSuccess()) {
                log.trace("Ports {} added to FlowEntry {}", portList, (Object)flowName);
            } else {
                log.warn("Failed to add ports {} to Flow entry {}. The failure is: {}", new Object[]{portList, currentFlowEntry.toString(), error.getDescription()});
            }
            return;
        }
        log.warn("Failed to add ports to Flow {} on Node {}: Entry Not Found", (Object)flowName, (Object)node);
    }

    public void removeOutputPort(Node node, String flowName, List<NodeConnector> portList) {
        for (FlowEntryInstall index : (List)this.nodeFlows.get(node)) {
            FlowEntryInstall flow = (FlowEntryInstall)this.installedSwView.get(index);
            if (!flow.getFlowName().equals(flowName)) continue;
            FlowEntry currentFlowEntry = flow.getOriginal();
            FlowEntry newFlowEntry = currentFlowEntry.clone();
            for (NodeConnector dstPort : portList) {
                Output action = new Output(dstPort);
                newFlowEntry.getFlow().removeAction((Action)action);
            }
            Status status = this.modifyEntry(currentFlowEntry, newFlowEntry, false);
            if (status.isSuccess()) {
                log.trace("Ports {} removed from FlowEntry {}", portList, (Object)flowName);
            } else {
                log.warn("Failed to remove ports {} from Flow entry {}. The failure is: {}", new Object[]{portList, currentFlowEntry.toString(), status.getDescription()});
            }
            return;
        }
        log.warn("Failed to remove ports from Flow {} on Node {}: Entry Not Found", (Object)flowName, (Object)node);
    }

    public void replaceOutputPort(Node node, String flowName, NodeConnector outPort) {
        FlowEntry currentFlowEntry = null;
        FlowEntry newFlowEntry = null;
        for (FlowEntryInstall index : (List)this.nodeFlows.get(node)) {
            FlowEntryInstall flow = (FlowEntryInstall)this.installedSwView.get(index);
            if (!flow.getFlowName().equals(flowName)) continue;
            currentFlowEntry = flow.getOriginal();
            break;
        }
        if (currentFlowEntry == null) {
            log.warn("Failed to replace output port for flow {} on node {}: Entry Not Found", (Object)flowName, (Object)node);
            return;
        }
        newFlowEntry = currentFlowEntry.clone();
        Action target = null;
        for (Action action : newFlowEntry.getFlow().getActions()) {
            if (action.getType() != ActionType.OUTPUT) continue;
            target = action;
            break;
        }
        newFlowEntry.getFlow().removeAction(target);
        newFlowEntry.getFlow().addAction((Action)new Output(outPort));
        Status status = this.modifyEntry(currentFlowEntry, newFlowEntry, false);
        if (status.isSuccess()) {
            log.trace("Output port replaced with {} for flow {} on node {}", new Object[]{outPort, flowName, node});
        } else {
            log.warn("Failed to replace output port for flow {} on node {}. The failure is: {}", new Object[]{flowName, node, status.getDescription()});
        }
    }

    public NodeConnector getOutputPort(Node node, String flowName) {
        for (FlowEntryInstall index : (List)this.nodeFlows.get(node)) {
            FlowEntryInstall flow = (FlowEntryInstall)this.installedSwView.get(index);
            if (!flow.getFlowName().equals(flowName)) continue;
            for (Action action : flow.getOriginal().getFlow().getActions()) {
                if (action.getType() != ActionType.OUTPUT) continue;
                return ((Output)action).getPort();
            }
        }
        return null;
    }

    private void cacheStartup() {
        this.allocateCaches();
        this.retrieveCaches();
    }

    private void allocateCaches() {
        if (this.clusterContainerService == null) {
            log.warn("Un-initialized clusterContainerService, can't create cache");
            return;
        }
        log.debug("Allocating caches for Container {}", (Object)this.container.getName());
        try {
            this.clusterContainerService.createCache(ORIGINAL_SW_VIEW_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache(INSTALLED_SW_VIEW_CACHE, EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.inactiveFlows", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.staticFlows", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.staticFlowsOrdinal", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.portGroupConfigs", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.portGroupData", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache("frm.TSPolicies", EnumSet.of(IClusterServices.cacheMode.TRANSACTIONAL));
            this.clusterContainerService.createCache(WORK_STATUS_CACHE, EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL, IClusterServices.cacheMode.ASYNC));
            this.clusterContainerService.createCache(WORK_ORDER_CACHE, EnumSet.of(IClusterServices.cacheMode.NON_TRANSACTIONAL, IClusterServices.cacheMode.ASYNC));
        }
        catch (CacheConfigException cce) {
            log.error("CacheConfigException");
        }
        catch (CacheExistException cce) {
            log.error("CacheExistException");
        }
    }

    private void retrieveCaches() {
        if (this.clusterContainerService == null) {
            log.warn("un-initialized clusterContainerService, can't retrieve cache");
            this.nonClusterObjectCreate();
            return;
        }
        log.debug("Retrieving Caches for Container {}", (Object)this.container.getName());
        ConcurrentMap map = this.clusterContainerService.getCache(ORIGINAL_SW_VIEW_CACHE);
        if (map != null) {
            this.originalSwView = map;
        } else {
            log.error("Retrieval of frm.originalSwView cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache(INSTALLED_SW_VIEW_CACHE);
        if (map != null) {
            this.installedSwView = map;
        } else {
            log.error("Retrieval of frm.installedSwView cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.inactiveFlows");
        if (map != null) {
            this.inactiveFlows = map;
        } else {
            log.error("Retrieval of frm.inactiveFlows cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.staticFlows");
        if (map != null) {
            this.staticFlows = map;
        } else {
            log.error("Retrieval of frm.staticFlows cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.staticFlowsOrdinal");
        if (map != null) {
            this.staticFlowsOrdinal = map;
        } else {
            log.error("Retrieval of frm.staticFlowsOrdinal cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.portGroupConfigs");
        if (map != null) {
            this.portGroupConfigs = map;
        } else {
            log.error("Retrieval of frm.portGroupConfigs cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.portGroupData");
        if (map != null) {
            this.portGroupData = map;
        } else {
            log.error("Retrieval of frm.portGroupData allocation failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache("frm.TSPolicies");
        if (map != null) {
            this.TSPolicies = map;
        } else {
            log.error("Retrieval of frm.TSPolicies cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache(WORK_ORDER_CACHE);
        if (map != null) {
            this.workOrder = map;
        } else {
            log.error("Retrieval of frm.workOrder cache failed for Container {}", (Object)this.container.getName());
        }
        map = this.clusterContainerService.getCache(WORK_STATUS_CACHE);
        if (map != null) {
            this.workStatus = map;
        } else {
            log.error("Retrieval of frm.workStatus cache failed for Container {}", (Object)this.container.getName());
        }
    }

    private boolean flowConfigExists(FlowConfig config) {
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            if (!((FlowConfig)entry.getValue()).isByNameAndNodeIdEqual(config)) continue;
            return true;
        }
        return false;
    }

    public Status addStaticFlow(FlowConfig config) {
        Status status = config.validate(this.container);
        if (!status.isSuccess()) {
            log.warn("Invalid Configuration for flow {}. The failure is {}", (Object)config, (Object)status.getDescription());
            String error = "Invalid Configuration (" + status.getDescription() + ")";
            config.setStatus(error);
            return new Status(StatusCode.BADREQUEST, error);
        }
        return this.addStaticFlowInternal(config, false);
    }

    private Status addStaticFlowInternal(FlowConfig config, boolean restore) {
        PortGroupConfig pgconfig;
        Map existingData;
        FlowEntry entry;
        Status status;
        boolean multipleFlowPush = false;
        config.setStatus(StatusCode.SUCCESS.toString());
        if (this.flowConfigExists(config)) {
            String error = "Entry with this name on specified switch already exists";
            log.warn("Entry with this name on specified switch already exists: {}", (Object)config);
            config.setStatus(error);
            return new Status(StatusCode.CONFLICT, error);
        }
        if (config.getIngressPort() == null && config.getPortGroup() != null) {
            for (String portGroupName : this.portGroupConfigs.keySet()) {
                if (!portGroupName.equalsIgnoreCase(config.getPortGroup())) continue;
                multipleFlowPush = true;
                break;
            }
            if (!multipleFlowPush) {
                log.warn("Invalid Configuration(Invalid PortGroup Name) for flow {}", (Object)config);
                String error = "Invalid Configuration (Invalid PortGroup Name)";
                config.setStatus(error);
                return new Status(StatusCode.BADREQUEST, error);
            }
        }
        if (!multipleFlowPush && config.installInHw() && !(status = this.installFlowEntry(entry = config.getFlowEntry())).isSuccess()) {
            config.setStatus(status.getDescription());
            if (!restore) {
                return status;
            }
        }
        Integer ordinal = (Integer)this.staticFlowsOrdinal.get(0);
        ordinal = ordinal + 1;
        this.staticFlowsOrdinal.put(0, ordinal);
        this.staticFlows.put(ordinal, config);
        if (multipleFlowPush && (existingData = (Map)this.portGroupData.get(pgconfig = (PortGroupConfig)this.portGroupConfigs.get(config.getPortGroup()))) != null) {
            this.portGroupChanged(pgconfig, existingData, true);
        }
        return new Status(StatusCode.SUCCESS);
    }

    private void addStaticFlowsToSwitch(Node node) {
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            FlowConfig config = (FlowConfig)entry.getValue();
            if (config.isPortGroupEnabled() || !config.getNode().equals((Object)node) || !config.installInHw() || config.getStatus().equals(StatusCode.SUCCESS.toString())) continue;
            Status status = this.installFlowEntryAsync(config.getFlowEntry());
            config.setStatus(status.getDescription());
        }
        this.refreshClusterStaticFlowsStatus(node);
    }

    private void updateStaticFlowConfigsOnNodeDown(Node node) {
        log.trace("Updating Static Flow configs on node down: {}", (Object)node);
        ArrayList toRemove = new ArrayList();
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            FlowConfig config = (FlowConfig)entry.getValue();
            if (config.isPortGroupEnabled() || !config.installInHw() || !config.getNode().equals((Object)node)) continue;
            if (config.isInternalFlow()) {
                toRemove.add(entry.getKey());
                continue;
            }
            config.setStatus(NODE_DOWN);
        }
        for (Integer index : toRemove) {
            this.staticFlows.remove(index);
        }
        this.refreshClusterStaticFlowsStatus(node);
    }

    private void updateStaticFlowConfigsOnContainerModeChange(UpdateType update) {
        log.trace("Updating Static Flow configs on container mode change: {}", (Object)update);
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            FlowConfig config = (FlowConfig)entry.getValue();
            if (config.isPortGroupEnabled() || !config.installInHw() || config.isInternalFlow()) continue;
            switch (update) {
                case ADDED: {
                    config.setStatus("Removed from node because in container mode");
                    break;
                }
                case REMOVED: {
                    config.setStatus(StatusCode.SUCCESS.toString());
                    break;
                }
            }
        }
        this.refreshClusterStaticFlowsStatus(null);
    }

    public Status removeStaticFlow(FlowConfig config) {
        Integer key = 0;
        FlowConfig target = null;
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            if (!((FlowConfig)entry.getValue()).isByNameAndNodeIdEqual(config)) continue;
            key = (Integer)entry.getKey();
            target = (FlowConfig)entry.getValue();
            break;
        }
        if (target == null) {
            return new Status(StatusCode.NOTFOUND, "Entry Not Present");
        }
        Status status = this.uninstallFlowEntry(config.getFlowEntry());
        if (status.isSuccess()) {
            this.staticFlows.remove(key);
        }
        return status;
    }

    public Status removeStaticFlow(String name, Node node) {
        String logMsg;
        String msg;
        Integer key = 0;
        FlowConfig target = null;
        for (Map.Entry mapEntry : this.staticFlows.entrySet()) {
            if (!((FlowConfig)mapEntry.getValue()).isByNameAndNodeIdEqual(name, node)) continue;
            key = (Integer)mapEntry.getKey();
            target = (FlowConfig)mapEntry.getValue();
            break;
        }
        if (target == null) {
            return new Status(StatusCode.NOTFOUND, "Entry Not Present");
        }
        if (target.isInternalFlow()) {
            msg = "Invalid operation: Controller generated flow cannot be deleted";
            logMsg = msg + ": {}";
            log.warn(logMsg, (Object)name);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        if (target.isPortGroupEnabled()) {
            msg = "Invalid operation: Port Group flows cannot be deleted through this API";
            logMsg = msg + ": {}";
            log.warn(logMsg, (Object)name);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        Status status = this.removeEntry(target.getFlowEntry(), false);
        if (status.isSuccess()) {
            this.staticFlows.remove(key);
        }
        return status;
    }

    public Status modifyStaticFlow(FlowConfig newFlowConfig) {
        String msg;
        if (newFlowConfig.isInternalFlow()) {
            String msg2 = "Invalid operation: Controller generated flow cannot be modified";
            String logMsg = msg2 + ": {}";
            log.warn(logMsg, (Object)newFlowConfig);
            return new Status(StatusCode.NOTACCEPTABLE, msg2);
        }
        Status status = newFlowConfig.validate(this.container);
        if (!status.isSuccess()) {
            String msg3 = "Invalid Configuration (" + status.getDescription() + ")";
            newFlowConfig.setStatus(msg3);
            log.warn("Invalid Configuration for flow {}. The failure is {}", (Object)newFlowConfig, (Object)status.getDescription());
            return new Status(StatusCode.BADREQUEST, msg3);
        }
        FlowConfig oldFlowConfig = null;
        Integer index = null;
        for (Map.Entry mapEntry : this.staticFlows.entrySet()) {
            FlowConfig entry = (FlowConfig)mapEntry.getValue();
            if (!entry.isByNameAndNodeIdEqual(newFlowConfig.getName(), newFlowConfig.getNode())) continue;
            oldFlowConfig = entry;
            index = (Integer)mapEntry.getKey();
            break;
        }
        if (oldFlowConfig == null) {
            msg = "Attempt to modify a non existing static flow";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)newFlowConfig);
            return new Status(StatusCode.NOTFOUND, msg);
        }
        if (newFlowConfig.equals(oldFlowConfig)) {
            msg = "No modification detected";
            log.trace("Static flow modification skipped. New flow and old flow are the same: {}", (Object)newFlowConfig);
            return new Status(StatusCode.SUCCESS, msg);
        }
        status = new Status(StatusCode.SUCCESS, "Saved in config");
        if (oldFlowConfig.installInHw()) {
            status = this.modifyFlowEntry(oldFlowConfig.getFlowEntry(), newFlowConfig.getFlowEntry());
        }
        if (status.isSuccess()) {
            newFlowConfig.setStatus(status.getDescription());
            this.staticFlows.put(index, newFlowConfig);
        }
        return status;
    }

    public Status toggleStaticFlowStatus(String name, Node node) {
        return this.toggleStaticFlowStatus(this.getStaticFlow(name, node));
    }

    public Status toggleStaticFlowStatus(FlowConfig config) {
        if (config == null) {
            String msg = "Invalid request: null flow config";
            log.warn(msg);
            return new Status(StatusCode.BADREQUEST, msg);
        }
        if (config.isInternalFlow()) {
            String msg = "Invalid operation: Controller generated flow cannot be modified";
            String logMsg = msg + ": {}";
            log.warn(logMsg, (Object)config);
            return new Status(StatusCode.NOTACCEPTABLE, msg);
        }
        Integer key = 0;
        FlowConfig target = null;
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            FlowConfig conf = (FlowConfig)entry.getValue();
            if (!conf.isByNameAndNodeIdEqual(config)) continue;
            key = (Integer)entry.getKey();
            target = conf;
            break;
        }
        if (target != null) {
            Status status = target.validate(this.container);
            if (!status.isSuccess()) {
                log.warn(status.getDescription());
                return status;
            }
            Status status2 = status = target.installInHw() ? this.uninstallFlowEntry(target.getFlowEntry()) : this.installFlowEntry(target.getFlowEntry());
            if (status.isSuccess()) {
                target.setStatus(StatusCode.SUCCESS.toString());
                target.toggleInstallation();
                this.staticFlows.put(key, target);
            }
            return status;
        }
        return new Status(StatusCode.NOTFOUND, "Unable to locate the entry. Failed to toggle status");
    }

    private void refreshClusterStaticFlowsStatus(Node node) {
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            if (node != null && !((FlowConfig)entry.getValue()).getNode().equals((Object)node)) continue;
            this.staticFlows.put((Integer)entry.getKey(), (FlowConfig)entry.getValue());
        }
    }

    private void uninstallAllFlowEntries(boolean preserveFlowEntries) {
        log.trace("Uninstalling all non-internal flows");
        ArrayList<FlowEntryInstall> toRemove = new ArrayList<FlowEntryInstall>();
        for (Map.Entry mapEntry : this.installedSwView.entrySet()) {
            FlowEntryInstall flowEntries = (FlowEntryInstall)mapEntry.getValue();
            if (flowEntries.isInternal()) continue;
            toRemove.add(flowEntries);
            if (!preserveFlowEntries) continue;
            this.inactiveFlows.put(flowEntries.getOriginal(), flowEntries.getOriginal());
        }
        for (FlowEntryInstall flowEntryHw : toRemove) {
            Node n = flowEntryHw.getNode();
            if (n != null && this.connectionManager.getLocalityStatus(n) == ConnectionLocality.LOCAL) {
                Status status = this.removeEntryInternal(flowEntryHw, false);
                if (status.isSuccess()) continue;
                log.trace("Failed to remove entry: {}. The failure is: {}", (Object)flowEntryHw, (Object)status.getDescription());
                continue;
            }
            log.debug("Not removing entry {} because not connected locally, the remote guy will do it's job", (Object)flowEntryHw);
        }
    }

    private void reinstallAllFlowEntries() {
        log.trace("Reinstalling all inactive flows");
        for (FlowEntry flowEntry : this.inactiveFlows.keySet()) {
            this.addEntry(flowEntry, false);
        }
        this.inactiveFlows.clear();
    }

    public List<FlowConfig> getStaticFlows() {
        return new ArrayList<FlowConfig>(this.staticFlows.values());
    }

    public FlowConfig getStaticFlow(String name, Node node) {
        Map.Entry<Integer, FlowConfig> entry = this.getStaticFlowEntry(name, node);
        if (entry != null) {
            return entry.getValue();
        }
        return null;
    }

    public List<FlowConfig> getStaticFlows(Node node) {
        ArrayList<FlowConfig> list = new ArrayList<FlowConfig>();
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            if (!((FlowConfig)entry.getValue()).onNode(node)) continue;
            list.add((FlowConfig)entry.getValue());
        }
        return list;
    }

    public List<String> getStaticFlowNamesForNode(Node node) {
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            if (!((FlowConfig)entry.getValue()).onNode(node)) continue;
            list.add(((FlowConfig)entry.getValue()).getName());
        }
        return list;
    }

    public List<Node> getListNodeWithConfiguredFlows() {
        HashSet<Node> set = new HashSet<Node>();
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            set.add(((FlowConfig)entry.getValue()).getNode());
        }
        return new ArrayList<Node>(set);
    }

    private void loadFlowConfiguration() {
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, PORT_GROUP_FILE_NAME)) {
            this.addPortGroupConfig(((PortGroupConfig)conf).getName(), ((PortGroupConfig)conf).getMatchString(), true);
        }
        for (ConfigurationObject conf : this.configurationService.retrieveConfiguration((IObjectReader)this, STATIC_FLOWS_FILE_NAME)) {
            this.addStaticFlowInternal((FlowConfig)conf, true);
        }
    }

    public Object readObject(ObjectInputStream ois) throws FileNotFoundException, IOException, ClassNotFoundException {
        return ois.readObject();
    }

    public Status saveConfig() {
        return this.saveConfigInternal();
    }

    private Status saveConfigInternal() {
        ArrayList<FlowConfig> nonDynamicFlows = new ArrayList<FlowConfig>();
        for (Integer ordinal : this.staticFlows.keySet()) {
            FlowConfig config = (FlowConfig)this.staticFlows.get(ordinal);
            if (config.isDynamic() || config.isInternalFlow()) continue;
            nonDynamicFlows.add(config);
        }
        this.configurationService.persistConfiguration(nonDynamicFlows, STATIC_FLOWS_FILE_NAME);
        this.configurationService.persistConfiguration(new ArrayList(this.portGroupConfigs.values()), PORT_GROUP_FILE_NAME);
        return new Status(StatusCode.SUCCESS);
    }

    public void subnetNotify(Subnet sub, boolean add) {
    }

    private boolean programInternalFlow(boolean proactive, FlowConfig fc) {
        boolean retVal = true;
        if (proactive) {
            if (this.flowConfigExists(fc)) {
                retVal = false;
            }
        } else if (!this.flowConfigExists(fc)) {
            retVal = false;
        }
        return retVal;
    }

    public void modeChangeNotify(final Node node, final boolean proactive) {
        Callable<Status> modeChangeCallable = new Callable<Status>(){

            @Override
            public Status call() throws Exception {
                ArrayList<FlowConfig> defaultConfigs = new ArrayList<FlowConfig>();
                ArrayList<String> puntAction = new ArrayList<String>();
                puntAction.add(ActionType.CONTROLLER.toString());
                FlowConfig allowARP = new FlowConfig();
                allowARP.setInstallInHw(true);
                allowARP.setName("__Punt ARP__");
                allowARP.setPriority("1");
                allowARP.setNode(node);
                allowARP.setEtherType("0x" + Integer.toHexString(EtherTypes.ARP.intValue()).toUpperCase());
                allowARP.setActions(puntAction);
                defaultConfigs.add(allowARP);
                FlowConfig allowLLDP = new FlowConfig();
                allowLLDP.setInstallInHw(true);
                allowLLDP.setName("__Punt LLDP__");
                allowLLDP.setPriority("1");
                allowLLDP.setNode(node);
                allowLLDP.setEtherType("0x" + Integer.toHexString(EtherTypes.LLDP.intValue()).toUpperCase());
                allowLLDP.setActions(puntAction);
                defaultConfigs.add(allowLLDP);
                ArrayList<String> dropAction = new ArrayList<String>();
                dropAction.add(ActionType.DROP.toString());
                FlowConfig dropAllConfig = new FlowConfig();
                dropAllConfig.setInstallInHw(true);
                dropAllConfig.setName("__Catch-All Drop__");
                dropAllConfig.setPriority("0");
                dropAllConfig.setNode(node);
                dropAllConfig.setActions(dropAction);
                defaultConfigs.add(dropAllConfig);
                log.trace("Forwarding mode for node {} set to {}", (Object)node, (Object)(proactive ? "proactive" : "reactive"));
                for (FlowConfig fc : defaultConfigs) {
                    if (ForwardingRulesManager.this.programInternalFlow(proactive, fc)) {
                        Status status;
                        Status status2 = status = proactive ? ForwardingRulesManager.this.addStaticFlowInternal(fc, false) : ForwardingRulesManager.this.removeStaticFlow(fc);
                        if (status.isSuccess()) {
                            log.trace("{} Proactive Static flow: {}", (Object)(proactive ? "Installed" : "Removed"), (Object)fc.getName());
                            continue;
                        }
                        log.warn("Failed to {} Proactive Static flow: {}", (Object)(proactive ? "install" : "remove"), (Object)fc.getName());
                        continue;
                    }
                    log.debug("Got redundant install request for internal flow: {} on node: {}. Request not sent to FRM.", (Object)fc.getName(), (Object)node);
                }
                return new Status(StatusCode.SUCCESS);
            }
        };
        this.executor.submit(modeChangeCallable);
    }

    private void cleanDatabaseForNode(Node node) {
        log.trace("Cleaning Flow database for Node {}", (Object)node);
        if (this.nodeFlows.containsKey(node)) {
            ArrayList toRemove = new ArrayList((Collection)this.nodeFlows.get(node));
            for (FlowEntryInstall entry : toRemove) {
                this.updateSwViews(entry, false);
            }
        }
    }

    private boolean doesFlowContainNodeConnector(Flow flow, NodeConnector nc) {
        NodeConnector matchPort;
        if (nc == null) {
            return false;
        }
        Match match = flow.getMatch();
        if (match.isPresent(MatchType.IN_PORT) && (matchPort = (NodeConnector)match.getField(MatchType.IN_PORT).getValue()).equals((Object)nc)) {
            return true;
        }
        List actionsList = flow.getActions();
        if (actionsList != null) {
            for (Action action : actionsList) {
                NodeConnector actionPort;
                if (!(action instanceof Output) || !(actionPort = ((Output)action).getPort()).equals((Object)nc)) continue;
                return true;
            }
        }
        return false;
    }

    public void notifyNode(Node node, UpdateType type, Map<String, Property> propMap) {
        this.pendingEvents.offer(new NodeUpdateEvent(type, node));
    }

    public void notifyNodeConnector(NodeConnector nodeConnector, UpdateType type, Map<String, Property> propMap) {
        boolean updateStaticFlowCluster = false;
        block0 : switch (type) {
            case ADDED: {
                break;
            }
            case CHANGED: {
                Config config;
                Config config2 = config = propMap == null ? null : (Config)propMap.get("config");
                if (config == null) break;
                switch (config.getValue()) {
                    case 0: {
                        log.trace("Port {} is administratively down: uninstalling interested flows", (Object)nodeConnector);
                        updateStaticFlowCluster = this.removeFlowsOnNodeConnectorDown(nodeConnector);
                        break block0;
                    }
                    case 1: {
                        log.trace("Port {} is administratively up: installing interested flows", (Object)nodeConnector);
                        updateStaticFlowCluster = this.installFlowsOnNodeConnectorUp(nodeConnector);
                        break block0;
                    }
                    case 32767: {
                        break block0;
                    }
                }
                break;
            }
            case REMOVED: {
                log.trace("Port {} was removed from our control: uninstalling interested flows", (Object)nodeConnector);
                updateStaticFlowCluster = this.removeFlowsOnNodeConnectorDown(nodeConnector);
                break;
            }
        }
        if (updateStaticFlowCluster) {
            this.refreshClusterStaticFlowsStatus(nodeConnector.getNode());
        }
    }

    private boolean installFlowsOnNodeConnectorUp(NodeConnector nodeConnector) {
        boolean updated = false;
        List<FlowConfig> flowConfigForNode = this.getStaticFlows(nodeConnector.getNode());
        for (FlowConfig flowConfig : flowConfigForNode) {
            if (!this.doesFlowContainNodeConnector(flowConfig.getFlow(), nodeConnector) || !flowConfig.installInHw() || flowConfig.getStatus().equals(StatusCode.SUCCESS.toString())) continue;
            Status status = this.installFlowEntry(flowConfig.getFlowEntry());
            if (!status.isSuccess()) {
                flowConfig.setStatus(status.getDescription());
            } else {
                flowConfig.setStatus(StatusCode.SUCCESS.toString());
            }
            updated = true;
        }
        return updated;
    }

    private boolean removeFlowsOnNodeConnectorDown(NodeConnector nodeConnector) {
        boolean updated = false;
        List nodeFlowEntries = (List)this.nodeFlows.get(nodeConnector.getNode());
        if (nodeFlowEntries == null) {
            return updated;
        }
        for (FlowEntryInstall fei : new ArrayList(nodeFlowEntries)) {
            FlowConfig flowConfig;
            Status status;
            if (!this.doesFlowContainNodeConnector(fei.getInstall().getFlow(), nodeConnector) || !(status = this.removeEntryInternal(fei, true)).isSuccess() || !fei.getGroupName().equals("__StaticFlows__") || (flowConfig = this.getStaticFlow(fei.getFlowName(), fei.getNode())) == null) continue;
            flowConfig.setStatus(PORT_REMOVED);
            updated = true;
        }
        return updated;
    }

    private FlowConfig getDerivedFlowConfig(FlowConfig original, String configName, Short port) {
        FlowConfig derivedFlow = new FlowConfig(original);
        derivedFlow.setDynamic(true);
        derivedFlow.setPortGroup(null);
        derivedFlow.setName(original.getName() + "_" + configName + "_" + port);
        derivedFlow.setIngressPort(port + "");
        return derivedFlow;
    }

    private void addPortGroupFlows(PortGroupConfig config, Node node, PortGroup data) {
        for (FlowConfig staticFlow : this.staticFlows.values()) {
            if (staticFlow.getPortGroup() == null || !staticFlow.getNode().equals((Object)node) || !staticFlow.getPortGroup().equals(config.getName())) continue;
            for (Short port : data.getPorts()) {
                FlowConfig derivedFlow = this.getDerivedFlowConfig(staticFlow, config.getName(), port);
                this.addStaticFlowInternal(derivedFlow, false);
            }
        }
    }

    private void removePortGroupFlows(PortGroupConfig config, Node node, PortGroup data) {
        for (FlowConfig staticFlow : this.staticFlows.values()) {
            if (staticFlow.getPortGroup() == null || !staticFlow.getNode().equals((Object)node) || !staticFlow.getPortGroup().equals(config.getName())) continue;
            for (Short port : data.getPorts()) {
                FlowConfig derivedFlow = this.getDerivedFlowConfig(staticFlow, config.getName(), port);
                this.removeStaticFlow(derivedFlow);
            }
        }
    }

    public void portGroupChanged(PortGroupConfig config, Map<Node, PortGroup> data, boolean add) {
        block5: {
            block4: {
                log.trace("PortGroup Changed for: {} Data: {}", (Object)config, this.portGroupData);
                Map existingData = (Map)this.portGroupData.get(config);
                if (existingData == null) break block4;
                for (Map.Entry<Node, PortGroup> entry : data.entrySet()) {
                    PortGroup existingPortGroup = (PortGroup)existingData.get(entry.getKey());
                    if (existingPortGroup == null) {
                        if (!add) continue;
                        existingData.put(entry.getKey(), entry.getValue());
                        this.addPortGroupFlows(config, entry.getKey(), entry.getValue());
                        continue;
                    }
                    if (add) {
                        existingPortGroup.getPorts().addAll(entry.getValue().getPorts());
                        this.addPortGroupFlows(config, entry.getKey(), entry.getValue());
                        continue;
                    }
                    existingPortGroup.getPorts().removeAll(entry.getValue().getPorts());
                    this.removePortGroupFlows(config, entry.getKey(), entry.getValue());
                }
                break block5;
            }
            if (!add) break block5;
            this.portGroupData.put(config, data);
            for (Node swid : data.keySet()) {
                this.addPortGroupFlows(config, swid, data.get(swid));
            }
        }
    }

    public boolean addPortGroupConfig(String name, String regex, boolean restore) {
        PortGroupConfig config = (PortGroupConfig)this.portGroupConfigs.get(name);
        if (config != null) {
            return false;
        }
        if (this.portGroupProvider == null && !restore) {
            return false;
        }
        if (this.portGroupProvider != null && !this.portGroupProvider.isMatchCriteriaSupported(regex)) {
            return false;
        }
        config = new PortGroupConfig(name, regex);
        this.portGroupConfigs.put(name, config);
        if (this.portGroupProvider != null) {
            this.portGroupProvider.createPortGroupConfig(config);
        }
        return true;
    }

    public boolean delPortGroupConfig(String name) {
        PortGroupConfig config = (PortGroupConfig)this.portGroupConfigs.get(name);
        if (config == null) {
            return false;
        }
        if (this.portGroupProvider != null) {
            this.portGroupProvider.deletePortGroupConfig(config);
        }
        this.portGroupConfigs.remove(name);
        return true;
    }

    public Map<String, PortGroupConfig> getPortGroupConfigs() {
        return this.portGroupConfigs;
    }

    public boolean isPortGroupSupported() {
        return this.portGroupProvider != null;
    }

    public void setIContainer(IContainer s) {
        this.container = s;
    }

    public void unsetIContainer(IContainer s) {
        if (this.container == s) {
            this.container = null;
        }
    }

    public void setConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service set request {}", (Object)service);
        this.configurationService = service;
    }

    public void unsetConfigurationContainerService(IConfigurationContainerService service) {
        log.trace("Got configuration service UNset request");
        this.configurationService = null;
    }

    public PortGroupProvider getPortGroupProvider() {
        return this.portGroupProvider;
    }

    public void unsetPortGroupProvider(PortGroupProvider portGroupProvider) {
        this.portGroupProvider = null;
    }

    public void setPortGroupProvider(PortGroupProvider portGroupProvider) {
        this.portGroupProvider = portGroupProvider;
        portGroupProvider.registerPortGroupChange((PortGroupChangeListener)this);
        for (PortGroupConfig config : this.portGroupConfigs.values()) {
            portGroupProvider.createPortGroupConfig(config);
        }
    }

    public void setFrmAware(IForwardingRulesManagerAware obj) {
        this.frmAware.add(obj);
    }

    public void unsetFrmAware(IForwardingRulesManagerAware obj) {
        this.frmAware.remove(obj);
    }

    void setClusterContainerService(IClusterContainerServices s) {
        log.debug("Cluster Service set");
        this.clusterContainerService = s;
    }

    void unsetClusterContainerService(IClusterContainerServices s) {
        if (this.clusterContainerService == s) {
            log.debug("Cluster Service removed!");
            this.clusterContainerService = null;
        }
    }

    private String getContainerName() {
        if (this.container == null) {
            return GlobalConstants.DEFAULT.toString();
        }
        return this.container.getName();
    }

    void init() {
        this.inContainerMode = false;
        if (this.portGroupProvider != null) {
            this.portGroupProvider.registerPortGroupChange((PortGroupChangeListener)this);
        }
        this.nodeFlows = new ConcurrentHashMap<Node, List<FlowEntryInstall>>();
        this.groupFlows = new ConcurrentHashMap<String, List<FlowEntryInstall>>();
        this.cacheStartup();
        if (this.staticFlowsOrdinal.size() == 0) {
            this.staticFlowsOrdinal.put(0, 0);
        }
        this.pendingEvents = new LinkedBlockingQueue<FRMEvent>();
        this.frmEventHandler = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!ForwardingRulesManager.this.stopping) {
                    try {
                        FRMEvent update;
                        final FRMEvent event = ForwardingRulesManager.this.pendingEvents.take();
                        if (event == null) {
                            log.warn("Dequeued null event");
                            continue;
                        }
                        log.trace("Dequeued {} event", (Object)event.getClass().getSimpleName());
                        if (event instanceof NodeUpdateEvent) {
                            update = (NodeUpdateEvent)event;
                            Node node = ((NodeUpdateEvent)update).getNode();
                            switch (((NodeUpdateEvent)update).getUpdateType()) {
                                case ADDED: {
                                    ForwardingRulesManager.this.addStaticFlowsToSwitch(node);
                                    break;
                                }
                                case REMOVED: {
                                    ForwardingRulesManager.this.cleanDatabaseForNode(node);
                                    ForwardingRulesManager.this.updateStaticFlowConfigsOnNodeDown(node);
                                    break;
                                }
                            }
                            continue;
                        }
                        if (event instanceof ErrorReportedEvent) {
                            ErrorReportedEvent errEvent = (ErrorReportedEvent)event;
                            ForwardingRulesManager.this.processErrorEvent(errEvent);
                            continue;
                        }
                        if (event instanceof WorkOrderEvent) {
                            Runnable r = new Runnable(){

                                @Override
                                public void run() {
                                    WorkOrderEvent work = (WorkOrderEvent)event;
                                    FlowEntryDistributionOrder fe = work.getFe();
                                    if (fe != null) {
                                        logsync.trace("Executing the workOrder {}", (Object)fe);
                                        Status gotStatus = null;
                                        FlowEntryInstall feiCurrent = fe.getEntry();
                                        FlowEntryInstall feiNew = (FlowEntryInstall)ForwardingRulesManager.this.workOrder.get(fe);
                                        switch (fe.getUpType()) {
                                            case ADDED: {
                                                gotStatus = ForwardingRulesManager.this.addEntriesInternal(feiCurrent, false);
                                                break;
                                            }
                                            case CHANGED: {
                                                gotStatus = ForwardingRulesManager.this.modifyEntryInternal(feiCurrent, feiNew, false);
                                                break;
                                            }
                                            case REMOVED: {
                                                gotStatus = ForwardingRulesManager.this.removeEntryInternal(feiCurrent, false);
                                            }
                                        }
                                        ForwardingRulesManager.this.workOrder.remove(fe);
                                        logsync.trace("The workOrder has been executed and now the status is being returned {}", (Object)fe);
                                        ForwardingRulesManager.this.workStatus.put(fe, gotStatus);
                                    } else {
                                        log.warn("Not expected null WorkOrder", (Object)work);
                                    }
                                }
                            };
                            if (ForwardingRulesManager.this.executor == null) continue;
                            ForwardingRulesManager.this.executor.execute(r);
                            continue;
                        }
                        if (event instanceof WorkStatusCleanup) {
                            WorkStatusCleanup work = (WorkStatusCleanup)event;
                            FlowEntryDistributionOrder fe = work.getFe();
                            if (fe != null) {
                                logsync.trace("The workStatus {} is being removed", (Object)fe);
                                ForwardingRulesManager.this.workStatus.remove(fe);
                                continue;
                            }
                            log.warn("Not expected null WorkStatus", (Object)work);
                            continue;
                        }
                        if (event instanceof ContainerFlowChangeEvent) {
                            ForwardingRulesManager.this.updateFlowsContainerFlow();
                            continue;
                        }
                        if (event instanceof UpdateIndexDBs) {
                            update = (UpdateIndexDBs)event;
                            ForwardingRulesManager.this.updateIndexDatabase(((UpdateIndexDBs)update).getFei(), ((UpdateIndexDBs)update).isAddition());
                            continue;
                        }
                        log.warn("Dequeued unknown event {}", (Object)event.getClass().getSimpleName());
                    }
                    catch (InterruptedException e) {
                        ForwardingRulesManager.this.pendingEvents.clear();
                    }
                }
            }
        }, "FRM EventHandler Collector");
    }

    void destroy() {
        this.frmEventHandler.interrupt();
        this.pendingEvents.clear();
        this.frmAware.clear();
        this.workMonitor.clear();
    }

    void start() {
        if (GlobalConstants.DEFAULT.toString().equals(this.getContainerName())) {
            this.inContainerMode = this.containerManager.inContainerMode();
        }
        this.stopping = false;
        this.executor = Executors.newFixedThreadPool(10);
        this.frmEventHandler.start();
        for (FlowEntryInstall fei : this.installedSwView.values()) {
            this.pendingEvents.offer(new UpdateIndexDBs(fei, true));
        }
        this.loadFlowConfiguration();
    }

    public void containerStop() {
        this.uninstallAllFlowEntries(false);
    }

    void stop() {
        this.stopping = true;
        this.executor.shutdownNow();
        for (FlowEntryDistributionOrder fe : this.workMonitor.keySet()) {
            FlowEntryDistributionOrderFutureTask task = (FlowEntryDistributionOrderFutureTask)this.workMonitor.get(fe);
            task.cancel(true);
        }
    }

    public void setFlowProgrammerService(IFlowProgrammerService service) {
        this.programmer = service;
    }

    public void unsetFlowProgrammerService(IFlowProgrammerService service) {
        if (this.programmer == service) {
            this.programmer = null;
        }
    }

    public void setSwitchManager(ISwitchManager switchManager) {
        this.switchManager = switchManager;
    }

    public void unsetSwitchManager(ISwitchManager switchManager) {
        if (this.switchManager == switchManager) {
            this.switchManager = null;
        }
    }

    public void tagUpdated(String containerName, Node n, short oldTag, short newTag, UpdateType t) {
        if (!this.container.getName().equals(containerName)) {
            return;
        }
    }

    public void containerFlowUpdated(String containerName, ContainerFlow previous, ContainerFlow current, UpdateType t) {
        if (!this.container.getName().equals(containerName)) {
            return;
        }
        log.trace("Container {}: Updating installed flows because of container flow change: {} {}", new Object[]{this.container.getName(), t, current});
        ContainerFlowChangeEvent ev = new ContainerFlowChangeEvent(previous, current, t);
        this.pendingEvents.offer(ev);
    }

    public void nodeConnectorUpdated(String containerName, NodeConnector nc, UpdateType t) {
        if (!this.container.getName().equals(containerName)) {
            return;
        }
        boolean updateStaticFlowCluster = false;
        switch (t) {
            case REMOVED: {
                log.trace("Port {} was removed from container: uninstalling interested flows", (Object)nc);
                updateStaticFlowCluster = this.removeFlowsOnNodeConnectorDown(nc);
                break;
            }
            case ADDED: {
                log.trace("Port {} was added to container: reinstall interested flows", (Object)nc);
                updateStaticFlowCluster = this.installFlowsOnNodeConnectorUp(nc);
                break;
            }
            case CHANGED: {
                break;
            }
        }
        if (updateStaticFlowCluster) {
            this.refreshClusterStaticFlowsStatus(nc.getNode());
        }
    }

    public void containerModeUpdated(UpdateType update) {
        if (!this.container.getName().equals(GlobalConstants.DEFAULT.toString())) {
            return;
        }
        switch (update) {
            case ADDED: {
                this.inContainerMode = true;
                this.uninstallAllFlowEntries(true);
                break;
            }
            case REMOVED: {
                this.inContainerMode = false;
                this.reinstallAllFlowEntries();
                break;
            }
        }
        this.updateStaticFlowConfigsOnContainerModeChange(update);
    }

    public Status saveConfiguration() {
        return this.saveConfig();
    }

    public void flowRemoved(Node node, Flow flow) {
        log.trace("Received flow removed notification on {} for {}", (Object)node, (Object)flow);
        FlowEntryInstall test = new FlowEntryInstall(new FlowEntry("", "", flow, node), null);
        FlowEntryInstall installedEntry = (FlowEntryInstall)this.installedSwView.get(test);
        if (installedEntry == null) {
            log.trace("Entry is not known to us");
            return;
        }
        Integer key = 0;
        FlowConfig target = null;
        for (Map.Entry entry : this.staticFlows.entrySet()) {
            FlowConfig conf = (FlowConfig)entry.getValue();
            if (!conf.isByNameAndNodeIdEqual(installedEntry.getFlowName(), node)) continue;
            key = (Integer)entry.getKey();
            target = conf;
            break;
        }
        if (target != null) {
            if (target.getHardTimeout() != null || target.getIdleTimeout() != null) {
                target.toggleInstallation();
            }
            target.setStatus(StatusCode.GONE.toString());
            this.staticFlows.put(key, target);
        }
        this.updateSwViews(installedEntry, false);
    }

    public void flowErrorReported(Node node, long rid, Object err) {
        log.trace("Got error {} for message rid {} from node {}", new Object[]{err, rid, node});
        this.pendingEvents.offer(new ErrorReportedEvent(rid, node, err));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processErrorEvent(ErrorReportedEvent event) {
        Node node = event.getNode();
        long rid = event.getRequestId();
        Object error = event.getError();
        String errorString = error == null ? "Not provided" : error.toString();
        FlowEntryInstall target = null;
        List flowEntryInstallList = (List)this.nodeFlows.get(node);
        if (flowEntryInstallList != null) {
            for (FlowEntryInstall index : flowEntryInstallList) {
                FlowEntryInstall entry = (FlowEntryInstall)this.installedSwView.get(index);
                if (entry == null || entry.getRequestId() != rid) continue;
                target = entry;
                break;
            }
        }
        if (target != null) {
            Map.Entry<Integer, FlowConfig> staticFlowEntry;
            this.updateSwViews(target, false);
            if ("__StaticFlows__".equals(target.getGroupName()) && (staticFlowEntry = this.getStaticFlowEntry(target.getFlowName(), target.getNode())) != null) {
                log.debug("Updating static flow configuration on async error event");
                String status = String.format("Cannot be installed on node. reason: %s", errorString);
                staticFlowEntry.getValue().setStatus(status);
                this.refreshClusterStaticFlowsStatus(node);
            }
        }
        if (this.frmAware != null) {
            Set<IForwardingRulesManagerAware> set = this.frmAware;
            synchronized (set) {
                for (IForwardingRulesManagerAware frma : this.frmAware) {
                    try {
                        frma.requestFailed(rid, errorString);
                    }
                    catch (Exception e) {
                        log.warn("Failed to notify {}", (Object)frma);
                    }
                }
            }
        }
    }

    public Status solicitStatusResponse(Node node, boolean blocking) {
        Status rv = new Status(StatusCode.INTERNALERROR);
        if (this.programmer != null) {
            rv = blocking ? this.programmer.syncSendBarrierMessage(node) : this.programmer.asyncSendBarrierMessage(node);
        }
        return rv;
    }

    public void unsetIConnectionManager(IConnectionManager s) {
        if (s == this.connectionManager) {
            this.connectionManager = null;
        }
    }

    public void setIConnectionManager(IConnectionManager s) {
        this.connectionManager = s;
    }

    public void unsetIContainerManager(IContainerManager s) {
        if (s == this.containerManager) {
            this.containerManager = null;
        }
    }

    public void setIContainerManager(IContainerManager s) {
        this.containerManager = s;
    }

    public void entryCreated(Object key, String cacheName, boolean originLocal) {
    }

    public void entryUpdated(Object key, Object new_value, String cacheName, boolean originLocal) {
        if (cacheName.equals(INSTALLED_SW_VIEW_CACHE)) {
            this.pendingEvents.offer(new UpdateIndexDBs((FlowEntryInstall)new_value, true));
        }
        if (originLocal) {
            return;
        }
        if (cacheName.equals(WORK_ORDER_CACHE)) {
            logsync.trace("Got a WorkOrderCacheUpdate for {}", key);
            FlowEntryDistributionOrder fe = (FlowEntryDistributionOrder)key;
            FlowEntryInstall fei = fe.getEntry();
            if (fei == null) {
                return;
            }
            Node n = fei.getNode();
            if (this.connectionManager.getLocalityStatus(n) == ConnectionLocality.LOCAL) {
                logsync.trace("workOrder for fe {} processed locally", (Object)fe);
                this.pendingEvents.offer(new WorkOrderEvent(fe, (FlowEntryInstall)new_value));
            }
        } else if (cacheName.equals(WORK_STATUS_CACHE)) {
            FlowEntryDistributionOrderFutureTask fet;
            logsync.trace("Got a WorkStatusCacheUpdate for {}", key);
            FlowEntryDistributionOrder fe = (FlowEntryDistributionOrder)key;
            if (fe.getRequestorController().equals(this.clusterContainerService.getMyAddress()) && (fet = (FlowEntryDistributionOrderFutureTask)this.workMonitor.remove(fe)) != null) {
                logsync.trace("workStatus response is for us {}", (Object)fe);
                fet.gotStatus(fe, (Status)this.workStatus.get(fe));
                this.pendingEvents.offer(new WorkStatusCleanup(fe));
            }
        }
    }

    public void entryDeleted(Object key, String cacheName, boolean originLocal) {
        if (cacheName.equals(INSTALLED_SW_VIEW_CACHE)) {
            this.pendingEvents.offer(new UpdateIndexDBs((FlowEntryInstall)key, false));
        }
    }

    public List<FlowEntry> getFlowEntriesForNode(Node node) {
        ArrayList<FlowEntry> list = new ArrayList<FlowEntry>();
        if (node != null) {
            for (Map.Entry entry : this.originalSwView.entrySet()) {
                if (!node.equals((Object)((FlowEntry)entry.getKey()).getNode())) continue;
                list.add(((FlowEntry)entry.getValue()).clone());
            }
        }
        return list;
    }

    public List<FlowEntry> getInstalledFlowEntriesForNode(Node node) {
        List flowEntryInstallList;
        ArrayList<FlowEntry> list = new ArrayList<FlowEntry>();
        if (node != null && (flowEntryInstallList = (List)this.nodeFlows.get(node)) != null) {
            for (FlowEntryInstall fi : flowEntryInstallList) {
                list.add(fi.getInstall().clone());
            }
        }
        return list;
    }

    private class UpdateIndexDBs
    extends FRMEvent {
        private FlowEntryInstall fei;
        private boolean add;

        UpdateIndexDBs(FlowEntryInstall fei, boolean add) {
            this.fei = fei;
            this.add = add;
        }

        public FlowEntryInstall getFei() {
            return this.fei;
        }

        public boolean isAddition() {
            return this.add;
        }
    }

    private class WorkStatusCleanup
    extends FRMEvent {
        private FlowEntryDistributionOrder fe;

        WorkStatusCleanup(FlowEntryDistributionOrder fe) {
            this.fe = fe;
        }

        public FlowEntryDistributionOrder getFe() {
            return this.fe;
        }
    }

    private class ContainerFlowChangeEvent
    extends FRMEvent {
        private final ContainerFlow previous;
        private final ContainerFlow current;
        private final UpdateType type;

        public ContainerFlowChangeEvent(ContainerFlow previous, ContainerFlow current, UpdateType type) {
            this.previous = previous;
            this.current = current;
            this.type = type;
        }

        public ContainerFlow getPrevious() {
            return this.previous;
        }

        public ContainerFlow getCurrent() {
            return this.current;
        }

        public UpdateType getType() {
            return this.type;
        }
    }

    private class WorkOrderEvent
    extends FRMEvent {
        private FlowEntryDistributionOrder fe;
        private FlowEntryInstall newEntry;

        WorkOrderEvent(FlowEntryDistributionOrder fe, FlowEntryInstall newEntry) {
            this.fe = fe;
            this.newEntry = newEntry;
        }

        public FlowEntryDistributionOrder getFe() {
            return this.fe;
        }

        public FlowEntryInstall getNewEntry() {
            return this.newEntry;
        }
    }

    private class ErrorReportedEvent
    extends FRMEvent {
        private final long rid;
        private final Node node;
        private final Object error;

        public ErrorReportedEvent(long rid, Node node, Object error) {
            this.rid = rid;
            this.node = node;
            this.error = error;
        }

        public long getRequestId() {
            return this.rid;
        }

        public Object getError() {
            return this.error;
        }

        public Node getNode() {
            return this.node;
        }
    }

    private class NodeUpdateEvent
    extends FRMEvent {
        private final Node node;
        private final UpdateType update;

        public NodeUpdateEvent(UpdateType update, Node node) {
            this.update = update;
            this.node = node;
        }

        public UpdateType getUpdateType() {
            return this.update;
        }

        public Node getNode() {
            return this.node;
        }
    }

    protected abstract class FRMEvent {
        protected FRMEvent() {
        }
    }
}

