/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager.internal;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.opendaylight.controller.forwardingrulesmanager.implementation.data.FlowEntryDistributionOrder;
import org.opendaylight.controller.sal.utils.Status;
import org.opendaylight.controller.sal.utils.StatusCode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class FlowEntryDistributionOrderFutureTask
implements Future<Status> {
    private final FlowEntryDistributionOrder order;
    private boolean amICancelled;
    private CountDownLatch waitingLatch;
    private Status retStatus;
    private static final Logger logger = LoggerFactory.getLogger(FlowEntryDistributionOrderFutureTask.class);
    private long timeout;
    private static final Long DEFAULTTIMEOUT = 30000L;

    FlowEntryDistributionOrderFutureTask(FlowEntryDistributionOrder order) {
        this.order = order;
        this.amICancelled = false;
        this.waitingLatch = new CountDownLatch(1);
        this.retStatus = new Status(StatusCode.UNDEFINED);
        String strTimeout = System.getProperty("FlowEntryDistributionOrderFutureTask.timeout", DEFAULTTIMEOUT.toString());
        try {
            this.timeout = Long.parseLong(strTimeout);
        }
        catch (Exception e) {
            this.timeout = DEFAULTTIMEOUT;
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.waitingLatch.getCount() != 0L) {
            this.retStatus = new Status(StatusCode.GONE);
            this.waitingLatch.countDown();
            logger.trace("Cancelled the workOrder");
            return true;
        }
        return false;
    }

    @Override
    public Status get() throws InterruptedException, ExecutionException {
        boolean didFinish = false;
        logger.trace("Getting status for order {}", (Object)this.order);
        if (this.waitingLatch.getCount() == 0L) {
            logger.trace("get returns the status without waiting");
            return this.retStatus;
        }
        logger.trace("Start waiting for status to come back");
        didFinish = this.waitingLatch.await(this.timeout, TimeUnit.MILLISECONDS);
        if (didFinish) {
            logger.trace("Waiting for the status of order {} is over, returning it", (Object)this.order);
            return this.retStatus;
        }
        logger.error("Timing out, the workStatus for order {} has not come back in time!, it's hashcode is {}", (Object)this.order, (Object)this.order.hashCode());
        return new Status(StatusCode.TIMEOUT);
    }

    @Override
    public Status get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean didFinish = false;
        logger.trace("Getting status for order {}", (Object)this.order);
        if (this.waitingLatch.getCount() == 0L) {
            logger.trace("get returns the status without waiting");
            return this.retStatus;
        }
        logger.trace("Start waiting for status to come back");
        didFinish = this.waitingLatch.await(timeout, unit);
        if (didFinish) {
            logger.trace("Waiting for the status is over, returning it");
            return this.retStatus;
        }
        logger.trace("Timing out, the workStatus for order {} has not come back in time!", (Object)this.order);
        return new Status(StatusCode.TIMEOUT);
    }

    @Override
    public boolean isCancelled() {
        return this.amICancelled;
    }

    @Override
    public boolean isDone() {
        return this.waitingLatch.getCount() == 0L;
    }

    void gotStatus(FlowEntryDistributionOrder order, Status retStatus) {
        logger.trace("Got status for order:{} \n Status:{}", (Object)order, (Object)retStatus);
        if (!order.equals(this.order)) {
            logger.error("Didn't get a result for an order we did issue order expected:{}, order received:{}", (Object)this.order, (Object)order);
            return;
        }
        this.retStatus = retStatus;
        this.waitingLatch.countDown();
        logger.trace("Unlocked the Future");
    }

    public FlowEntryDistributionOrder getOrder() {
        return this.order;
    }
}

