/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager.internal;

import java.util.Dictionary;
import java.util.HashSet;
import java.util.Hashtable;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.Dependency;
import org.opendaylight.controller.clustering.services.ICacheUpdateAware;
import org.opendaylight.controller.clustering.services.IClusterContainerServices;
import org.opendaylight.controller.configuration.IConfigurationContainerAware;
import org.opendaylight.controller.configuration.IConfigurationContainerService;
import org.opendaylight.controller.connectionmanager.IConnectionManager;
import org.opendaylight.controller.containermanager.IContainerManager;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManager;
import org.opendaylight.controller.forwardingrulesmanager.IForwardingRulesManagerAware;
import org.opendaylight.controller.forwardingrulesmanager.internal.ForwardingRulesManager;
import org.opendaylight.controller.forwardingrulesmanager.internal.ForwardingRulesManagerCLI;
import org.opendaylight.controller.sal.core.ComponentActivatorAbstractBase;
import org.opendaylight.controller.sal.core.IContainer;
import org.opendaylight.controller.sal.core.IContainerLocalListener;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerListener;
import org.opendaylight.controller.sal.flowprogrammer.IFlowProgrammerService;
import org.opendaylight.controller.sal.utils.GlobalConstants;
import org.opendaylight.controller.switchmanager.IInventoryListener;
import org.opendaylight.controller.switchmanager.ISwitchManager;
import org.opendaylight.controller.switchmanager.ISwitchManagerAware;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
extends ComponentActivatorAbstractBase {
    protected static final Logger logger = LoggerFactory.getLogger(Activator.class);

    public Object[] getImplementations() {
        Object[] res = new Object[]{ForwardingRulesManager.class};
        return res;
    }

    public void configureInstance(Component c, Object imp, String containerName) {
        if (imp.equals(ForwardingRulesManager.class)) {
            String[] interfaces = null;
            Hashtable props = new Hashtable();
            HashSet<String> propSet = new HashSet<String>();
            propSet.add("frm.workStatus");
            propSet.add("frm.workOrder");
            propSet.add("frm.installedSwView");
            ((Dictionary)props).put("cachenames", propSet);
            interfaces = new String[]{IContainerLocalListener.class.getName(), ISwitchManagerAware.class.getName(), IForwardingRulesManager.class.getName(), IInventoryListener.class.getName(), IConfigurationContainerAware.class.getName(), ICacheUpdateAware.class.getName(), IFlowProgrammerListener.class.getName()};
            c.setInterface(interfaces, props);
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IFlowProgrammerService.class).setCallbacks("setFlowProgrammerService", "unsetFlowProgrammerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IClusterContainerServices.class).setCallbacks("setClusterContainerService", "unsetClusterContainerService").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(ISwitchManager.class).setCallbacks("setSwitchManager", "unsetSwitchManager").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IForwardingRulesManagerAware.class).setCallbacks("setFrmAware", "unsetFrmAware").setRequired(false));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IContainer.class).setCallbacks("setIContainer", "unsetIContainer").setRequired(true));
            c.add((Dependency)this.createServiceDependency().setService(IConnectionManager.class).setCallbacks("setIConnectionManager", "unsetIConnectionManager").setRequired(true));
            c.add((Dependency)this.createContainerServiceDependency(containerName).setService(IConfigurationContainerService.class).setCallbacks("setConfigurationContainerService", "unsetConfigurationContainerService").setRequired(true));
            if (GlobalConstants.DEFAULT.toString().equals(containerName)) {
                c.add((Dependency)this.createServiceDependency().setService(IContainerManager.class).setCallbacks("setIContainerManager", "unsetIContainerManager").setRequired(true));
            }
        }
    }

    protected Object[] getGlobalImplementations() {
        Object[] res = new Object[]{ForwardingRulesManagerCLI.class};
        return res;
    }
}

