/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.forwardingrulesmanager.implementation.data;

import java.io.Serializable;
import java.net.InetAddress;
import org.opendaylight.controller.forwardingrulesmanager.FlowEntryInstall;
import org.opendaylight.controller.sal.core.UpdateType;

public final class FlowEntryDistributionOrder
implements Serializable {
    private static final long serialVersionUID = 416280377113255147L;
    private final FlowEntryInstall entry;
    private final UpdateType upType;
    private final InetAddress requestorController;

    public FlowEntryInstall getEntry() {
        return this.entry;
    }

    public UpdateType getUpType() {
        return this.upType;
    }

    public InetAddress getRequestorController() {
        return this.requestorController;
    }

    public FlowEntryDistributionOrder(FlowEntryInstall entry, UpdateType upType, InetAddress requestorController) {
        this.entry = entry;
        this.upType = upType;
        this.requestorController = requestorController;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.entry == null ? 0 : this.entry.hashCode());
        result = 31 * result + (this.requestorController == null ? 0 : this.requestorController.hashCode());
        result = 31 * result + (this.upType == null ? 0 : this.upType.calculateConsistentHashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowEntryDistributionOrder)) {
            return false;
        }
        FlowEntryDistributionOrder other = (FlowEntryDistributionOrder)obj;
        if (this.entry == null ? other.entry != null : !this.entry.equals((Object)other.entry)) {
            return false;
        }
        if (this.requestorController == null ? other.requestorController != null : !this.requestorController.equals(other.requestorController)) {
            return false;
        }
        return this.upType == other.upType;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("FlowEntryDistributionOrder [");
        if (this.entry != null) {
            builder.append("entry=").append(this.entry).append(", ");
        }
        if (this.upType != null) {
            builder.append("upType=").append(this.upType).append(", ");
        }
        if (this.requestorController != null) {
            builder.append("requestorController=").append(this.requestorController);
        }
        builder.append("]");
        return builder.toString();
    }
}

