/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.xml;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.transform.dom.DOMSource;
import javax.xml.validation.Schema;
import javax.xml.validation.Validator;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class XmlNetconfValidator {
    static final Schema schema;

    public static void validate(Document inputDocument) throws SAXException, IOException {
        Validator validator = schema.newValidator();
        DOMSource source = new DOMSource(inputDocument);
        validator.validate(source);
    }

    static {
        InputStream xmlSchema = XmlNetconfValidator.class.getResourceAsStream("/xml.xsd");
        Preconditions.checkNotNull((Object)xmlSchema, (Object)"Cannot find xml.xsd");
        InputStream rfc4714Schema = XmlNetconfValidator.class.getResourceAsStream("/rfc4741.xsd");
        Preconditions.checkNotNull((Object)rfc4714Schema, (Object)"Cannot find rfc4741.xsd");
        schema = XmlUtil.loadSchema(xmlSchema, rfc4714Schema);
    }
}

