/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.xml;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class XmlElement {
    public final Element element;

    private XmlElement(Element element) {
        this.element = element;
    }

    public static XmlElement fromDomElement(Element e) {
        return new XmlElement(e);
    }

    public static XmlElement fromDomDocument(Document xml) {
        return new XmlElement(xml.getDocumentElement());
    }

    public static XmlElement fromString(String s) {
        try {
            return new XmlElement(XmlUtil.readXmlToElement(s));
        }
        catch (IOException | SAXException e) {
            throw new IllegalArgumentException("Unable to create from " + s, e);
        }
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName) {
        XmlElement xmlElement = XmlElement.fromDomElement(element);
        xmlElement.checkName(expectedName);
        return xmlElement;
    }

    public static XmlElement fromDomElementWithExpected(Element element, String expectedName, String expectedNamespace) {
        XmlElement xmlElement = XmlElement.fromDomElementWithExpected(element, expectedName);
        xmlElement.checkNamespace(expectedNamespace);
        return xmlElement;
    }

    private static Map<String, String> extractNamespaces(Element typeElement) {
        HashMap<String, String> namespaces = new HashMap<String, String>();
        NamedNodeMap attributes = typeElement.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            String prefix;
            Node attribute = attributes.item(i);
            String attribKey = attribute.getNodeName();
            if (!attribKey.startsWith("xmlns")) continue;
            if (attribKey.equals("xmlns")) {
                prefix = "";
            } else {
                Preconditions.checkState((boolean)attribKey.startsWith("xmlns:"));
                prefix = attribKey.substring("xmlns".length() + 1);
            }
            namespaces.put(prefix, attribute.getNodeValue());
        }
        return namespaces;
    }

    public void checkName(String expectedName) {
        Preconditions.checkArgument((boolean)this.getName().equals(expectedName), (String)"Expected %s xml element but was %s", (Object[])new Object[]{expectedName, this.getName()});
    }

    public void checkNamespaceAttribute(String expectedNamespace) {
        Preconditions.checkArgument((boolean)this.getNamespaceAttribute().equals(expectedNamespace), (String)"Unexpected namespace %s for element %s, should be %s", (Object[])new Object[]{this.getNamespaceAttribute(), expectedNamespace});
    }

    public void checkNamespace(String expectedNamespace) {
        Preconditions.checkArgument((boolean)this.getNamespace().equals(expectedNamespace), (String)"Unexpected namespace %s for element %s, should be %s", (Object[])new Object[]{this.getNamespace(), expectedNamespace});
    }

    public String getName() {
        if (this.element.getLocalName() != null && !this.element.getLocalName().equals("")) {
            return this.element.getLocalName();
        }
        return this.element.getTagName();
    }

    public String getAttribute(String attributeName) {
        return this.element.getAttribute(attributeName);
    }

    public String getAttribute(String attributeName, String namespace) {
        return this.element.getAttributeNS(namespace, attributeName);
    }

    public NodeList getElementsByTagName(String name) {
        return this.element.getElementsByTagName(name);
    }

    public void appendChild(Element element) {
        this.element.appendChild(element);
    }

    public Element getDomElement() {
        return this.element;
    }

    public Map<String, Attr> getAttributes() {
        HashMap mappedAttributes = Maps.newHashMap();
        NamedNodeMap attributes = this.element.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Attr attr = (Attr)attributes.item(i);
            mappedAttributes.put(attr.getNodeName(), attr);
        }
        return mappedAttributes;
    }

    private List<XmlElement> getChildElementsInternal(ElementFilteringStrategy strat) {
        NodeList childNodes = this.element.getChildNodes();
        ArrayList<XmlElement> result = new ArrayList<XmlElement>();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node item = childNodes.item(i);
            if (!(item instanceof Element) || !strat.accept((Element)item)) continue;
            result.add(new XmlElement((Element)item));
        }
        return result;
    }

    public List<XmlElement> getChildElements() {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                return true;
            }
        });
    }

    public List<XmlElement> getChildElementsWithinNamespace(final String childName, String namespace) {
        return Lists.newArrayList((Iterable)Collections2.filter(this.getChildElementsWithinNamespace(namespace), (Predicate)new Predicate<XmlElement>(){

            public boolean apply(@Nullable XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }));
    }

    public List<XmlElement> getChildElementsWithinNamespace(final String namespace) {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                return XmlElement.fromDomElement(e).getNamespace().equals(namespace);
            }
        });
    }

    public List<XmlElement> getChildElements(final String tagName) {
        return this.getChildElementsInternal(new ElementFilteringStrategy(){

            @Override
            public boolean accept(Element e) {
                return e.getTagName().equals(tagName);
            }
        });
    }

    public XmlElement getOnlyChildElement(String childName) {
        List<XmlElement> nameElements = this.getChildElements(childName);
        Preconditions.checkState((nameElements.size() == 1 ? 1 : 0) != 0, (Object)("One element " + childName + " expected in " + this.toString()));
        return nameElements.get(0);
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(String childName) {
        try {
            return Optional.of((Object)this.getOnlyChildElement(childName));
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public Optional<XmlElement> getOnlyChildElementOptionally(String childName, String namespace) {
        try {
            return Optional.of((Object)this.getOnlyChildElement(childName, namespace));
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public XmlElement getOnlyChildElementWithSameNamespace(String childName) {
        return this.getOnlyChildElement(childName, this.getNamespace());
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally(String childName) {
        try {
            return Optional.of((Object)this.getOnlyChildElement(childName, this.getNamespace()));
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public XmlElement getOnlyChildElementWithSameNamespace() {
        XmlElement childElement = this.getOnlyChildElement();
        childElement.checkNamespace(this.getNamespace());
        return childElement;
    }

    public Optional<XmlElement> getOnlyChildElementWithSameNamespaceOptionally() {
        try {
            XmlElement childElement = this.getOnlyChildElement();
            childElement.checkNamespace(this.getNamespace());
            return Optional.of((Object)childElement);
        }
        catch (Exception e) {
            return Optional.absent();
        }
    }

    public XmlElement getOnlyChildElement(final String childName, String namespace) {
        ArrayList children = this.getChildElementsWithinNamespace(namespace);
        Preconditions.checkState(((children = Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

            public boolean apply(@Nullable XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }))).size() == 1 ? 1 : 0) != 0, (String)"One element %s:%s expected in %s but was %s", (Object[])new Object[]{namespace, childName, this.toString(), children.size()});
        return (XmlElement)children.get(0);
    }

    public XmlElement getOnlyChildElement() {
        List<XmlElement> children = this.getChildElements();
        Preconditions.checkState((children.size() == 1 ? 1 : 0) != 0, (String)"One element expected in %s but was %s", (Object[])new Object[]{this.toString(), children.size()});
        return children.get(0);
    }

    public String getTextContent() {
        Node textChild = this.element.getFirstChild();
        Preconditions.checkNotNull((Object)textChild, (Object)("Child node expected, got null for " + this.getName() + " : " + this.element));
        Preconditions.checkState((boolean)(textChild instanceof Text), (Object)(this.getName() + " should contain text." + Text.class.getName() + " expected, got " + textChild));
        String content = textChild.getTextContent();
        return content.trim();
    }

    public String getNamespaceAttribute() {
        String attribute = this.element.getAttribute("xmlns");
        Preconditions.checkState((attribute != null && !attribute.equals("") ? 1 : 0) != 0, (String)"Element %s must specify namespace", (Object[])new Object[]{this.toString()});
        return attribute;
    }

    public String getNamespace() {
        String namespaceURI = this.element.getNamespaceURI();
        Preconditions.checkState((namespaceURI != null ? 1 : 0) != 0, (String)"No namespace defined for %s", (Object[])new Object[]{this});
        return namespaceURI.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("XmlElement{");
        sb.append("name='").append(this.getName()).append('\'');
        if (this.element.getNamespaceURI() != null) {
            sb.append(", namespace='").append(this.getNamespace()).append('\'');
        }
        sb.append('}');
        return sb.toString();
    }

    public Map.Entry<String, String> findNamespaceOfTextContent() {
        String textContent;
        int indexOfColon;
        String prefix;
        Map<String, String> namespaces = XmlElement.extractNamespaces(this.element);
        if (!namespaces.containsKey(prefix = (indexOfColon = (textContent = this.getTextContent()).indexOf(":")) > -1 ? textContent.substring(0, indexOfColon) : "")) {
            throw new IllegalArgumentException("Cannot find namespace for " + XmlUtil.toString(this.element) + ". Prefix from content is " + prefix + ". Found namespaces " + namespaces);
        }
        return Maps.immutableEntry((Object)prefix, (Object)namespaces.get(prefix));
    }

    public List<XmlElement> getChildElementsWithSameNamespace(final String childName) {
        List<XmlElement> children = this.getChildElementsWithinNamespace(this.getNamespace());
        return Lists.newArrayList((Iterable)Collections2.filter(children, (Predicate)new Predicate<XmlElement>(){

            public boolean apply(@Nullable XmlElement xmlElement) {
                return xmlElement.getName().equals(childName);
            }
        }));
    }

    public void checkUnrecognisedElements(List<XmlElement> recognisedElements, XmlElement ... additionalRecognisedElements) {
        List<XmlElement> childElements = this.getChildElements();
        childElements.removeAll(recognisedElements);
        for (XmlElement additionalRecognisedElement : additionalRecognisedElements) {
            childElements.remove(additionalRecognisedElement);
        }
        Preconditions.checkState((boolean)childElements.isEmpty(), (String)"Unrecognised elements %s in %s", (Object[])new Object[]{childElements, this});
    }

    public void checkUnrecognisedElements(XmlElement ... additionalRecognisedElements) {
        this.checkUnrecognisedElements(Collections.emptyList(), additionalRecognisedElements);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        XmlElement that = (XmlElement)o;
        return this.element.isEqualNode(that.element);
    }

    public int hashCode() {
        return this.element.hashCode();
    }

    public boolean hasNamespace() {
        try {
            this.getNamespaceAttribute();
        }
        catch (IllegalStateException e) {
            try {
                this.getNamespace();
            }
            catch (IllegalStateException e1) {
                return false;
            }
            return true;
        }
        return true;
    }

    private static interface ElementFilteringStrategy {
        public boolean accept(Element var1);
    }
}

