/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.osgi;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.net.InetSocketAddress;
import org.osgi.framework.BundleContext;

public class NetconfConfigUtil {
    private static final String PREFIX_PROP = "netconf.";
    private static final String PORT_SUFFIX_PROP = ".port";
    private static final String ADDRESS_SUFFIX_PROP = ".address";
    private static final String CLIENT_PROP = ".client";
    private static final String PRIVATE_KEY_PATH_PROP = ".pk.path";

    public static InetSocketAddress extractTCPNetconfAddress(BundleContext context, String exceptionMessageIfNotFound, boolean forClient) {
        Optional<InetSocketAddress> inetSocketAddressOptional = NetconfConfigUtil.extractSomeNetconfAddress(context, InfixProp.tcp, exceptionMessageIfNotFound, forClient);
        if (!inetSocketAddressOptional.isPresent()) {
            throw new IllegalStateException("Netconf tcp address not found." + exceptionMessageIfNotFound);
        }
        return (InetSocketAddress)inetSocketAddressOptional.get();
    }

    public static Optional<InetSocketAddress> extractSSHNetconfAddress(BundleContext context, String exceptionMessage) {
        return NetconfConfigUtil.extractSomeNetconfAddress(context, InfixProp.ssh, exceptionMessage, false);
    }

    public static String getPrivateKeyPath(BundleContext context) {
        return NetconfConfigUtil.getPropertyValue(context, PREFIX_PROP + (Object)((Object)InfixProp.ssh) + PRIVATE_KEY_PATH_PROP);
    }

    private static String getPropertyValue(BundleContext context, String propertyName) {
        String propertyValue = context.getProperty(propertyName);
        if (propertyValue == null) {
            throw new IllegalStateException("Cannot find initial property with name '" + propertyName + "'");
        }
        return propertyValue;
    }

    private static Optional<InetSocketAddress> extractSomeNetconfAddress(BundleContext context, InfixProp infixProp, String exceptionMessage, boolean client) {
        String address = "";
        if (client) {
            address = context.getProperty(PREFIX_PROP + (Object)((Object)infixProp) + CLIENT_PROP + ADDRESS_SUFFIX_PROP);
        }
        if (address == null || address.equals("")) {
            address = context.getProperty(PREFIX_PROP + (Object)((Object)infixProp) + ADDRESS_SUFFIX_PROP);
        }
        if (address == null || address.equals("")) {
            throw new IllegalStateException("Cannot find initial netconf configuration for parameter    netconf." + (Object)((Object)infixProp) + ADDRESS_SUFFIX_PROP + " in config.ini. " + exceptionMessage);
        }
        String portKey = "";
        if (client) {
            portKey = PREFIX_PROP + (Object)((Object)infixProp) + CLIENT_PROP + PORT_SUFFIX_PROP;
        }
        if (portKey == null || portKey.equals("")) {
            portKey = PREFIX_PROP + (Object)((Object)infixProp) + PORT_SUFFIX_PROP;
        }
        String portString = context.getProperty(portKey);
        Preconditions.checkNotNull((Object)portString, (Object)("Netconf port must be specified in properties file with " + portKey));
        try {
            int port = Integer.valueOf(portString);
            return Optional.of((Object)new InetSocketAddress(address, port));
        }
        catch (RuntimeException e) {
            throw new IllegalStateException("Cannot create " + (Object)((Object)infixProp) + " netconf address from address:" + address + " and port:" + portString, e);
        }
    }

    private static enum InfixProp {
        tcp,
        ssh;

    }
}

