/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.controller.netconf.util.messages;

import com.google.common.base.Preconditions;
import io.netty.channel.Channel;
import java.io.InputStream;
import java.util.Map;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import org.opendaylight.controller.netconf.api.NetconfDocumentedException;
import org.opendaylight.controller.netconf.api.NetconfMessage;
import org.opendaylight.controller.netconf.api.NetconfSession;
import org.opendaylight.controller.netconf.util.xml.XMLNetconfUtil;
import org.opendaylight.controller.netconf.util.xml.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class SendErrorExceptionUtil {
    private static final Logger logger = LoggerFactory.getLogger(SendErrorExceptionUtil.class);
    private static XPathExpression rpcErrorExpression = XMLNetconfUtil.compileXPath("/netconf:rpc-reply/netconf:rpc-error");
    private static XPathExpression errorTypeExpression = XMLNetconfUtil.compileXPath("netconf:error-type");
    private static XPathExpression errorTagExpression = XMLNetconfUtil.compileXPath("netconf:error-tag");
    private static XPathExpression errorSeverityExpression = XMLNetconfUtil.compileXPath("netconf:error-severity");

    public static void sendErrorMessage(NetconfSession session, NetconfDocumentedException sendErrorException) {
        logger.trace("Sending error {}", (Object)sendErrorException.getMessage(), (Object)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        session.sendMessage(new NetconfMessage(errorDocument));
    }

    public static void sendErrorMessage(Channel channel, NetconfDocumentedException sendErrorException) {
        logger.trace("Sending error {}", (Object)sendErrorException.getMessage(), (Object)sendErrorException);
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        channel.writeAndFlush((Object)new NetconfMessage(errorDocument));
    }

    public static void sendErrorMessage(NetconfSession session, NetconfDocumentedException sendErrorException, NetconfMessage incommingMessage) {
        Document errorDocument = SendErrorExceptionUtil.createDocument(sendErrorException);
        logger.trace("Sending error {}", (Object)XmlUtil.toString(errorDocument));
        SendErrorExceptionUtil.tryToCopyAttributes(incommingMessage.getDocument(), errorDocument, sendErrorException);
        session.sendMessage(new NetconfMessage(errorDocument));
    }

    private static void tryToCopyAttributes(Document incommingDocument, Document errorDocument, NetconfDocumentedException sendErrorException) {
        try {
            Element incommingRpc = incommingDocument.getDocumentElement();
            Preconditions.checkState((boolean)incommingRpc.getTagName().equals("rpc"), (Object)"Missing rpc element");
            Element rpcReply = errorDocument.getDocumentElement();
            Preconditions.checkState((boolean)rpcReply.getTagName().equals("rpc-reply"), (Object)"Missing rpc-reply element");
            NamedNodeMap incomingAttributes = incommingRpc.getAttributes();
            for (int i = 0; i < incomingAttributes.getLength(); ++i) {
                Attr attr = (Attr)incomingAttributes.item(i);
                if (attr.getNodeName().equals("xmlns")) continue;
                rpcReply.setAttributeNode((Attr)errorDocument.importNode(attr, true));
            }
        }
        catch (Exception e) {
            logger.warn("Unable to copy incomming attributes to {}, returned rpc-error might be invalid for client", (Object)sendErrorException, (Object)e);
        }
    }

    private static Document createDocument(NetconfDocumentedException sendErrorException) {
        Document originalErrorDocument;
        InputStream errIS = SendErrorExceptionUtil.class.getResourceAsStream("server_error.xml");
        try {
            originalErrorDocument = XmlUtil.readXmlToDocument(errIS);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        Document errorDocument = XmlUtil.createDocumentCopy(originalErrorDocument);
        Node rootNode = errorDocument.getFirstChild();
        Node rpcErrorNode = (Node)XmlUtil.evaluateXPath(rpcErrorExpression, rootNode, XPathConstants.NODE);
        Node errorTypeNode = (Node)XmlUtil.evaluateXPath(errorTypeExpression, rpcErrorNode, XPathConstants.NODE);
        errorTypeNode.setTextContent(sendErrorException.getErrorType().getTagValue());
        Node errorTagNode = (Node)XmlUtil.evaluateXPath(errorTagExpression, rpcErrorNode, XPathConstants.NODE);
        errorTagNode.setTextContent(sendErrorException.getErrorTag().getTagValue());
        Node errorSeverityNode = (Node)XmlUtil.evaluateXPath(errorSeverityExpression, rpcErrorNode, XPathConstants.NODE);
        errorSeverityNode.setTextContent(sendErrorException.getErrorSeverity().getTagValue());
        if (sendErrorException.getErrorInfo() != null && !sendErrorException.getErrorInfo().isEmpty()) {
            Element errorInfoNode = errorDocument.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", "error-info");
            errorInfoNode.setPrefix(rootNode.getPrefix());
            rpcErrorNode.appendChild(errorInfoNode);
            for (Map.Entry errorInfoEntry : sendErrorException.getErrorInfo().entrySet()) {
                Element node = errorDocument.createElementNS("urn:ietf:params:xml:ns:netconf:base:1.0", (String)errorInfoEntry.getKey());
                node.setTextContent((String)errorInfoEntry.getValue());
                errorInfoNode.appendChild(node);
            }
        }
        return errorDocument;
    }
}

